/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.xml;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.PairProcessor;
import com.intellij.util.PatternValuesIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.config.AbstractTagInjection;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class XmlLanguageInjector
implements MultiHostInjector {
    private volatile XmlIndex myXmlIndex;
    private final Project myProject;

    public XmlLanguageInjector(@NotNull Project project) {
        if (project == null) {
            XmlLanguageInjector.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlTag.class, XmlAttributeValue.class);
        if (list == null) {
            XmlLanguageInjector.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        XmlElement xmlElement;
        if (registrar == null) {
            XmlLanguageInjector.$$$reportNull$$$0(2);
        }
        if (host == null) {
            XmlLanguageInjector.$$$reportNull$$$0(3);
        }
        if (!this.isInIndex(xmlElement = (XmlElement)host)) {
            return;
        }
        TreeSet<TextRange> ranges = new TreeSet<TextRange>(InjectorUtils.RANGE_COMPARATOR);
        PsiFile containingFile = xmlElement.getContainingFile();
        Ref unparsableRef = Ref.create();
        this.getInjectedLanguage((PsiElement)xmlElement, (Ref<? super Boolean>)unparsableRef, (PairProcessor<? super Language, ? super List<InjectorUtils.InjectionInfo>>)((PairProcessor)(language, list) -> {
            for (InjectorUtils.InjectionInfo trinity : list) {
                if (!ranges.contains(trinity.range().shiftRight(trinity.host().getTextRange().getStartOffset()))) continue;
                return true;
            }
            for (InjectorUtils.InjectionInfo trinity : list) {
                if (trinity.host().getContainingFile() != containingFile) continue;
                TextRange textRange = trinity.range();
                ranges.add(textRange.shiftRight(trinity.host().getTextRange().getStartOffset()));
            }
            InjectorUtils.registerInjection(language, containingFile, list, registrar, it -> {
                InjectorUtils.registerSupport(it, InjectorUtils.findNotNullInjectionSupport("xml"), true);
                if (Boolean.TRUE.equals(unparsableRef.get())) {
                    it.frankensteinInjection(true);
                }
            });
            return true;
        }));
    }

    void getInjectedLanguage(PsiElement place, final Ref<? super Boolean> unparsableRef, PairProcessor<? super Language, ? super List<InjectorUtils.InjectionInfo>> processor) {
        block14: {
            block15: {
                if (!(place instanceof XmlTag)) break block15;
                XmlTag xmlTag = (XmlTag)place;
                List<BaseInjection> injections = this.getConfiguration().getInjections("xml");
                int injectionsSize = injections.size();
                for (int i = 0; i < injectionsSize; ++i) {
                    Language language;
                    final BaseInjection injection = injections.get(i);
                    if (!injection.acceptsPsiElement((PsiElement)xmlTag) || (language = InjectedLanguage.findLanguageById(injection.getInjectedLanguageId())) == null) continue;
                    final boolean separateFiles = !injection.isSingleFile() && StringUtil.isNotEmpty((String)injection.getValuePattern());
                    final ArrayList result = new ArrayList();
                    xmlTag.acceptChildren(new PsiElementVisitor(){

                        public void visitElement(@NotNull PsiElement element) {
                            if (element == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (element instanceof XmlText) {
                                if (!(element instanceof PsiLanguageInjectionHost) || element.getTextLength() == 0) {
                                    return;
                                }
                                if (!injection.shouldBeIgnored(element)) {
                                    List<TextRange> list = injection.getInjectedArea(element);
                                    InjectedLanguage l = InjectedLanguage.create(injection.getInjectedLanguageId(), injection.getPrefix(), injection.getSuffix(), false);
                                    for (TextRange textRange : list) {
                                        result.add(new InjectorUtils.InjectionInfo((PsiLanguageInjectionHost)element, l, textRange));
                                    }
                                }
                            } else if (element instanceof XmlTag) {
                                if (!separateFiles) {
                                    unparsableRef.set((Object)Boolean.TRUE);
                                }
                                if (injection instanceof AbstractTagInjection && ((AbstractTagInjection)injection).isApplyToSubTags()) {
                                    element.acceptChildren((PsiElementVisitor)this);
                                }
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/intelliLang/inject/xml/XmlLanguageInjector$1", "visitElement"));
                        }
                    });
                    if (!result.isEmpty()) {
                        if (separateFiles) {
                            for (InjectorUtils.InjectionInfo trinity : result) {
                                processor.process((Object)language, Collections.singletonList(trinity));
                            }
                        } else {
                            processor.process((Object)language, result);
                        }
                    }
                    if (!injection.isTerminal()) {
                        continue;
                    }
                    break block14;
                }
                break block14;
            }
            if (!(place instanceof XmlAttributeValue)) break block14;
            XmlAttributeValue value = (XmlAttributeValue)place;
            PsiElement injections = place.getParent();
            if (injections instanceof XmlAttribute) {
                XmlAttribute attribute = (XmlAttribute)injections;
                PsiElement[] children = value.getChildren();
                if (children.length < 3 || !(children[1] instanceof XmlToken) || ((XmlToken)children[1]).getTokenType() != XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                    return;
                }
                List<BaseInjection> injections2 = this.getConfiguration().getInjections("xml");
                int size = injections2.size();
                for (int i = 0; i < size; ++i) {
                    Language language;
                    BaseInjection injection = injections2.get(i);
                    if (!injection.acceptsPsiElement((PsiElement)attribute) || injection.shouldBeIgnored((PsiElement)value) || (language = InjectedLanguage.findLanguageById(injection.getInjectedLanguageId())) == null) continue;
                    boolean separateFiles = !injection.isSingleFile() && StringUtil.isNotEmpty((String)injection.getValuePattern());
                    List<TextRange> ranges = injection.getInjectedArea((PsiElement)value);
                    if (ranges.isEmpty()) continue;
                    ArrayList<InjectorUtils.InjectionInfo> result = new ArrayList<InjectorUtils.InjectionInfo>();
                    InjectedLanguage l = InjectedLanguage.create(injection.getInjectedLanguageId(), injection.getPrefix(), injection.getSuffix(), false);
                    for (TextRange textRange : ranges) {
                        result.add(new InjectorUtils.InjectionInfo((PsiLanguageInjectionHost)value, l, textRange));
                    }
                    if (separateFiles) {
                        for (InjectorUtils.InjectionInfo info : result) {
                            processor.process((Object)language, Collections.singletonList(info));
                        }
                    } else {
                        processor.process((Object)language, result);
                    }
                    if (!injection.isTerminal()) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private Configuration getConfiguration() {
        return Configuration.getProjectInstance(this.myProject);
    }

    private boolean isInIndex(XmlElement xmlElement) {
        XmlTag tag;
        XmlIndex index = this.getXmlAnnotatedElementsValue();
        if (xmlElement instanceof XmlAttributeValue) {
            xmlElement = (XmlElement)xmlElement.getParent();
        }
        if (xmlElement instanceof XmlAttribute) {
            XmlAttribute attribute = (XmlAttribute)xmlElement;
            if (XmlLanguageInjector.areThereInjectionsWithText(attribute.getLocalName(), index)) {
                return true;
            }
            if (XmlLanguageInjector.areThereInjectionsWithText(attribute.getValue(), index)) {
                return true;
            }
            tag = attribute.getParent();
            if (tag == null) {
                return false;
            }
        } else if (xmlElement instanceof XmlTag) {
            tag = (XmlTag)xmlElement;
        } else {
            return false;
        }
        return XmlLanguageInjector.areThereInjectionsWithText(tag.getLocalName(), index);
    }

    private static boolean areThereInjectionsWithText(String text, XmlIndex index) {
        if (text == null) {
            return false;
        }
        if (index.strings.contains(text)) {
            return true;
        }
        Pattern pattern = index.pattern;
        return pattern != null && pattern.matcher(text).matches();
    }

    private XmlIndex getXmlAnnotatedElementsValue() {
        Configuration configuration = this.getConfiguration();
        XmlIndex index = this.myXmlIndex;
        if (index == null || configuration.getModificationCount() != index.modCount) {
            HashMap<ElementPattern<? extends PsiElement>, BaseInjection> map = new HashMap<ElementPattern<? extends PsiElement>, BaseInjection>();
            for (BaseInjection injection : configuration.getInjections("xml")) {
                for (InjectionPlace place : injection.getInjectionPlaces()) {
                    if (!place.isEnabled() || place.getElementPattern() == null) continue;
                    map.put(place.getElementPattern(), injection);
                }
            }
            Set stringSet = PatternValuesIndex.buildStringIndex(map.keySet());
            this.myXmlIndex = index = new XmlIndex(configuration.getModificationCount(), XmlLanguageInjector.buildPattern(stringSet), stringSet);
        }
        return index;
    }

    @Nullable
    private static Pattern buildPattern(Collection<String> stringSet) {
        StringBuilder sb = new StringBuilder();
        for (String s : stringSet) {
            if (!InjectorUtils.isRegexp(s)) continue;
            if (!sb.isEmpty()) {
                sb.append('|');
            }
            sb.append("(?:").append(s).append(")");
        }
        return sb.isEmpty() ? null : Pattern.compile(sb.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/xml/XmlLanguageInjector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/xml/XmlLanguageInjector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    record XmlIndex(long modCount, @Nullable Pattern pattern, @NotNull Collection<String> strings) {
        @NotNull
        private final Collection<String> strings;

        /*
         * WARNING - void declaration
         */
        XmlIndex(long modCount, @Nullable Pattern pattern, @NotNull Collection<String> collection) {
            void strings;
            if (collection == null) {
                XmlIndex.$$$reportNull$$$0(0);
            }
            this.modCount = modCount;
            this.pattern = pattern;
            this.strings = strings;
        }

        @NotNull
        public Collection<String> strings() {
            Collection<String> collection = this.strings;
            if (collection == null) {
                XmlIndex.$$$reportNull$$$0(1);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/intelliLang/inject/xml/XmlLanguageInjector$XmlIndex";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/intelliLang/inject/xml/XmlLanguageInjector$XmlIndex";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "strings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

