/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSOverflowTypeTextStringBuilder;
import com.intellij.lang.javascript.psi.JSPresentableTypeTextStringBuilder;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveTypeTransformer;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeTextStringBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTransformer;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.types.AtomicLongRingArray;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformer;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformerBase;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformerResolvedIdBase;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeIdCache;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutionContextImpl;
import com.intellij.lang.javascript.psi.types.JSTypesAssignableError;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptCompilerType;
import com.intellij.lang.javascript.settings.JSSymbolPresentationProvider;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.StackOverflowPreventedException;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class JSTypeBaseImpl
extends UserDataHolderBase
implements JSType {
    private static final AtomicLong TYPE_INDEXER = new AtomicLong(1L);
    public static final Key<Boolean> CALL_ENV_KEY = Key.create((String)"js.type.is.call.env");
    public static final Key<Boolean> EQ_EVALUATED = Key.create((String)"eq.evaluated");
    public static final Key<Boolean> EQ_SKIP_SCOPE = Key.create((String)"eq.no.lang");
    public static final Key<Boolean> IS_CHOOSING_FROM_OVERLOADS = Key.create((String)"is.choosing.from.overloads");
    public static final Key<Boolean> IS_CHECKING_ASSIGNABILITY = Key.create((String)"is.checking.assignability");
    public static final Key<Boolean> IS_FORCED_SUBSTITUTION = Key.create((String)"is.forced.substitution");
    private static final JSType.LocalTypeKey RECORD_TYPE_CACHE = JSType.createLocalTypeKey("js.record.type.cache.base");
    protected static final Key<Set<JSResolvedTypeId>> VISITED_TYPES = Key.create((String)"js.type.visited.set");
    private static boolean ASSERT_ON_RECORD_TYPE_USAGE = false;
    private static final int MAX_TSC_REPLACE_HIERARCHY_DEPTH = 7;
    private static final Key<?>[] IDS = new Key[]{CALL_ENV_KEY, JSTypeComparingCache.SUBTYPING_CONTEXT, JSGenericTypesEvaluator.ourGenericArgumentsMapKey, JSGenericTypesEvaluator.ourHadContravariantGenerics, JSRecursiveTypeUtil.ASSIGNABLE_KEY, JSTypeComparingContextService.NULL_CHECKS, JSTypeComparingContextService.LOCATION};
    @Nullable
    private volatile JSResolvedTypeIdImpl myResolvedKey;
    @Nullable
    private volatile AtomicLongRingArray myEqualityCache;
    @NotNull
    private final JSTypeSource mySource;
    private int myHashCode;
    private final long myId;
    private static final Map<Pair<Integer, Boolean>, JSType.LocalTypeKey> ourSubstitueKeyMap = new HashMap<Pair<Integer, Boolean>, JSType.LocalTypeKey>();

    @NotNull
    public static JSType getSelfNoTransformationType() {
        JSType jSType = Holder.SELF_NO_TRANSFORMATION;
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(0);
        }
        return jSType;
    }

    @NotNull
    public static JSType getNullType() {
        JSType jSType = Holder.NULL_TYPE;
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(1);
        }
        return jSType;
    }

    @TestOnly
    public static void assertOnRecordTypeUsage(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(2);
        }
        ASSERT_ON_RECORD_TYPE_USAGE = true;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ASSERT_ON_RECORD_TYPE_USAGE = false;
            }
        });
    }

    @Contract(value="!null->!null")
    public static ProcessingContext copyProcessingContextWithoutComparingCache(@Nullable ProcessingContext context2) {
        if (context2 == null) {
            return null;
        }
        ProcessingContext newContext = new ProcessingContext();
        for (Key<?> id : IDS) {
            Object value = context2.get(id);
            if (value == null) continue;
            newContext.put(id, value);
        }
        return newContext;
    }

    protected JSTypeBaseImpl(@NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(3);
        }
        this.myHashCode = 0;
        this.mySource = source;
        long id = TYPE_INDEXER.incrementAndGet();
        this.myId = id == 0L ? TYPE_INDEXER.incrementAndGet() : id;
    }

    @Override
    @NotNull
    public final JSType getResolveCachedType(@NotNull Supplier<? extends JSType> factory, @NotNull JSType.LocalTypeKey cacheKey) {
        JSResolvedTypeIdImpl id;
        JSType value;
        if (factory == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(4);
        }
        if (cacheKey == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(5);
        }
        JSType jSType = (value = (id = this.getResolvedTypeId()).getLocalCachedValue(cacheKey, factory)) == null ? this : value;
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(6);
        }
        return jSType;
    }

    @Override
    @NotNull
    public final String getTypeText() {
        String string = JSType.super.getTypeText();
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public final String getResolvedTypeText() {
        String string = JSType.super.getResolvedTypeText();
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getTypeText(@NotNull JSType.TypeTextFormat format) {
        if (format == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(9);
        }
        JSTypeTextStringBuilder builder2 = format == JSType.TypeTextFormat.PRESENTABLE ? new JSPresentableTypeTextStringBuilder() : new JSOverflowTypeTextStringBuilder(format);
        this.buildTypeTextInner(format, builder2);
        String string = builder2.getResult();
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public final void buildTypeText(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(11);
        }
        if (builder2 == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(12);
        }
        this.buildTypeTextInner(format, builder2);
    }

    private void buildTypeTextInner(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(13);
        }
        if (builder2 == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(14);
        }
        ProgressManager.checkCanceled();
        if (!builder2.startProcessType(this)) {
            return;
        }
        this.buildTypeTextImpl(format, builder2);
        builder2.endProcessType(this);
    }

    protected abstract void buildTypeTextImpl(@NotNull JSType.TypeTextFormat var1, @NotNull JSTypeTextBuilder var2);

    @Override
    @NotNull
    public final JSTypeSource getSource() {
        JSTypeSource jSTypeSource = this.mySource;
        if (jSTypeSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(15);
        }
        return jSTypeSource;
    }

    @Override
    public final boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        boolean result2 = this.isDirectlyAssignableTypeWithCache(elementType, processingContext);
        if (processingContext != null) {
            JSTypesAssignableError.updateAssignableChain(this, elementType, result2, processingContext);
        }
        return result2;
    }

    private boolean isDirectlyAssignableTypeWithCache(@Nullable JSType elementType, @Nullable ProcessingContext processingContextOrNull) {
        PsiElement location;
        boolean isFromJavaScript;
        if (elementType == null) {
            return true;
        }
        if (this.isDirectAssignableTypeSimple(elementType, processingContextOrNull)) {
            return true;
        }
        ProgressManager.checkCanceled();
        @NotNull ProcessingContext processingContext = processingContextOrNull != null ? processingContextOrNull : new ProcessingContext();
        Function doSubstitute = jsType -> {
            JSType expanded = TypeScriptTypeRelations.getCanonicalTypeForExoticLiterals(jsType.substitute(JSTypeBaseImpl.createSubstitutionContextForAssignability(processingContext)));
            return expanded != null ? expanded : JSAnyType.get(this.getSource());
        };
        JSType expandThis = (JSType)doSubstitute.fun((Object)this);
        JSType expandRType = (JSType)doSubstitute.fun((Object)elementType);
        if (this.isTypeScript()) {
            JSType unwrappedRType;
            JSType unwrappedThis;
            if (expandThis instanceof JSAliasTypeImpl) {
                JSAliasTypeImpl alias = (JSAliasTypeImpl)expandThis;
                v0 = alias.getAlias();
            } else {
                v0 = unwrappedThis = expandThis;
            }
            if (expandRType instanceof JSAliasTypeImpl) {
                JSAliasTypeImpl alias = (JSAliasTypeImpl)expandRType;
                v1 = alias.getAlias();
            } else {
                v1 = unwrappedRType = expandRType;
            }
            if (unwrappedThis instanceof JSGenericTypeImpl && unwrappedRType instanceof JSGenericTypeImpl && JSTypeBaseImpl.isDirectlyAssignableInClassHierarchy(unwrappedThis, unwrappedRType, processingContext)) {
                return true;
            }
        }
        boolean bl = isFromJavaScript = (location = (PsiElement)processingContext.get(JSTypeComparingContextService.LOCATION)) != null && DialectDetector.isJavaScript(location);
        if (expandThis instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericThis = (JSGenericTypeImpl)expandThis;
            expandThis = genericThis.forceExpand(JSTypeBaseImpl.createSubstitutionContextForAssignability(processingContext));
            if (isFromJavaScript) {
                expandThis = JSTypeWithIncompleteSubstitution.substituteCompletely(expandThis);
            }
        }
        if (expandRType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericRType = (JSGenericTypeImpl)expandRType;
            expandRType = genericRType.forceExpand(JSTypeBaseImpl.createSubstitutionContextForAssignability(processingContext));
            if (isFromJavaScript) {
                expandRType = JSTypeWithIncompleteSubstitution.substituteCompletely(expandRType);
            }
        }
        if (this != expandThis || elementType != expandRType) {
            JSType expandThis_ = expandThis;
            return JSRecursiveTypeUtil.computeWithRecursiveTypes(JSGenericTypeImpl.getGenericOwnerIdOrSelfId(this), JSGenericTypeImpl.getGenericOwnerIdOrSelfId(elementType), JSRecursiveTypeUtil.ASSIGNABLE_KEY, expandRType, processingContext, (_expandRType, _processingContext) -> expandThis_.isDirectlyAssignableType(_expandRType, _processingContext));
        }
        return JSRecursiveTypeUtil.computeWithRecursiveTypes(JSGenericTypeImpl.getGenericOwnerIdOrSelfId(this), JSGenericTypeImpl.getGenericOwnerIdOrSelfId(elementType), JSRecursiveTypeUtil.ASSIGNABLE_KEY, elementType, processingContext, this::isDirectlyAssignableUnderRecursionProtection);
    }

    private static boolean isDirectlyAssignableInClassHierarchy(@NotNull JSType expandedThis, @NotNull JSType expandedRType, @NotNull ProcessingContext processingContext) {
        JSGenericMappings genericArguments;
        if (expandedThis == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(16);
        }
        if (expandedRType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(17);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(18);
        }
        if ((genericArguments = (JSGenericMappings)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey)) == null) {
            JSTypeCastUtil.AssignableResult type2 = JSTypeCastUtil.isDirectlyAssignableInClassHierarchy(expandedThis, expandedRType, processingContext);
            if (type2.isStrict() && type2.isAssignable()) {
                return true;
            }
        } else {
            JSGenericMappings localGenericArguments = genericArguments.copy();
            processingContext.put(JSGenericTypesEvaluator.ourGenericArgumentsMapKey, (Object)localGenericArguments);
            JSTypeCastUtil.AssignableResult type3 = JSTypeCastUtil.isDirectlyAssignableInClassHierarchy(expandedThis, expandedRType, processingContext);
            processingContext.put(JSGenericTypesEvaluator.ourGenericArgumentsMapKey, (Object)genericArguments);
            if (type3.isStrict() && type3.isAssignable()) {
                ProcessingContext localProcessingContext = JSTypeComparingContextService.createProcessingContextWithCache(null);
                localProcessingContext.put(JSTypeComparingContextService.NULL_CHECKS, (Object)((Boolean)processingContext.get(JSTypeComparingContextService.NULL_CHECKS)));
                localProcessingContext.put(JSTypeComparingContextService.LOCATION, (Object)((PsiElement)processingContext.get(JSTypeComparingContextService.LOCATION)));
                localProcessingContext.put(JSGenericTypesEvaluator.genericParametersProvider, (Object)((Supplier)processingContext.get(JSGenericTypesEvaluator.genericParametersProvider)));
                if (!TypeScriptGenericTypesEvaluator.hasGenericsCompatibilityErrors(localGenericArguments.getMapping(), localProcessingContext, null)) {
                    genericArguments.putAll(localGenericArguments);
                    return true;
                }
            }
        }
        return false;
    }

    @ApiStatus.Internal
    protected static JSTypeSubstitutionContext createSubstitutionContextForAssignability(@Nullable ProcessingContext processingContext) {
        JSTypeSubstitutionContextImpl substitutionContext = new JSTypeSubstitutionContextImpl(processingContext);
        if (processingContext != null && Boolean.TRUE.equals(processingContext.get(IS_CHOOSING_FROM_OVERLOADS))) {
            substitutionContext.putUserData(IS_CHOOSING_FROM_OVERLOADS, true);
        }
        substitutionContext.putUserData(IS_CHECKING_ASSIGNABILITY, true);
        return substitutionContext;
    }

    private boolean isDirectlyAssignableUnderRecursionProtection(@NotNull JSType elementType, ProcessingContext finalProcessingContext) {
        JSTypeComparingCache cache;
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(19);
        }
        if ((cache = (JSTypeComparingCache)finalProcessingContext.get(JSTypeComparingContextService.TYPE_COMPARATOR)) != null) {
            JSTypeCastUtil.AssignableResult assignableResult = cache.areAssignableTypes(this, elementType, finalProcessingContext);
            if (assignableResult.isStrict()) {
                this.checkCachedValue(elementType, finalProcessingContext, assignableResult);
                return assignableResult.isAssignable();
            }
            if (assignableResult != JSTypeCastUtil.AssignableResult.NO_CACHE) {
                boolean result2 = this.calculateAssignabilityWithoutCache(elementType, finalProcessingContext);
                cache.putAssignableTypes(this, elementType, finalProcessingContext, JSTypeCastUtil.toStrictAssignable(result2));
                return result2;
            }
        }
        return this.calculateAssignabilityWithoutCache(elementType, finalProcessingContext);
    }

    private boolean isDirectAssignableTypeSimple(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(20);
        }
        if (this instanceof JSAnyType) {
            return true;
        }
        if (this.isTypeScript() && elementType == JSUnknownType.TS_INSTANCE) {
            return false;
        }
        if (this.isEquivalentTo(elementType, processingContext, !this.isEcma())) {
            return true;
        }
        if (JSTypeComparingContextService.isSubtyping(processingContext) && elementType instanceof JSAnyType) {
            return false;
        }
        return this.checkAlwaysAssignableType(elementType, processingContext);
    }

    protected boolean checkAlwaysAssignableType(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(21);
        }
        return JSTypeCastUtil.isAlwaysAssignableType(elementType, this.isJavaScript() && elementType.isJavaScript(), processingContext, null);
    }

    private boolean calculateAssignabilityWithoutCache(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSFreshObjectLiteralType freshType;
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(22);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(23);
        }
        JSFreshObjectLiteralType jSFreshObjectLiteralType = freshType = elementType instanceof JSFreshObjectLiteralType ? (JSFreshObjectLiteralType)elementType : null;
        if (freshType != null) {
            elementType = ((JSFreshObjectLiteralType)elementType).removeFreshness();
        }
        return this.isDirectlyAssignableTypeImpl(elementType, processingContext) && (!this.isTypeScript() || freshType == null || JSTypeCastUtil.compareByExcessProperties(this, freshType, processingContext));
    }

    private void checkCachedValue(@NotNull JSType elementType, @NotNull ProcessingContext processingContext, @NotNull JSTypeCastUtil.AssignableResult fromCache) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(24);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(25);
        }
        if (fromCache == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(26);
        }
        if (!Holder.TEST_MODE) {
            return;
        }
        ProcessingContext newContext = JSTypeBaseImpl.copyProcessingContextWithoutComparingCache(processingContext);
        boolean isAssignable = this.calculateAssignabilityWithoutCache(elementType, newContext);
        if (fromCache.isAssignable() != isAssignable) {
            String message = String.format("checkCachedValue failed. This: %s;\nElement: %s;\nFrom cache: %s;\nIsAssignable:%s", new Object[]{this.getTypeText(), elementType.getTypeText(), fromCache, isAssignable});
            Logger.getInstance(this.getClass()).error(message);
        }
    }

    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(27);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(28);
        }
        return this.isDirectlyAssignableTypeCommon(elementType, processingContext).isAssignable();
    }

    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(29);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(30);
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.isDirectlyAssignableTypeCommon(this, elementType, processingContext);
        if (assignableResult == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(31);
        }
        return assignableResult;
    }

    @Override
    public final void accept(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(32);
        }
        visitor.visitJSTypeBaseImpl(this);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(33);
        }
        if (!Holder.TEST_MODE) {
            return;
        }
        List fields = ReflectionUtil.collectFields(this.getClass());
        fields.forEach(el -> {
            Class<?> componentType;
            if (Modifier.isStatic(el.getModifiers())) {
                return;
            }
            Class<?> type2 = el.getType();
            if (JSType.class.isAssignableFrom(type2)) {
                throw new AssertionError((Object)("Type must visit all nested types " + String.valueOf(this.getClass())));
            }
            if (Collection.class.isAssignableFrom(type2) && (componentType = type2.getComponentType()) != null && JSType.class.isAssignableFrom(type2)) {
                throw new AssertionError((Object)("Type must visit all nested types " + String.valueOf(this.getClass())));
            }
        });
    }

    @Nullable
    public final PsiFile getScope() {
        return this.mySource.getScope();
    }

    @NotNull
    protected final JSTypeHelper getTypeHelper() {
        JSLanguageDialect language = switch (this.getSource().getLanguage()) {
            default -> throw new IncompatibleClassChangeError();
            case JSTypeSource.SourceLanguage.TS -> JavaScriptSupportLoader.TYPESCRIPT;
            case JSTypeSource.SourceLanguage.AS -> FlexSupportLoader.ECMA_SCRIPT_L4;
            case JSTypeSource.SourceLanguage.JS -> JavascriptLanguage.INSTANCE;
        };
        JSTypeHelper jSTypeHelper = JSDialectSpecificHandlersFactory.forLanguage((Language)language).getTypeHelper();
        if (jSTypeHelper == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(34);
        }
        return jSTypeHelper;
    }

    @Override
    @NotNull
    public final JSType transformTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> transformation) {
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(35);
        }
        if (transformation instanceof JSRecursiveTypeTransformer) {
            JSType jSType = this.transformTypeHierarchy((JSRecursiveTypeTransformer)transformation);
            if (jSType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(36);
            }
            return jSType;
        }
        JSCacheableTypeTransformer transformer = new JSCacheableTypeTransformer(transformation);
        JSType jSType = this.transformTypeHierarchy(transformer);
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(37);
        }
        return jSType;
    }

    @Override
    @NotNull
    public JSType transformTypeHierarchy(@NotNull JSRecursiveTypeTransformer transformation) {
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(38);
        }
        ProgressManager.checkCanceled();
        JSType jSType = transformation.transformRecursive(this, this::transformTypeOrCopyWithTransformation);
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(39);
        }
        return jSType;
    }

    @Override
    @NotNull
    public JSType substituteCompilerTypesInTypeHierarchy() {
        JSTypeBaseImpl jSTypeBaseImpl = this;
        if (jSTypeBaseImpl instanceof TypeScriptCompilerType) {
            TypeScriptCompilerType compilerType = (TypeScriptCompilerType)((Object)jSTypeBaseImpl);
            return JSTypeBaseImpl.substituteCompilerType(compilerType, new HashSet<JSType>());
        }
        return this.substituteCompilerTypesInTypeHierarchy(new HashSet<JSType>());
    }

    @NotNull
    private JSType substituteCompilerTypesInTypeHierarchy(Set<JSType> substitutedTypes) {
        return this.transformTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)type2 -> {
            if (type2 instanceof TypeScriptCompilerType) {
                TypeScriptCompilerType compilerType = (TypeScriptCompilerType)type2;
                if (substitutedTypes.size() < 7 && substitutedTypes.add((JSType)type2)) {
                    try {
                        JSType jSType = JSTypeBaseImpl.substituteCompilerType(compilerType, substitutedTypes);
                        return jSType;
                    }
                    finally {
                        substitutedTypes.remove(type2);
                    }
                }
            }
            return type2;
        }));
    }

    @NotNull
    private static JSType substituteCompilerType(TypeScriptCompilerType compilerType, Set<JSType> substitutedTypes) {
        JSType result2 = compilerType.asJSType(true);
        if (result2 == null) {
            result2 = compilerType.substitute();
        }
        if (result2 instanceof JSTypeBaseImpl) {
            JSTypeBaseImpl typeBase = (JSTypeBaseImpl)result2;
            return typeBase.substituteCompilerTypesInTypeHierarchy(substitutedTypes);
        }
        JSType jSType = result2;
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(40);
        }
        return jSType;
    }

    @NotNull
    private JSType transformTypeOrCopyWithTransformation(@NotNull Function<? super JSType, ? extends JSType> transformation) {
        JSType transformedType;
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(41);
        }
        if (this != (transformedType = (JSType)transformation.fun((Object)this))) {
            if (transformedType == JSTypeBaseImpl.getSelfNoTransformationType()) {
                JSTypeBaseImpl jSTypeBaseImpl = this;
                if (jSTypeBaseImpl == null) {
                    JSTypeBaseImpl.$$$reportNull$$$0(42);
                }
                return jSTypeBaseImpl;
            }
            this.checkUselessCopy(transformation, transformedType);
            JSType jSType = transformedType;
            if (jSType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(43);
            }
            return jSType;
        }
        JSType result2 = this.copyTypeHierarchy(transformation, this.mySource);
        this.checkUselessCopy(transformation, result2);
        JSType jSType = result2;
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(44);
        }
        return jSType;
    }

    private void checkUselessCopy(@NotNull Function<? super JSType, ? extends JSType> transformation, @NotNull JSType result2) {
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(45);
        }
        if (result2 == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(46);
        }
        if (!Holder.TEST_MODE) {
            return;
        }
        if (transformation instanceof JSCacheableTypeTransformerResolvedIdBase && result2.getSource() == this.getSource() && result2 != this && result2.getResolvedTypeId().equals(this.getResolvedTypeId())) {
            Logger.getInstance(this.getClass()).error("Useless type copy " + this.getTypeText() + ". \nTypes must be the same if there are no changes in nested types.");
        }
    }

    private void checkSymmetrical(@NotNull JSType rType, @NotNull ProcessingContext oldContext, boolean result2, boolean allowResolve) {
        if (rType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(47);
        }
        if (oldContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(48);
        }
        if (!Holder.TEST_MODE) {
            return;
        }
        ProcessingContext context2 = new ProcessingContext();
        boolean eqEvaluated = allowResolve && oldContext.get(EQ_EVALUATED) == Boolean.TRUE;
        boolean eqSkipScope = allowResolve && oldContext.get(EQ_SKIP_SCOPE) == Boolean.TRUE;
        JSType thisType = this;
        if (eqEvaluated) {
            context2.put(EQ_EVALUATED, (Object)Boolean.TRUE);
            thisType = JSTypeBaseImpl.expandCodeBased(this);
            rType = JSTypeBaseImpl.expandCodeBased(rType);
        }
        if (eqSkipScope) {
            context2.put(EQ_SKIP_SCOPE, (Object)true);
        }
        if (result2 != ((JSTypeBaseImpl)rType).isEquivalentToWithSameClass(thisType, context2, allowResolve)) {
            Logger.getInstance(this.getClass()).error("isEquivalentTo must be a symmetrical relation: " + this.getTypeText() + ", " + rType.getTypeText() + ": class " + thisType.getClass().getName());
        }
    }

    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        if (childTransform == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(49);
        }
        if (newSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(50);
        }
        JSTypeBaseImpl jSTypeBaseImpl = this;
        if (jSTypeBaseImpl == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(51);
        }
        return jSTypeBaseImpl;
    }

    @Override
    public final boolean isEquivalentTo(@Nullable JSType type2, @Nullable ProcessingContext processingContext) {
        return this.isEquivalentTo(type2, processingContext, true);
    }

    @Override
    public boolean isEquivalentTo(@Nullable JSType type2, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        AtomicLongRingArray store;
        Class<?> typeClass;
        Class<?> thisClass;
        boolean eqEvaluated;
        if (this == type2) {
            return true;
        }
        if (type2 == null) {
            return false;
        }
        boolean bl = eqEvaluated = processingContext != null && allowResolve && processingContext.get(EQ_EVALUATED) == Boolean.TRUE;
        if (eqEvaluated) {
            JSType thisType = JSTypeBaseImpl.expandCodeBased(this);
            JSType rType = JSTypeBaseImpl.expandCodeBased(type2);
            if (thisType != this || type2 != rType) {
                return thisType.isEquivalentTo(rType, processingContext, true);
            }
        }
        if (!allowResolve) {
            JSTypeSource rSource = type2.getSource();
            JSTypeSource thisSource = this.getSource();
            if (rSource.getLanguage() != thisSource.getLanguage()) {
                return false;
            }
            if (rSource.isStrict() != thisSource.isStrict()) {
                return false;
            }
        }
        if (!(thisClass = this.getClass()).equals(typeClass = type2.getClass())) {
            return false;
        }
        if (!allowResolve && (store = this.myEqualityCache) != null && store.hasLong(((JSTypeBaseImpl)type2).myId)) {
            return true;
        }
        if (processingContext == null) {
            processingContext = new ProcessingContext();
        }
        ProgressManager.checkCanceled();
        boolean result2 = this.isEquivalentToWithSameClass(type2, processingContext, allowResolve);
        this.checkSymmetrical(type2, processingContext, result2, allowResolve);
        if (result2 && !allowResolve) {
            AtomicLongRingArray store2 = this.getEqualityStore();
            store2.addLong(((JSTypeBaseImpl)type2).myId);
        }
        return result2;
    }

    @NotNull
    private static JSType expandCodeBased(@NotNull JSType type2) {
        if (type2 == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(52);
        }
        JSType rType = type2;
        if (type2 instanceof JSCodeBasedType) {
            rType = type2.substitute();
        }
        JSType jSType = rType;
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(53);
        }
        return jSType;
    }

    @Override
    @NotNull
    public final JSType copyWithStrict(boolean strict) {
        JSTypeSource source = this.getSource();
        if (source.isStrict() == strict) {
            JSTypeBaseImpl jSTypeBaseImpl = this;
            if (jSTypeBaseImpl == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(54);
            }
            return jSTypeBaseImpl;
        }
        return this.withNewSource(JSTypeSourceFactory.copyTypeSource(source, strict));
    }

    @NotNull
    protected abstract JSType copyWithNewSource(@NotNull JSTypeSource var1);

    @Override
    @NotNull
    public final JSType withNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(55);
        }
        JSType jSType = this.copyWithNewSource(source);
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(56);
        }
        return jSType;
    }

    protected abstract boolean isEquivalentToWithSameClass(@NotNull JSType var1, @Nullable ProcessingContext var2, boolean var3);

    @Override
    @NotNull
    public final JSRecordType asRecordType() {
        if (ASSERT_ON_RECORD_TYPE_USAGE && (!(this instanceof JSTypeImpl) || ((JSTypeImpl)this).getJSContext() != JSContext.STATIC)) {
            throw new AssertionError((Object)"Record type must be not used");
        }
        ProgressManager.checkCanceled();
        JSRecordType value = this.useCacheForRecordType() ? this.getResolveCachedType(this::asRecordTypeNoCache, RECORD_TYPE_CACHE) : this.asRecordTypeNoCache();
        JSRecordType jSRecordType = value instanceof JSRecordType ? value : JSTypeCastUtil.NO_RECORD_TYPE;
        if (jSRecordType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(57);
        }
        return jSRecordType;
    }

    protected boolean useCacheForRecordType() {
        return false;
    }

    protected boolean useCacheForSubstitute() {
        return this.canBeSubstituted();
    }

    protected final boolean canBeSubstituted() {
        return !(this instanceof JSUtilType) && !(this instanceof JSFunctionType) && !(this instanceof JSAliasTypeImpl) && !(this instanceof JSGenericParameterImpl) && !(this instanceof JSRecordType) && (!(this instanceof TypeScriptCompilerType) || !(this instanceof JSUnionOrIntersectionType));
    }

    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        if (this.isEcma()) {
            JSRecordType jSRecordType = JSTypeCastUtil.NO_RECORD_TYPE;
            if (jSRecordType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(58);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = JSTypeComparingContextService.buildRecordType(this);
        if (jSRecordType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(59);
        }
        return jSRecordType;
    }

    @Override
    @NotNull
    public final JSType substitute() {
        return this.substitute((PsiElement)null);
    }

    @Override
    @NotNull
    public final JSType substitute(@Nullable PsiElement location) {
        if (this.isEcma() || !this.canBeSubstituted()) {
            JSTypeBaseImpl jSTypeBaseImpl = this;
            if (jSTypeBaseImpl == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(60);
            }
            return jSTypeBaseImpl;
        }
        JSType result2 = (JSType)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation(location, () -> this.substitute(new JSTypeSubstitutionContextImpl(JSTypeEvaluationLocationProvider.getTypeEvaluationLocation())));
        JSType jSType = result2 == null ? JSAnyType.get(this.getSource()) : result2;
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(61);
        }
        return jSType;
    }

    @Override
    @NotNull
    public final JSType substitute(@NotNull ProcessingContext context2) {
        if (context2 == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(62);
        }
        if (this.isEcma() || !this.canBeSubstituted()) {
            JSTypeBaseImpl jSTypeBaseImpl = this;
            if (jSTypeBaseImpl == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(63);
            }
            return jSTypeBaseImpl;
        }
        JSType result2 = this.substitute(new JSTypeSubstitutionContextImpl(context2));
        JSType jSType = result2 == null ? JSAnyType.get(this.getSource()) : result2;
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(64);
        }
        return jSType;
    }

    @Override
    @Nullable
    public final JSType substitute(@NotNull JSTypeSubstitutionContext context2) {
        if (context2 == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(65);
        }
        ProgressManager.checkCanceled();
        if (this.useCacheForSubstitute() && context2.canCache()) {
            JSResolvedTypeIdImpl id = this.getResolvedTypeId();
            boolean canCacheNull = context2.canCacheNull();
            JSType.LocalTypeKey key = this.getSubstituteKey(context2);
            JSType result2 = id.getLocalCachedValue(key, () -> {
                JSType expanded = this.substituteAndOptimizeNoCache(context2);
                if (expanded == null && canCacheNull) {
                    return JSTypeBaseImpl.getNullType();
                }
                return expanded;
            });
            return result2 == JSTypeBaseImpl.getNullType() ? null : result2;
        }
        return this.substituteAndOptimizeNoCache(context2);
    }

    private JSType.LocalTypeKey getSubstituteKey(@NotNull JSTypeSubstitutionContext context2) {
        Boolean strictNullChecks;
        if (context2 == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(66);
        }
        if ((strictNullChecks = (Boolean)context2.getUserData(JSTypeComparingContextService.NULL_CHECKS)) == null) {
            strictNullChecks = TypeScriptConfigUtil.strictNullChecks(this.getSourceElement());
            context2.putUserData(JSTypeComparingContextService.LOCATION, this.getSourceElement());
            context2.putUserData(JSTypeComparingContextService.NULL_CHECKS, strictNullChecks);
        }
        return ourSubstitueKeyMap.get(Pair.create((Object)(context2.getUserData(IS_FORCED_SUBSTITUTION) == Boolean.TRUE ? 1 : (context2.getUserData(IS_CHECKING_ASSIGNABILITY) == Boolean.TRUE ? 2 : 0)), (Object)(strictNullChecks == Boolean.TRUE ? 1 : 0)));
    }

    @Nullable
    private JSType substituteAndOptimizeNoCache(@NotNull JSTypeSubstitutionContext context2) {
        if (context2 == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(67);
        }
        return JSTypeBaseImpl.optimizeTypeInSubstitute(this.substituteNoCache(context2));
    }

    @Nullable
    private JSType substituteNoCache(@NotNull JSTypeSubstitutionContext context2) {
        if (context2 == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(68);
        }
        if (!this.canBeSubstituted()) {
            return this;
        }
        if (!context2.add(this)) {
            return null;
        }
        JSType type2 = this.substituteImpl(context2);
        if (type2 == null) {
            return null;
        }
        if (type2 == this) {
            return type2;
        }
        if (!context2.isVisited(type2 = JSTypeBaseImpl.optimizeTypeInSubstitute(type2))) {
            return type2.substitute(context2);
        }
        return type2;
    }

    @Nullable
    static JSType optimizeTypeInSubstitute(@Nullable JSType type2) {
        return JSCompositeTypeFactory.optimizeTypeIfComposite(type2, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SUBSTITUTE);
    }

    @Nullable
    protected JSType substituteImpl(@NotNull JSTypeSubstitutionContext context2) {
        if (context2 == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(69);
        }
        return this;
    }

    @Contract(value="!null,_ -> !null", pure=true)
    public static JSType replaceEmptySourceRecursive(@Nullable JSType type2, @NotNull JSTypeSource newSource) {
        if (newSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(70);
        }
        return JSTypeBaseImpl.replaceSourceRecursive(type2, newSource, (Condition<? super JSTypeSource>)((Condition)oldSource -> oldSource == JSTypeSource.EMPTY), false);
    }

    @Deprecated
    public static JSType replaceSourceRecursive(@Nullable JSType type2, @NotNull JSTypeSource newSource) {
        if (newSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(71);
        }
        return JSTypeBaseImpl.replaceSourceRecursive(type2, newSource, (Condition<? super JSTypeSource>)Conditions.alwaysTrue(), true);
    }

    @Contract(value="!null, _ -> !null")
    public static JSType copyWithLanguageRecursive(@Nullable JSType type2, @NotNull JSTypeSource.SourceLanguage sourceLanguage) {
        if (sourceLanguage == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(72);
        }
        return JSTypeBaseImpl.replaceSourceRecursive(type2, (Function<? super JSTypeBaseImpl, JSTypeSource>)((Function)currentType -> {
            JSTypeSource currentTypeSource = currentType.getSource();
            if (currentTypeSource.getLanguage() == sourceLanguage) {
                return currentTypeSource;
            }
            return currentTypeSource.copyWithNewLanguage(sourceLanguage);
        }), false);
    }

    private static JSType replaceSourceRecursive(@Nullable JSType type2, @NotNull JSTypeSource newSource, @NotNull Condition<? super JSTypeSource> replaceCondition, boolean nullizeRecordMemberSource) {
        if (newSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(73);
        }
        if (replaceCondition == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(74);
        }
        if (type2 == null) {
            return null;
        }
        return JSTypeBaseImpl.replaceSourceRecursive(type2, (Function<? super JSTypeBaseImpl, JSTypeSource>)((Function)currentType -> {
            JSTypeSource currentSource = currentType.getSource();
            if (!replaceCondition.value((Object)currentSource)) {
                return currentSource;
            }
            return newSource;
        }), nullizeRecordMemberSource);
    }

    @Contract(value="!null, _, _ -> !null")
    public static JSType replaceSourceRecursive(@Nullable JSType type2, @NotNull Function<? super JSTypeBaseImpl, JSTypeSource> createNewSource, boolean nullizeRecordMemberSource) {
        if (createNewSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(75);
        }
        if (type2 == null) {
            return null;
        }
        return type2.transformTypeHierarchy(new SourceTransformer(createNewSource, nullizeRecordMemberSource));
    }

    protected int hashCodeImpl() {
        return super.hashCode();
    }

    protected boolean resolvedEquals(@Nullable JSType rType) {
        return this.isEquivalentTo(rType, null, true);
    }

    protected final int getSourceHashCode() {
        PsiElement element2 = this.getSourceElement();
        return element2 != null ? element2.hashCode() : super.hashCode();
    }

    @Override
    @NotNull
    public final JSResolvedTypeIdImpl getResolvedTypeId() {
        long trackId;
        JSResolvedTypeIdImpl key = this.myResolvedKey;
        PsiElement element2 = this.getSource().getSourceElement();
        boolean isElementValid = element2 != null && element2.isValid();
        Project project = isElementValid ? element2.getProject() : null;
        long l = trackId = isElementValid ? PsiModificationTracker.getInstance((Project)project).getModificationCount() : -1L;
        if (key == null || key.myTrackId != trackId) {
            JSResolvedTypeIdCache cache = null;
            if (project != null) {
                cache = JSTypeComparingContextService.getService(project).getResolvedTypeIdCacheCache();
            }
            this.myResolvedKey = key = new JSResolvedTypeIdImpl(trackId, cache);
        }
        JSResolvedTypeIdImpl jSResolvedTypeIdImpl = key;
        if (jSResolvedTypeIdImpl == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(76);
        }
        return jSResolvedTypeIdImpl;
    }

    @NotNull
    protected String getTypeSeparator(@NotNull JSType.TypeTextFormat format) {
        if (format == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(77);
        }
        String string = format == JSType.TypeTextFormat.PRESENTABLE || this.isTypeScript() && format == JSType.TypeTextFormat.CODE ? JSSymbolPresentationProvider.getDefaultTypeSeparator(this.getSource().getSourceElement()) : JSSymbolPresentationProvider.DEFAULT.getTypeSeparator(null);
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(78);
        }
        return string;
    }

    @Override
    @NotNull
    public final Stream<JSType> getFunctionTypes(@NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(79);
        }
        ProgressManager.checkCanceled();
        JSType toProcess = JSTypeUtils.unwrapType(this);
        if (toProcess != this) {
            Stream<JSType> stream = toProcess.getFunctionTypes(processingContext, newCallSignatures);
            if (stream == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(80);
            }
            return stream;
        }
        HashSet<JSResolvedTypeIdImpl> ids = (HashSet<JSResolvedTypeIdImpl>)processingContext.get(VISITED_TYPES);
        if (ids == null) {
            ids = new HashSet<JSResolvedTypeIdImpl>();
            processingContext.put(VISITED_TYPES, ids);
        }
        if (!ids.add(this.getResolvedTypeId())) {
            if (Holder.TEST_MODE && JSEvaluatorComplexityTracker.isAssertOnPrevention()) {
                throw new StackOverflowPreventedException("Infinite function type evaluation " + this.getTypeText());
            }
            Stream<JSType> stream = Stream.of(this);
            if (stream == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(81);
            }
            return stream;
        }
        if (this.checkAlwaysAssignableType(this, processingContext) && !(this instanceof JSUnionOrIntersectionType)) {
            Stream<JSType> stream = Stream.of(this);
            if (stream == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(82);
            }
            return stream;
        }
        JSType substitute = this.substitute((PsiElement)processingContext.get(JSTypeComparingContextService.LOCATION));
        if (substitute instanceof JSEvaluableType) {
            Stream<JSType> stream = Stream.of(this);
            if (stream == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(83);
            }
            return stream;
        }
        if (substitute != this) {
            Stream<JSType> stream = substitute.getFunctionTypes(processingContext, newCallSignatures);
            if (stream == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(84);
            }
            return stream;
        }
        Stream<JSType> stream = this.getFunctionTypesImpl(processingContext, newCallSignatures);
        if (stream == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(85);
        }
        return stream;
    }

    @NotNull
    protected static ProcessingContext copyProcessingContextForFunctionTypes(@NotNull ProcessingContext context2, boolean strict) {
        if (context2 == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(86);
        }
        ProcessingContext processingContext = new ProcessingContext();
        processingContext.put(JSTypeComparingContextService.NULL_CHECKS, (Object)strict);
        Set ids = (Set)context2.get(VISITED_TYPES);
        processingContext.put(VISITED_TYPES, new HashSet(ids));
        ProcessingContext processingContext2 = processingContext;
        if (processingContext2 == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(87);
        }
        return processingContext2;
    }

    @NotNull
    protected Stream<JSType> getFunctionTypesImpl(@NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(88);
        }
        Stream<JSType> stream = Stream.empty();
        if (stream == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(89);
        }
        return stream;
    }

    @NotNull
    protected final JSRecordType emptyRecordType() {
        JSRecordType jSRecordType = this.isTypeScript() ? new JSRecordTypeImpl(this.getSource(), Collections.emptyList()) : JSTypeCastUtil.NO_RECORD_TYPE;
        if (jSRecordType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(90);
        }
        return jSRecordType;
    }

    public int hashCode() {
        int code = this.myHashCode;
        if (code == 0) {
            this.myHashCode = code = Objects.hash(this.hashCodeImpl(), this.getClass(), this.isSourceStrict());
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JSType) {
            return this.isEquivalentTo((JSType)obj, null, false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private AtomicLongRingArray getEqualityStore() {
        AtomicLongRingArray array = this.myEqualityCache;
        if (array != null) {
            AtomicLongRingArray atomicLongRingArray = array;
            if (atomicLongRingArray == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(91);
            }
            return atomicLongRingArray;
        }
        JSTypeBaseImpl jSTypeBaseImpl = this;
        synchronized (jSTypeBaseImpl) {
            array = this.myEqualityCache;
            if (array != null) {
                AtomicLongRingArray atomicLongRingArray = array;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                if (atomicLongRingArray == null) {
                    JSTypeBaseImpl.$$$reportNull$$$0(92);
                }
                return atomicLongRingArray;
            }
            this.myEqualityCache = array = new AtomicLongRingArray();
        }
        AtomicLongRingArray atomicLongRingArray = array;
        if (atomicLongRingArray == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(93);
        }
        return atomicLongRingArray;
    }

    public String toString() {
        return this.getTypeText();
    }

    static {
        for (int kind = 0; kind <= 2; ++kind) {
            for (int strict = 0; strict <= 1; ++strict) {
                StringBuilder key = new StringBuilder();
                key.append("substitute");
                if (kind == 0) {
                    key.append(".simple");
                } else if (kind == 1) {
                    key.append(".forced");
                } else {
                    key.append(".assignability");
                }
                if (strict == 1) {
                    key.append(".strict");
                } else {
                    key.append(".non-strict");
                }
                ourSubstitueKeyMap.put((Pair<Integer, Boolean>)Pair.create((Object)kind, (Object)(strict == 1 ? 1 : 0)), JSType.createLocalTypeKey(key.toString()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 9, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32, 33, 35, 38, 41, 45, 46, 47, 48, 49, 50, 52, 55, 62, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 77, 79, 86, 88 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheKey";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expandedThis";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expandedRType";
                break;
            }
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 79: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromCache";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 35: 
            case 38: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformation";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldContext";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 50: 
            case 70: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceLanguage";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceCondition";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createNewSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelfNoTransformationType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 55: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 79: 
            case 86: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveCachedType";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedTypeText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHelper";
                break;
            }
            case 36: 
            case 37: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "transformTypeHierarchy";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompilerType";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "transformTypeOrCopyWithTransformation";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "expandCodeBased";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithStrict";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "withNewSource";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordType";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 60: 
            case 61: 
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedTypeId";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypes";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "copyProcessingContextForFunctionTypes";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypesImpl";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyRecordType";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityStore";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assertOnRecordTypeUsage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResolveCachedType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextInner";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableInClassHierarchy";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableUnderRecursionProtection";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isDirectAssignableTypeSimple";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkAlwaysAssignableType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "calculateAssignabilityWithoutCache";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkCachedValue";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 35: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "transformTypeHierarchy";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "transformTypeOrCopyWithTransformation";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "checkUselessCopy";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "checkSymmetrical";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "expandCodeBased";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "withNewSource";
                break;
            }
            case 62: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getSubstituteKey";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "substituteAndOptimizeNoCache";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "substituteNoCache";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "replaceEmptySourceRecursive";
                break;
            }
            case 71: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "replaceSourceRecursive";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "copyWithLanguageRecursive";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSeparator";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypes";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "copyProcessingContextForFunctionTypes";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypesImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 9, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32, 33, 35, 38, 41, 45, 46, 47, 48, 49, 50, 52, 55, 62, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 77, 79, 86, 88 -> new IllegalArgumentException(string);
        };
    }

    private static final class Holder {
        private static final boolean TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
        private static final JSType SELF_NO_TRANSFORMATION = new JSAnyType(JSTypeSource.SourceLanguage.JS){

            @Override
            public String toString() {
                return "Self type";
            }
        };
        private static final JSType NULL_TYPE = new JSAnyType(JSTypeSource.SourceLanguage.JS){

            @Override
            public String toString() {
                return "Null type";
            }
        };

        private Holder() {
        }
    }

    public final class JSResolvedTypeIdImpl
    implements JSResolvedTypeId {
        private final long myTrackId;
        @Nullable
        private final JSResolvedTypeIdCache myCache;
        private final AtomicLongRingArray myEqualityResolveCache = new AtomicLongRingArray();

        public JSResolvedTypeIdImpl(@Nullable long trackId, JSResolvedTypeIdCache cache) {
            this.myTrackId = trackId;
            this.myCache = cache;
        }

        public boolean isValid() {
            return this.myTrackId != -1L;
        }

        public int hashCode() {
            return JSTypeBaseImpl.this.hashCode();
        }

        @Override
        @NotNull
        public JSType getOwnerType() {
            JSTypeBaseImpl jSTypeBaseImpl = JSTypeBaseImpl.this;
            if (jSTypeBaseImpl == null) {
                JSResolvedTypeIdImpl.$$$reportNull$$$0(0);
            }
            return jSTypeBaseImpl;
        }

        @Override
        @Nullable
        public <T> T getLocalCachedValue(@NotNull Key<T> key, @NotNull Supplier<? extends T> supplier) {
            if (key == null) {
                JSResolvedTypeIdImpl.$$$reportNull$$$0(1);
            }
            if (supplier == null) {
                JSResolvedTypeIdImpl.$$$reportNull$$$0(2);
            }
            if (!this.isValid() || this.myCache == null) {
                return supplier.get();
            }
            return this.myCache.getLocalCachedValue(this, key, supplier);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof JSResolvedTypeId) || obj.hashCode() != this.hashCode()) {
                return false;
            }
            JSType type2 = ((JSResolvedTypeId)obj).getOwnerType();
            JSTypeBaseImpl typeBase = (JSTypeBaseImpl)ObjectUtils.tryCast((Object)((JSResolvedTypeId)obj).getOwnerType(), JSTypeBaseImpl.class);
            if (typeBase != null && this.myEqualityResolveCache.hasLong(typeBase.myId)) {
                return true;
            }
            boolean result2 = JSTypeBaseImpl.this.resolvedEquals(type2);
            if (typeBase != null && result2) {
                this.myEqualityResolveCache.addLong(typeBase.myId);
            }
            return result2;
        }

        public String toString() {
            return JSTypeBaseImpl.this.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$JSResolvedTypeIdImpl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supplier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwnerType";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$JSResolvedTypeIdImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getLocalCachedValue";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class SourceTransformer
    extends JSCacheableTypeTransformerBase
    implements JSSimpleTransformer {
        @NotNull
        private final Function<? super JSTypeBaseImpl, JSTypeSource> myCreateNewSource;
        private final boolean myNullizeRecordMemberSource;

        public SourceTransformer(@NotNull Function<? super JSTypeBaseImpl, JSTypeSource> createNewSource, boolean nullizeRecordMemberSource) {
            if (createNewSource == null) {
                SourceTransformer.$$$reportNull$$$0(0);
            }
            this.myCreateNewSource = createNewSource;
            this.myNullizeRecordMemberSource = nullizeRecordMemberSource;
        }

        @Override
        @NotNull
        public JSType fun(@NotNull JSType currentType) {
            if (currentType == null) {
                SourceTransformer.$$$reportNull$$$0(1);
            }
            if (!(currentType instanceof JSTypeBaseImpl)) {
                assert (false);
                JSType jSType = currentType;
                if (jSType == null) {
                    SourceTransformer.$$$reportNull$$$0(2);
                }
                return jSType;
            }
            JSTypeSource newSource = (JSTypeSource)this.myCreateNewSource.fun((Object)((JSTypeBaseImpl)currentType));
            JSTypeSource currentSource = currentType.getSource();
            if (currentSource == newSource) {
                JSType jSType = currentType;
                if (jSType == null) {
                    SourceTransformer.$$$reportNull$$$0(3);
                }
                return jSType;
            }
            JSType type2 = ((JSTypeBaseImpl)currentType).copyTypeHierarchy(this, newSource);
            if (type2 == currentType || type2.getSource() != newSource) {
                type2 = currentType.withNewSource(newSource);
            }
            JSType jSType = type2;
            if (jSType == null) {
                SourceTransformer.$$$reportNull$$$0(4);
            }
            return jSType;
        }

        public boolean isNullizeRecordMemberSource() {
            return this.myNullizeRecordMemberSource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "createNewSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentType";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$SourceTransformer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$SourceTransformer";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fun";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "fun";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

