/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.List;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.DirectedEdgeStar;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.util.Assert;

class RightmostEdgeFinder {
    private int minIndex = -1;
    private Coordinate minCoord = null;
    private DirectedEdge minDe = null;
    private DirectedEdge orientedDe = null;

    public DirectedEdge getEdge() {
        return this.orientedDe;
    }

    public Coordinate getCoordinate() {
        return this.minCoord;
    }

    public void findEdge(List dirEdgeList) {
        for (DirectedEdge de : dirEdgeList) {
            if (!de.isForward()) continue;
            this.checkForRightmostCoordinate(de);
        }
        Assert.isTrue(this.minIndex != 0 || this.minCoord.equals(this.minDe.getCoordinate()), "inconsistency in rightmost processing");
        if (this.minIndex == 0) {
            this.findRightmostEdgeAtNode();
        } else {
            this.findRightmostEdgeAtVertex();
        }
        this.orientedDe = this.minDe;
        int rightmostSide = this.getRightmostSide(this.minDe, this.minIndex);
        if (rightmostSide == 1) {
            this.orientedDe = this.minDe.getSym();
        }
    }

    private void findRightmostEdgeAtNode() {
        Node node = this.minDe.getNode();
        DirectedEdgeStar star = (DirectedEdgeStar)node.getEdges();
        this.minDe = star.getRightmostEdge();
        if (!this.minDe.isForward()) {
            this.minDe = this.minDe.getSym();
            this.minIndex = this.minDe.getEdge().getCoordinates().length - 1;
        }
    }

    private void findRightmostEdgeAtVertex() {
        Coordinate[] pts = this.minDe.getEdge().getCoordinates();
        Assert.isTrue(this.minIndex > 0 && this.minIndex < pts.length, "rightmost point expected to be interior vertex of edge");
        Coordinate pPrev = pts[this.minIndex - 1];
        Coordinate pNext = pts[this.minIndex + 1];
        int orientation = Orientation.index(this.minCoord, pNext, pPrev);
        boolean usePrev = false;
        if (pPrev.y < this.minCoord.y && pNext.y < this.minCoord.y && orientation == 1) {
            usePrev = true;
        } else if (pPrev.y > this.minCoord.y && pNext.y > this.minCoord.y && orientation == -1) {
            usePrev = true;
        }
        if (usePrev) {
            --this.minIndex;
        }
    }

    private void checkForRightmostCoordinate(DirectedEdge de) {
        Coordinate[] coord = de.getEdge().getCoordinates();
        for (int i2 = 0; i2 < coord.length - 1; ++i2) {
            if (this.minCoord != null && !(coord[i2].x > this.minCoord.x)) continue;
            this.minDe = de;
            this.minIndex = i2;
            this.minCoord = coord[i2];
        }
    }

    private int getRightmostSide(DirectedEdge de, int index) {
        int side = this.getRightmostSideOfSegment(de, index);
        if (side < 0) {
            side = this.getRightmostSideOfSegment(de, index - 1);
        }
        if (side < 0) {
            this.minCoord = null;
            this.checkForRightmostCoordinate(de);
        }
        return side;
    }

    private int getRightmostSideOfSegment(DirectedEdge de, int i2) {
        Edge e = de.getEdge();
        Coordinate[] coord = e.getCoordinates();
        if (i2 < 0 || i2 + 1 >= coord.length) {
            return -1;
        }
        if (coord[i2].y == coord[i2 + 1].y) {
            return -1;
        }
        int pos = 1;
        if (coord[i2].y < coord[i2 + 1].y) {
            pos = 2;
        }
        return pos;
    }
}

