/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc.wrappers;

import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteResultSetMetaData;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.FastUtilHashingStrategies;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class ResultSetWrapper {
    private final RemoteResultSet myDelegate;
    private final Object2IntMap<String> myColumnMap;
    private final int myColumnCount;
    @Nullable
    private List<Object[]> myRows;
    private int myPosition;
    private boolean myFinished;

    public ResultSetWrapper(@Nullable RemoteResultSet rs) throws SQLException {
        this.myDelegate = rs;
        this.myFinished = rs == null;
        this.myColumnMap = new Object2IntOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
        RemoteResultSetMetaData metaData = rs == null ? null : (RemoteResultSetMetaData)JdbcNativeUtil.computeRemote(() -> this.myDelegate.getMetaData());
        this.myColumnCount = metaData == null ? 0 : JdbcNativeUtil.getIntSafe(() -> metaData.getColumnCount());
        for (int i2 = 0; i2 < this.myColumnCount; ++i2) {
            int finalI = i2;
            this.myColumnMap.put((Object)((String)JdbcNativeUtil.computeRemote(() -> metaData.getColumnName(finalI + 1))), i2 + 1);
            try {
                this.myColumnMap.put((Object)metaData.getColumnLabel(i2 + 1), i2 + 1);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void close(@Nullable ResultSetWrapper wrapper) {
        try {
            RemoteResultSet delegate;
            RemoteResultSet remoteResultSet = delegate = wrapper == null ? null : wrapper.myDelegate;
            if (delegate != null) {
                delegate.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean next() throws SQLException {
        if (this.myFinished) {
            return false;
        }
        ++this.myPosition;
        if (this.myRows == null || this.myPosition == this.myRows.size()) {
            this.myFinished = this.myRows != null && this.myRows.size() < 100;
            try {
                RemoteResultSet.DataRetrievingOptions options = new RemoteResultSet.DataRetrievingOptions(100, 204800, false);
                this.myRows = this.myFinished ? null : this.myDelegate.getObjects(options);
            }
            catch (RemoteException e) {
                this.myRows = null;
                throw new SQLException(e);
            }
            this.myPosition = 0;
        }
        return this.myRows != null && !this.myRows.isEmpty();
    }

    @Nullable
    public Object getObject(String column2, int colNum) throws SQLException {
        int i2 = this.getColumnIndex(column2, colNum);
        return i2 == 0 ? null : Objects.requireNonNull(this.myRows).get(this.myPosition)[i2 - 1];
    }

    @Nullable
    public String getString(String column2, int colNum) throws SQLException {
        Object o = this.getObject(column2, colNum);
        return o instanceof String ? (String)o : null;
    }

    public boolean getBoolean(String column2, int colNum) throws SQLException {
        Object o = this.getObject(column2, colNum);
        return o instanceof String ? "yes".equalsIgnoreCase((String)o) : Boolean.TRUE.equals(o);
    }

    public int getInt(String column2, int colNum, int def) throws SQLException {
        Object o = this.getObject(column2, colNum);
        return o instanceof Number ? ((Number)o).intValue() : (o instanceof String ? StringUtil.parseInt((String)((String)o), (int)def) : def);
    }

    public short getShort(String column2, int colNum) throws SQLException {
        Object o = this.getObject(column2, colNum);
        return o instanceof Number ? ((Number)o).shortValue() : (o instanceof String ? ResultSetWrapper.parseShort((String)o) : (short)0);
    }

    @Contract(pure=true)
    private static short parseShort(@Nullable String string) {
        if (string != null) {
            try {
                return Short.parseShort(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private int getColumnIndex(String column2, int colNum) {
        int i2;
        if (this.myDelegate == null) {
            throw new IllegalStateException();
        }
        int n = i2 = column2 == null ? 0 : this.myColumnMap.getInt((Object)column2);
        if (i2 == 0) {
            i2 = colNum;
        } else if (i2 != colNum) {
            // empty if block
        }
        return i2 < 1 || i2 > this.myColumnCount ? 0 : i2;
    }
}

