/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.BaseOutputReader;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapturingProcessHandler
extends OSProcessHandler {
    private final CapturingProcessRunner myProcessRunner;

    public CapturingProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            CapturingProcessHandler.$$$reportNull$$$0(0);
        }
        super(commandLine);
        this.myProcessRunner = new CapturingProcessRunner((BaseProcessHandler<?>)this, (Function<? super ProcessOutput, ? extends ProcessListener>)((Function<ProcessOutput, ProcessListener>)processOutput -> this.createProcessAdapter((ProcessOutput)processOutput)));
    }

    public CapturingProcessHandler(@NotNull Process process, @Nullable Charset charset, String commandLine) {
        if (process == null) {
            CapturingProcessHandler.$$$reportNull$$$0(1);
        }
        super(process, commandLine, charset);
        this.myProcessRunner = new CapturingProcessRunner((BaseProcessHandler<?>)this, (Function<? super ProcessOutput, ? extends ProcessListener>)((Function<ProcessOutput, ProcessListener>)processOutput -> this.createProcessAdapter((ProcessOutput)processOutput)));
    }

    protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
        return new CapturingProcessAdapter(processOutput);
    }

    public Charset getCharset() {
        return this.myCharset != null ? this.myCharset : super.getCharset();
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public final ProcessOutput runProcess() {
        ProcessOutput processOutput = this.myProcessRunner.runProcess();
        if (processOutput == null) {
            CapturingProcessHandler.$$$reportNull$$$0(2);
        }
        return processOutput;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    public ProcessOutput runProcess(int timeoutInMilliseconds) {
        return this.myProcessRunner.runProcess(timeoutInMilliseconds);
    }

    public ProcessOutput runProcess(int timeoutInMilliseconds, boolean destroyOnTimeout) {
        return this.myProcessRunner.runProcess(timeoutInMilliseconds, destroyOnTimeout);
    }

    @NotNull
    public ProcessOutput runProcessWithProgressIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CapturingProcessHandler.$$$reportNull$$$0(3);
        }
        ProcessOutput processOutput = this.myProcessRunner.runProcess(indicator);
        if (processOutput == null) {
            CapturingProcessHandler.$$$reportNull$$$0(4);
        }
        return processOutput;
    }

    @NotNull
    public ProcessOutput runProcessWithProgressIndicator(@NotNull ProgressIndicator indicator, int timeoutInMilliseconds) {
        if (indicator == null) {
            CapturingProcessHandler.$$$reportNull$$$0(5);
        }
        ProcessOutput processOutput = this.myProcessRunner.runProcess(indicator, timeoutInMilliseconds);
        if (processOutput == null) {
            CapturingProcessHandler.$$$reportNull$$$0(6);
        }
        return processOutput;
    }

    @NotNull
    public ProcessOutput runProcessWithProgressIndicator(@NotNull ProgressIndicator indicator, int timeoutInMilliseconds, boolean destroyOnTimeout) {
        if (indicator == null) {
            CapturingProcessHandler.$$$reportNull$$$0(7);
        }
        ProcessOutput processOutput = this.myProcessRunner.runProcess(indicator, timeoutInMilliseconds, destroyOnTimeout);
        if (processOutput == null) {
            CapturingProcessHandler.$$$reportNull$$$0(8);
        }
        return processOutput;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/CapturingProcessHandler";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/CapturingProcessHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithProgressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressIndicator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 8 -> new IllegalStateException(string);
        };
    }

    public static class Silent
    extends CapturingProcessHandler {
        public Silent(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
            if (commandLine == null) {
                Silent.$$$reportNull$$$0(0);
            }
            super(commandLine);
        }

        public Silent(@NotNull Process process, @Nullable Charset charset, @NotNull String commandLine) {
            if (process == null) {
                Silent.$$$reportNull$$$0(1);
            }
            if (commandLine == null) {
                Silent.$$$reportNull$$$0(2);
            }
            super(process, charset, commandLine);
        }

        @Override
        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
            if (options == null) {
                Silent.$$$reportNull$$$0(3);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/process/CapturingProcessHandler$Silent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/process/CapturingProcessHandler$Silent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

