(* -------------------------------------------------------------------- *)
type unit.

op tt : unit.

(* -------------------------------------------------------------------- *)
type bool.

op false : bool.
op true  : bool.

op [!]  : bool -> bool.
op (||) : bool -> bool -> bool.
op (\/) : bool -> bool -> bool.
op (&&) : bool -> bool -> bool.
op (/\) : bool -> bool -> bool.
op (=>) : bool -> bool -> bool.
op (<=>): bool -> bool -> bool.

(* -------------------------------------------------------------------- *)
op (=) ['a] : 'a -> 'a -> bool.
abbrev (<>) (x y : 'a) = ! (x = y).

(* -------------------------------------------------------------------- *)
type int.

(* -------------------------------------------------------------------- *)
type real.

(* -------------------------------------------------------------------- *)
type 'a distr.

op mu: 'a distr -> ('a -> bool) -> real.

(* -------------------------------------------------------------------- *)
op witness : 'a.                (* All types are inhabited in EC *)
