function __null_aware_to_string(value) {
  return value != null ? "" + value : value
}

const __jsonPathSupport =  __args.jsonPathSupport

function jsonPath(obj, path) {
  const result = __jsonPathSupport.applyJsonPath(JSON.stringify(obj), "" + path)
  return result
}

const __urlSearchParamsSupport = __args.urlSearchParamsSupport

function URLSearchParams(options) {
  this.__delegate = __urlSearchParamsSupport.invoke(options)

  Object.defineProperty(this, "size", {
    get() {
      return this.__delegate.getSize()
    }
  })

  this.append = function append(name, value) {
    this.__delegate.append('' + name, '' + value)
  }

  this.delete = function (name, value) {
    if (value === undefined) {
      value = null
    }
    this.__delegate.delete('' +name, __null_aware_to_string(value))
  }

  this.get = function get(name) {
    return __null_aware_to_string(this.__delegate.get('' + name))
  }

  this.getAll = function getAll(name) {
    let result = []
    for (let el of this.__delegate.getAll('' + name)) {
      result.push('' + el)
    }
    return result
  }

  this.has = function has(name, value) {
    if (value === undefined) {
      value = null
    }
    return this.__delegate.has('' + name,  __null_aware_to_string(value))
  }

  this.set = function set(name, value) {
    this.__delegate.set('' + name, '' + value)
  }

  this.sort = function sort() {
    this.__delegate.sort()
  }

  this.toString = function () {
    return '' + this.__delegate.toString()
  }

  // iteration
  this.entries = function entries() {
    const result = [];
    for (let el of this.__delegate.getEntries()) {
      result.push(['' + el.getFirst(), '' + el.getSecond()])
    }

    return result
  }

  this.keys = function keys() {
    const result = [];
    for (let [key, _] of this.entries()) {
      result.push(key);
    }
    return result
  }

  this.values = function values() {
    const result = [];
    for (let [_, value] of this.entries()) {
      result.push(value);
    }
    return result;
  }

  this.forEach = function forEach(callback) {
    for (let [key, value] of this.entries()) {
      callback(key, value, this)
    }
  }

  this[Symbol.iterator] = function () {
    return this.entries()[Symbol.iterator]()
  }
}

function Variables(global) {
  this.vars = {}

  for (var key in global) {
    let value = global[key].getValue()
    this.vars[global[key].getKey()] = value
  }

  this.set = function set(varName, varValue) {
    this.vars[varName] = varValue
  }

  this.get = function get(varName) {
    let value =  this.vars[varName]
    return value instanceof String ? __null_aware_to_string(value) : value
  }

  this.isEmpty = function isEmpty() {
    return Object.keys(this.vars).length === 0
  }

  this.clear = function clear(varName) {
    delete this.vars[varName]
  }

  this.clearAll = function clearAll() {
    this.vars = {}
  }
}

const __logPrinter = __args.logSupport;

function __log() {
  const result = [];

  for (let arg of arguments) {
    if (arg instanceof Function) {
      result.push([arg, false])
    }
    else if (
      arg instanceof Object ||
      arg instanceof Array ||
      Object.prototype.toString.call(arg) === "[object JavaMap]" ||
      Object.prototype.toString.call(arg) === "[object JavaArray]" ||
      Object.prototype.toString.call(arg) === "[object JavaList]"
    ) {
      result.push([JSON.stringify(arg, null, 2), true])
    }
    else {
      result.push(['' + arg, false])
    }
  }

  __logPrinter.accept(result)
}

const console = {
  log: __log
}