/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.editor;

import com.jetbrains.rd.ide.document.DocumentVersionsKt;
import com.jetbrains.rd.ide.model.DocOffsetAndVirtualModel;
import com.jetbrains.rd.ide.model.RdCaret;
import com.jetbrains.rd.ide.model.RdCaretId;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdEditorVersion;
import com.jetbrains.rd.ide.model.RdSelection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0006\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002\u001a\u0014\u0010\n\u001a\u00020\b*\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0014\u0010\n\u001a\u00020\b*\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\n\u001a\u00020\b*\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0014\u0010\n\u001a\u00020\b*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0014\u0010\n\u001a\u00020\b*\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0013"}, d2={"InitialEditorVersion", "Lcom/jetbrains/rd/ide/model/RdEditorVersion;", "getInitialEditorVersion", "()Lcom/jetbrains/rd/ide/model/RdEditorVersion;", "increment", "state", "Lcom/jetbrains/rd/ide/model/RdCaretState;", "computeHash", "", "Lcom/jetbrains/rd/ide/model/RdCaret;", "mix", "id", "Lcom/jetbrains/rd/ide/model/RdCaretId;", "selection", "Lcom/jetbrains/rd/ide/model/RdSelection;", "offset", "Lcom/jetbrains/rd/ide/model/DocOffsetAndVirtualModel;", "value", "", "intellij.rd.platform"})
public final class EditorVersionsKt {
    @NotNull
    private static final RdEditorVersion InitialEditorVersion = new RdEditorVersion(-1, DocumentVersionsKt.getInitialDocVersion(), -1L);

    @NotNull
    public static final RdEditorVersion getInitialEditorVersion() {
        return InitialEditorVersion;
    }

    @NotNull
    public static final RdEditorVersion increment(@NotNull RdEditorVersion $this$increment, @NotNull RdCaretState state) {
        Intrinsics.checkNotNullParameter((Object)$this$increment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int newVersion = $this$increment.getCaretModelVersion() + 1;
        if (!(newVersion >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new RdEditorVersion(newVersion, state.getDocumentVersion(), EditorVersionsKt.computeHash(state));
    }

    public static final long computeHash(@NotNull RdCaretState $this$computeHash) {
        RdCaret caret;
        Intrinsics.checkNotNullParameter((Object)$this$computeHash, (String)"<this>");
        RdCaret rdCaret = caret = (RdCaret)CollectionsKt.firstOrNull((List)$this$computeHash.getCarets());
        return rdCaret != null ? EditorVersionsKt.computeHash(rdCaret) : 0L;
    }

    private static final long computeHash(RdCaret $this$computeHash) {
        long initial = EditorVersionsKt.mix(127L, $this$computeHash.getId());
        if ($this$computeHash.getSelection().getStart().getOffset() != $this$computeHash.getSelection().getEnd().getOffset()) {
            return EditorVersionsKt.mix(initial, $this$computeHash.getSelection());
        }
        return EditorVersionsKt.mix(initial, $this$computeHash.getOffset());
    }

    private static final long mix(long $this$mix, RdCaretId id) {
        return EditorVersionsKt.mix($this$mix, id.getNumber());
    }

    private static final long mix(long $this$mix, RdSelection selection) {
        return EditorVersionsKt.mix($this$mix, EditorVersionsKt.mix($this$mix, selection.getStart()) * EditorVersionsKt.mix($this$mix, selection.getEnd()));
    }

    private static final long mix(long $this$mix, DocOffsetAndVirtualModel offset) {
        return EditorVersionsKt.mix($this$mix, offset.getOffset());
    }

    private static final long mix(long $this$mix, int value) {
        return EditorVersionsKt.mix($this$mix, (long)value);
    }

    private static final long mix(long $this$mix, long value) {
        return $this$mix * 31L + value;
    }
}

