/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.Iteration;
import org.jetbrains.jetCheck.PropertyChecker;
import org.jetbrains.jetCheck.StatusNotifier;
import org.jetbrains.jetCheck.StructureNode;

class CheckSession<T> {
    private static final String EXECUTOR_NAME = "jetCheck internal executor";
    final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(0, r -> new Thread(r, EXECUTOR_NAME));
    final Generator<T> generator;
    final Predicate<T> property;
    final PropertyChecker.Parameters parameters;
    final StatusNotifier notifier;
    private final Set<StructureNode> generatedNodes = Collections.newSetFromMap(new LinkedHashMap<StructureNode, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<StructureNode, Boolean> eldest) {
            return this.size() > 1000;
        }
    });

    CheckSession(Generator<T> generator, Predicate<T> property, PropertyChecker.Parameters parameters) {
        this.generator = generator;
        this.property = property;
        this.parameters = parameters;
        this.notifier = new StatusNotifier(parameters);
    }

    boolean addGeneratedNode(StructureNode node) {
        return this.generatedNodes.add(node);
    }

    void run() {
        try {
            for (Iteration iteration = new Iteration(this, this.parameters.globalSeed, 1); iteration != null; iteration = iteration.performIteration()) {
            }
        }
        finally {
            this.shutdownExecutor();
        }
    }

    private void shutdownExecutor() {
        this.executor.shutdownNow();
        try {
            if (!this.executor.awaitTermination(1L, TimeUnit.MINUTES)) {
                throw new IllegalStateException("Cannot shutdown jetCheck internal executor");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Cannot shutdown jetCheck internal executor", e);
        }
    }
}

