/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.options.SqlCodeCompletionSettings;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlCompletionScopeProcessor
extends SqlScopeProcessorBase {
    @Nullable
    private final SqlElement myRefElement;
    @Nullable
    private final ObjectKind myPrimaryKind;
    private final boolean myAddColumns;
    @NotNull
    private final CamelHumpMatcher myAdjustedMatcher;
    @NotNull
    private final Consumer<LookupElement> myResultSet;
    private final boolean myMissingFrom;
    private final boolean myFilterPgRoutines;
    private final boolean myWeightDown;
    @NotNull
    private final DasType myQualifierType;
    @NotNull
    private final Set<ObjectKind> myExpectedTypesStrict;
    @Nullable
    private final BiConsumer<? super DasObject, PsiElement> myAcceptedElementConsumer;
    private final CompletionParameters myCompletionParameters;
    boolean myEmpty;
    boolean myTablesBlocked;
    @NotNull
    private final NotNullLazyValue<Collection<DasType>> myExpectedTypes;
    private boolean myHasAcceptedCompletionVariants;
    @NotNull
    private final Set<ObjectPath> addedPaths;

    public SqlCompletionScopeProcessor(@NotNull SqlLanguageDialectEx dialect, @NotNull List<DbDataSource> dataSources, @Nullable SqlElement refElement, boolean addColumns, @NotNull CamelHumpMatcher adjustedMatcher, @NotNull Consumer<LookupElement> resultSet, boolean missingFrom, boolean filterPgRoutines, boolean weightDown, @NotNull DasType qualifierType, @NotNull Set<ObjectKind> expectedTypesStrict, @NotNull CompletionParameters completionParameters, @Nullable BiConsumer<? super DasObject, PsiElement> acceptedElementConsumer) {
        if (dialect == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(0);
        }
        if (dataSources == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(1);
        }
        if (adjustedMatcher == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(2);
        }
        if (resultSet == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(3);
        }
        if (qualifierType == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(4);
        }
        if (expectedTypesStrict == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(5);
        }
        if (completionParameters == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(6);
        }
        super(null, dialect, dataSources, (PsiElement)refElement);
        this.myHasAcceptedCompletionVariants = false;
        this.addedPaths = new HashSet<ObjectPath>();
        this.myRefElement = refElement;
        this.myPrimaryKind = refElement instanceof SqlReferenceExpression ? ((SqlReferenceExpression)refElement).getReferenceElementType().getTargetKind() : null;
        this.myAddColumns = addColumns;
        this.myAdjustedMatcher = adjustedMatcher;
        this.myResultSet = resultSet;
        this.myMissingFrom = missingFrom;
        this.myFilterPgRoutines = filterPgRoutines;
        this.myWeightDown = weightDown;
        this.myQualifierType = qualifierType;
        this.myExpectedTypesStrict = expectedTypesStrict;
        this.myAcceptedElementConsumer = acceptedElementConsumer;
        this.myCompletionParameters = completionParameters;
        this.myEmpty = true;
        this.myExpectedTypes = this.getPlace() == null ? NotNullLazyValue.createConstantValue(Collections.emptyList()) : NotNullLazyValue.lazy((Supplier)new Supplier<Collection<DasType>>(){
            final SmartPsiElementPointer<PsiElement> myPointer;
            {
                this.myPointer = SmartPointerManager.createPointer((PsiElement)SqlCompletionScopeProcessor.this.getPlace());
            }

            @Override
            public Collection<DasType> get() {
                return SqlFunctionsUtil.evaluateExpectedTypesForArgument(this.myPointer.getElement());
            }
        });
    }

    @Override
    public boolean shouldIncludeAllNamespaces() {
        if (SqlCodeCompletionSettings.getInstance().isSuggestAllObjects()) {
            return true;
        }
        return this.myCompletionParameters.getInvocationCount() > 2;
    }

    public boolean hasAcceptedCompletionVariants() {
        return this.myHasAcceptedCompletionVariants;
    }

    @Override
    public boolean isResultEmpty() {
        return this.myEmpty;
    }

    @Override
    public void addIgnoredKinds(@NotNull Set<ObjectKind> kinds) {
        if (kinds == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(7);
        }
        if (kinds.contains(ObjectKind.TABLE)) {
            this.myTablesBlocked = true;
        }
        super.addIgnoredKinds(kinds);
    }

    @Override
    public boolean executeTarget(@NotNull DasSymbol symbol, @Nullable DasType dasType, @Nullable Boolean forcedCaseSens, @NotNull ResolveState state) {
        Consumer<LookupElement> consumer;
        DasArgument arg;
        boolean weightDown;
        boolean dbOrSchema;
        if (symbol == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(8);
        }
        if (state == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(9);
        }
        if (symbol.getKind() == ObjectKind.BODY) {
            return true;
        }
        boolean bl = dbOrSchema = symbol.getKind() == ObjectKind.DATABASE || symbol.getKind() == ObjectKind.SCHEMA;
        if (this.myCompletionParameters.getInvocationCount() <= 1 && dbOrSchema && !this.getExpectedTypes().contains(symbol.getKind())) {
            return true;
        }
        if (dbOrSchema && symbol.getName().isEmpty()) {
            return true;
        }
        DasObject dasObject = symbol.getDasObject();
        PsiElement element = DasSymbolUtil.getSinglePsiSource(symbol);
        Project project = this.myCompletionParameters.getOriginalFile().getProject();
        if (SqlFileImpl.isEmptyFakeNamespace(dasObject)) {
            return true;
        }
        if (this.myAddColumns && dasObject instanceof DasTable) {
            for (DasColumn column2 : DasUtil.getColumns(dasObject)) {
                if (this.myAcceptedElementConsumer != null) {
                    this.myAcceptedElementConsumer.accept(column2, null);
                }
                if (!this.myAdjustedMatcher.prefixMatches(column2.getName())) continue;
                boolean added = this.addLookupElement(DasSymbolUtil.wrapObjectToSymbol((DasObject)column2, project), null, this.myResultSet, null, false);
                this.myEmpty = added && this.myEmpty;
                this.myHasAcceptedCompletionVariants = added;
            }
        }
        PsiElement qualifier = SqlCompletionUtil.getQualifier(state);
        if (dasObject != null) {
            if (this.myAcceptedElementConsumer != null) {
                this.myAcceptedElementConsumer.accept(dasObject, qualifier);
            }
            if (!this.myAdjustedMatcher.prefixMatches(dasObject.getName())) {
                return true;
            }
        } else if (element instanceof SqlReferenceExpression) {
            String name2;
            SqlIdentifier identifier = ((SqlReferenceExpression)element).getIdentifier();
            String prefix = identifier == null ? null : identifier.getNamePrefix();
            String string = name2 = prefix == null ? ((SqlReferenceExpression)element).getName() : prefix + ((SqlReferenceExpression)element).getName();
            if (!this.myAdjustedMatcher.prefixMatches(name2)) {
                return true;
            }
        } else if (!this.myAdjustedMatcher.prefixMatches(symbol.getName())) {
            return true;
        }
        if (!(weightDown = this.myWeightDown) && !this.checkType(symbol, dasType)) {
            if (!(this.myMissingFrom && this.myTablesBlocked && this.checkType(symbol, dasType, this.getInitialExpectedTypes(), Collections.emptySet()))) {
                return true;
            }
            weightDown = true;
        }
        if (this.myFilterPgRoutines && dasObject instanceof DasRoutine && ((arg = (DasArgument)SqlFunctionsUtil.getAcceptedArguments(dasObject).single()) == null || !SqlFunctionsUtil.isAssignable(arg, this.myQualifierType, this.getDialect()))) {
            return true;
        }
        Consumer<LookupElement> consumer2 = consumer = weightDown ? e -> this.myResultSet.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)e, (double)0.0)) : this.myResultSet;
        if (symbol instanceof ReservedEntity && (dasType != null || symbol.getKind() == ObjectKind.OBJECT_TYPE)) {
            consumer.consume((Object)SqlCompletionUtil.createEntityLookupItem(this.myCompletionParameters.getOriginalFile(), symbol.getName(), dasType, symbol.getKind(), this.shouldPreserveCase(symbol, forcedCaseSens)));
            this.myEmpty = false;
            this.myHasAcceptedCompletionVariants = true;
        } else {
            Object delegate = symbol instanceof DbElement ? ((DbElement)symbol).getDelegate() : null;
            boolean addDot = !this.checkType(symbol, dasType, this.myExpectedTypesStrict, this.getIgnoredTypes());
            DasSymbol lookupSymbol = delegate instanceof DasSymbol ? (DasSymbol)delegate : symbol;
            boolean added = this.addLookupElement(lookupSymbol, qualifier, consumer, (PsiElement)this.myRefElement, addDot);
            this.myEmpty = added && this.myEmpty;
            this.myHasAcceptedCompletionVariants = added;
        }
        return true;
    }

    private boolean addLookupElement(@NotNull DasSymbol symbol, @Nullable PsiElement qualifier, @NotNull Consumer<LookupElement> consumer, @Nullable PsiElement context, boolean addDot) {
        if (symbol == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(11);
        }
        SqlLanguageDialectEx dialect = this.getDialect();
        Consumer actualConsumer = this.addLookupPath(symbol, qualifier) ? consumer : EmptyConsumer.getInstance();
        double forcePriority = 0.0;
        if (symbol.getKind() == this.myPrimaryKind) {
            forcePriority = 50.0;
        } else if (ModelConsts.TABLE_OR_VIEW_KINDS.contains(this.myPrimaryKind) && symbol.getKind() == SqlDbElementType.LOCAL_ALIAS) {
            forcePriority = 70.0;
        }
        PsiElement place = this.getPlace();
        Project project = this.myCompletionParameters.getOriginalFile().getProject();
        return SqlCompletionUtil.addLookupElement(dialect, place != null ? SqlImplUtil.getDbms(place) : dialect.getDbms(), symbol, qualifier, project, (Consumer<? super LookupElement>)actualConsumer, addDot, forcePriority, context, (Collection)this.myExpectedTypes.getValue());
    }

    private boolean addLookupPath(@NotNull DasSymbol symbol, @Nullable PsiElement qualifier) {
        DasObject dasObject;
        if (symbol == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(12);
        }
        if ((dasObject = symbol.getDasObject()) == null) {
            return true;
        }
        if (qualifier == null) {
            return this.addedPaths.add(ObjectPaths.of(dasObject));
        }
        if (!(qualifier instanceof DasObject)) {
            return true;
        }
        ObjectPath qualifierPath = ObjectPaths.of((DasObject)qualifier);
        ObjectPath path = ObjectPath.create(dasObject.getName(), dasObject.getKind(), DbSqlUtilCore.isQuoted(dasObject), ObjectPaths.getIdentity(dasObject), qualifierPath);
        return this.addedPaths.add(path);
    }

    private boolean shouldPreserveCase(@NotNull DasSymbol target2, @Nullable Boolean forcedCaseSens) {
        Casing casing;
        if (target2 == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(13);
        }
        if (forcedCaseSens == Boolean.TRUE) {
            return true;
        }
        PsiFile containingFile = this.myCompletionParameters.getOriginalFile();
        return containingFile instanceof CasingProvider && Casing.EXACT.equals(casing = ((CasingProvider)containingFile).getCasing(target2.getKind(), target2.getDasObject()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adjustedMatcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypesStrict";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionParameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/completion/SqlCompletionScopeProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addIgnoredKinds";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTarget";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addLookupElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addLookupPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldPreserveCase";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

