/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gitrepo;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.SubmoduleAddCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.gitrepo.RepoCommand;
import org.eclipse.jgit.gitrepo.RepoProject;
import org.eclipse.jgit.gitrepo.internal.RepoText;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

class RegularSuperprojectWriter {
    private Repository repo;
    private ProgressMonitor monitor;

    RegularSuperprojectWriter(Repository repo, ProgressMonitor monitor) {
        this.repo = repo;
        this.monitor = monitor;
    }

    RevCommit write(List<RepoProject> repoProjects) throws GitAPIException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Git git = new Git(this.repo);){
                for (RepoProject proj : repoProjects) {
                    this.addSubmodule(proj.getName(), proj.getUrl(), proj.getPath(), proj.getRevision(), proj.getCopyFiles(), proj.getLinkFiles(), git);
                }
                return git.commit().setMessage(RepoText.get().repoCommitMessage).call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RepoCommand.ManifestErrorException(e);
        }
    }

    private void addSubmodule(String name, String url, String path, String revision, List<RepoProject.CopyFile> copyfiles, List<RepoProject.LinkFile> linkfiles, Git git) throws GitAPIException, IOException {
        assert (!this.repo.isBare());
        assert (git != null);
        if (!linkfiles.isEmpty()) {
            throw new UnsupportedOperationException(JGitText.get().nonBareLinkFilesNotSupported);
        }
        SubmoduleAddCommand add = git.submoduleAdd().setName(name).setPath(path).setURI(url);
        if (this.monitor != null) {
            add.setProgressMonitor(this.monitor);
        }
        Repository subRepo = add.call();
        if (revision != null) {
            Throwable throwable = null;
            Iterator<RepoProject.CopyFile> iterator = null;
            try (Git sub = new Git(subRepo);){
                sub.checkout().setName(RegularSuperprojectWriter.findRef(revision, subRepo)).call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            subRepo.close();
            git.add().addFilepattern(path).call();
        }
        for (RepoProject.CopyFile copyfile : copyfiles) {
            copyfile.copy();
            git.add().addFilepattern(copyfile.dest).call();
        }
    }

    private static String findRef(String ref, Repository repo) throws IOException {
        Ref r;
        if (!ObjectId.isId(ref) && (r = repo.exactRef("refs/remotes/origin/" + ref)) != null) {
            return r.getName();
        }
        return ref;
    }
}

