/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.input.internal.GapBuffer;
import androidx.compose.foundation.text.input.internal.ToCharArray_skikoKt;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J2\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010\u0012\u001a\u00020\bJ\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0096\u0002J\u0018\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Landroidx/compose/foundation/text/input/internal/PartialGapBuffer;", "", "text", "<init>", "(Ljava/lang/CharSequence;)V", "buffer", "Landroidx/compose/foundation/text/input/internal/GapBuffer;", "bufStart", "", "bufEnd", "length", "getLength", "()I", "replace", "", "start", "end", "textStart", "textEnd", "get", "", "index", "subSequence", "startIndex", "endIndex", "toString", "", "contentEquals", "", "other", "Companion", "foundation"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGapBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GapBuffer.kt\nandroidx/compose/foundation/text/input/internal/PartialGapBuffer\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n*L\n1#1,316:1\n97#2,4:317\n97#2,4:321\n97#2,4:325\n97#2,4:329\n*S KotlinDebug\n*F\n+ 1 GapBuffer.kt\nandroidx/compose/foundation/text/input/internal/PartialGapBuffer\n*L\n231#1:317,4\n232#1:321,4\n233#1:325,4\n234#1:329,4\n*E\n"})
public final class PartialGapBuffer
implements CharSequence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private CharSequence text;
    @Nullable
    private GapBuffer buffer;
    private int bufStart;
    private int bufEnd;
    public static final int $stable = 8;
    public static final int BUF_SIZE = 255;
    public static final int SURROUNDING_SIZE = 64;
    public static final int NOWHERE = -1;

    public PartialGapBuffer(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.bufStart = -1;
        this.bufEnd = -1;
    }

    public int getLength() {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text.length();
        }
        GapBuffer buffer = gapBuffer;
        return this.text.length() - (this.bufEnd - this.bufStart) + buffer.length();
    }

    public final void replace(int start, int end, @NotNull CharSequence text, int textStart, int textEnd) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        boolean value$iv = start <= end;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("start=" + start + " > end=" + end);
        }
        value$iv = textStart <= textEnd;
        $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("textStart=" + textStart + " > textEnd=" + textEnd);
        }
        value$iv = start >= 0;
        $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("start must be non-negative, but was " + start);
        }
        value$iv = textStart >= 0;
        $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("textStart must be non-negative, but was " + textStart);
        }
        GapBuffer buffer = this.buffer;
        int textLength = textEnd - textStart;
        if (buffer == null) {
            char[] charArray = new char[Math.max(255, textLength + 128)];
            int leftCopyCount = Math.min(start, 64);
            int rightCopyCount = Math.min(this.text.length() - end, 64);
            ToCharArray_skikoKt.toCharArray(this.text, charArray, 0, start - leftCopyCount, start);
            ToCharArray_skikoKt.toCharArray(this.text, charArray, charArray.length - rightCopyCount, end, end + rightCopyCount);
            ToCharArray_skikoKt.toCharArray(text, charArray, leftCopyCount, textStart, textEnd);
            this.buffer = new GapBuffer(charArray, leftCopyCount + textLength, charArray.length - rightCopyCount);
            this.bufStart = start - leftCopyCount;
            this.bufEnd = end + rightCopyCount;
            return;
        }
        int bufferStart = start - this.bufStart;
        int bufferEnd = end - this.bufStart;
        if (bufferStart < 0 || bufferEnd > buffer.length()) {
            this.text = this.toString();
            this.buffer = null;
            this.bufStart = -1;
            this.bufEnd = -1;
            this.replace(start, end, text, textStart, textEnd);
            return;
        }
        buffer.replace(bufferStart, bufferEnd, text, textStart, textEnd);
    }

    public static /* synthetic */ void replace$default(PartialGapBuffer partialGapBuffer, int n, int n2, CharSequence charSequence, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = charSequence.length();
        }
        partialGapBuffer.replace(n, n2, charSequence, n3, n4);
    }

    public char get(int index2) {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text.charAt(index2);
        }
        GapBuffer buffer = gapBuffer;
        if (index2 < this.bufStart) {
            return this.text.charAt(index2);
        }
        int gapBufLength = buffer.length();
        if (index2 < gapBufLength + this.bufStart) {
            return buffer.get(index2 - this.bufStart);
        }
        return this.text.charAt(index2 - (gapBufLength - this.bufEnd + this.bufStart));
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        return this.toString().subSequence(startIndex, endIndex);
    }

    @Override
    @NotNull
    public String toString() {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return ((Object)this.text).toString();
        }
        GapBuffer b = gapBuffer;
        StringBuilder sb = new StringBuilder();
        sb.append(this.text, 0, this.bufStart);
        b.append(sb);
        sb.append(this.text, this.bufEnd, this.text.length());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final boolean contentEquals(@NotNull CharSequence other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)this.toString(), (Object)((Object)other).toString());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/compose/foundation/text/input/internal/PartialGapBuffer$Companion;", "", "<init>", "()V", "BUF_SIZE", "", "SURROUNDING_SIZE", "NOWHERE", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

