/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.JsonUtilKt;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.util.LobInfoHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ClassMap;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseObjectFormatter
implements ObjectFormatter {
    private static final Logger LOG = Logger.getInstance(BaseObjectFormatter.class);
    protected final MyMap<String> myToString;
    public final FormatsCache myFormatsCache;
    public final FormatterCreator myFormatterCreator;

    public BaseObjectFormatter() {
        this(new FormatsCache(), new FormatterCreator());
    }

    public BaseObjectFormatter(@NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
        if (formatsCache == null) {
            BaseObjectFormatter.$$$reportNull$$$0(0);
        }
        if (formatterCreator == null) {
            BaseObjectFormatter.$$$reportNull$$$0(1);
        }
        this.myToString = new MyMap();
        this.myToString.register(String.class, new Converter<String, String>(){

            @Override
            public String convert(String o, GridColumn column, ObjectFormatterConfig config) {
                return o;
            }
        });
        this.myToString.register(Object[].class, new Converter<Object[], String>(){

            @Override
            public String convert(Object[] o, GridColumn column, ObjectFormatterConfig config) {
                return BaseObjectFormatter.this.arrayToString(o, column, config);
            }
        });
        this.myToString.register(char[].class, new Converter<char[], String>(){

            @Override
            public String convert(char[] o, GridColumn column, ObjectFormatterConfig config) {
                return new String(o);
            }
        });
        this.myToString.register(Timestamp.class, new Converter<Timestamp, String>(){

            @Override
            public String convert(Timestamp o, GridColumn column, ObjectFormatterConfig config) {
                return BaseObjectFormatter.this.myFormatsCache.get(FormatsCache.getTimestampFormatProvider(column, config), BaseObjectFormatter.this.myFormatterCreator, BaseObjectFormatter.this.cacheColumnFormats()).format(o);
            }
        });
        this.myToString.register(Time.class, new Converter<Time, String>(){

            @Override
            public String convert(Time o, GridColumn column, ObjectFormatterConfig config) {
                return BaseObjectFormatter.this.myFormatsCache.get(FormatsCache.getTimeFormatProvider(column, config), BaseObjectFormatter.this.myFormatterCreator, BaseObjectFormatter.this.cacheColumnFormats()).format(o);
            }
        });
        this.myToString.register(LocalTime.class, new Converter<LocalTime, String>(){

            @Override
            public String convert(LocalTime o, GridColumn column, ObjectFormatterConfig config) {
                return BaseObjectFormatter.this.myFormatsCache.get(FormatsCache.getTimeFormatProvider(column, config), BaseObjectFormatter.this.myFormatterCreator, BaseObjectFormatter.this.cacheColumnFormats()).format(o);
            }
        });
        this.myToString.register(Date.class, new Converter<Date, String>(){

            @Override
            public String convert(Date o, GridColumn column, ObjectFormatterConfig config) {
                return BaseObjectFormatter.this.dateToString(o, column, config);
            }
        });
        this.myToString.register(Number.class, new Converter<Number, String>(){

            @Override
            public String convert(Number o, GridColumn column, ObjectFormatterConfig config) {
                return BaseObjectFormatter.this.numberToString(o, column, config);
            }
        });
        this.myToString.register(BigInteger.class, new Converter<BigInteger, String>(){

            @Override
            public String convert(BigInteger o, GridColumn column, ObjectFormatterConfig config) {
                return BaseObjectFormatter.this.myFormatsCache.get(FormatsCache.getLongFormatProvider(config), BaseObjectFormatter.this.myFormatterCreator).format(o);
            }
        });
        this.myToString.register(Map.class, new Converter<Map, String>(){

            @Override
            public String convert(Map o, GridColumn column, ObjectFormatterConfig config) {
                ObjectFormatterMode itemsMode = config.getMode() == ObjectFormatterMode.DISPLAY || config.getMode() == ObjectFormatterMode.JS_SCRIPT ? ObjectFormatterMode.JS_SCRIPT : ObjectFormatterMode.JSON;
                return JsonUtilKt.toJson(o, BaseObjectFormatter.this, itemsMode, false, true, false);
            }
        });
        this.myToString.register(List.class, new Converter<List, String>(){

            @Override
            public String convert(List o, GridColumn column, ObjectFormatterConfig config) {
                ObjectFormatterMode itemsMode = config.getMode() == ObjectFormatterMode.DISPLAY || config.getMode() == ObjectFormatterMode.JS_SCRIPT ? ObjectFormatterMode.JS_SCRIPT : ObjectFormatterMode.JSON;
                return JsonUtilKt.toJson(o, BaseObjectFormatter.this, itemsMode, false, false, false);
            }
        });
        this.myToString.register(Boolean.class, new Converter<Boolean, String>(){

            @Override
            public String convert(Boolean o, GridColumn column, ObjectFormatterConfig config) {
                return String.valueOf(o);
            }
        });
        this.myToString.register(UUID.class, new Converter<UUID, String>(){

            @Override
            public String convert(UUID o, GridColumn column, ObjectFormatterConfig config) {
                return o.toString();
            }
        });
        this.myToString.register(ReservedCellValue.class, new Converter<ReservedCellValue, String>(){

            @Override
            public String convert(ReservedCellValue o, GridColumn column, ObjectFormatterConfig config) {
                return BaseObjectFormatter.this.reservedCellValueToString(o, config);
            }

            @Override
            public boolean nullValueIndicatesFailedConversion() {
                return false;
            }
        });
        this.myFormatsCache = formatsCache;
        this.myFormatterCreator = formatterCreator;
    }

    @Nullable
    protected String reservedCellValueToString(@Nullable ReservedCellValue o, ObjectFormatterConfig config) {
        return o == null || config.getMode() != ObjectFormatterMode.DISPLAY && (o == ReservedCellValue.NULL || o == ReservedCellValue.UNSET) ? null : (config.getMode() == ObjectFormatterMode.DISPLAY ? o.getDisplayName() : StringUtil.toLowerCase((String)String.valueOf((Object)o)));
    }

    @NotNull
    protected String numberToString(@NotNull Number o, GridColumn column, @NotNull ObjectFormatterConfig config) {
        if (o == null) {
            BaseObjectFormatter.$$$reportNull$$$0(2);
        }
        if (config == null) {
            BaseObjectFormatter.$$$reportNull$$$0(3);
        }
        String string = this.myFormatsCache.get(FormatsCache.getDecimalFormatProvider(column, config), this.myFormatterCreator, this.cacheColumnFormats()).format(o);
        if (string == null) {
            BaseObjectFormatter.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected String dateToString(Date o, GridColumn column, @NotNull ObjectFormatterConfig config) {
        String className;
        if (config == null) {
            BaseObjectFormatter.$$$reportNull$$$0(5);
        }
        String string = className = column instanceof JdbcColumnDescriptor ? ((JdbcColumnDescriptor)((Object)column)).getJavaClassName() : null;
        Formatter format = className == null ? this.myFormatsCache.get(FormatsCache.getDateFormatProvider(column, config), this.myFormatterCreator, this.cacheColumnFormats()) : (className.endsWith("Timestamp") ? this.myFormatsCache.get(FormatsCache.getTimestampFormatProvider(column, config), this.myFormatterCreator, this.cacheColumnFormats()) : (className.endsWith("Time") ? this.myFormatsCache.get(FormatsCache.getTimeFormatProvider(column, config), this.myFormatterCreator) : this.myFormatsCache.get(FormatsCache.getDateFormatProvider(column, config), this.myFormatterCreator, this.cacheColumnFormats())));
        String string2 = format.format(o);
        if (string2 == null) {
            BaseObjectFormatter.$$$reportNull$$$0(6);
        }
        return string2;
    }

    protected boolean cacheColumnFormats() {
        return true;
    }

    @Override
    @Nullable
    @NonNls
    public String objectToString(@Nullable Object o, GridColumn column, @NotNull ObjectFormatterConfig config) {
        if (config == null) {
            BaseObjectFormatter.$$$reportNull$$$0(7);
        }
        if (o == null) {
            return null;
        }
        Converter converter = (Converter)this.myToString.get(o.getClass());
        String result = null;
        try {
            result = converter != null ? (String)converter.convert(o, column, config) : null;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        result = result != null || converter != null && !converter.nullValueIndicatesFailedConversion() ? result : Objects.requireNonNull(this.objectToString(String.valueOf(o), column, config));
        return result;
    }

    @Override
    public boolean isStringLiteral(@Nullable GridColumn column, @Nullable Object value, @NotNull ObjectFormatterMode mode) {
        if (mode == null) {
            BaseObjectFormatter.$$$reportNull$$$0(8);
        }
        if (mode == ObjectFormatterMode.JSON) {
            return !(value instanceof Number) && !(value instanceof Boolean) && !(value instanceof Map) && !(value instanceof List);
        }
        return value instanceof String;
    }

    @Override
    @NotNull
    public String getStringLiteral(@NotNull String value, GridColumn column, @NotNull ObjectFormatterMode mode) {
        if (value == null) {
            BaseObjectFormatter.$$$reportNull$$$0(9);
        }
        if (mode == null) {
            BaseObjectFormatter.$$$reportNull$$$0(10);
        }
        String string = "'" + StringUtil.escapeChars((String)value, (char[])new char[]{'\'', '\\'}) + "'";
        if (string == null) {
            BaseObjectFormatter.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    protected <T> String arrayToString(T[] o, GridColumn column, ObjectFormatterConfig config) {
        if (o.length == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int len = Math.min(o.length, config.getMode() == ObjectFormatterMode.DISPLAY ? LobInfoHelper.MAX_ARRAY_SIZE : o.length);
        DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig itemConfig = new DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig(null, false, null, config.getSettings());
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            this.appendArrayItem(sb, o[i], column, itemConfig);
        }
        if (len < o.length) {
            sb.append(",...");
        }
        sb.append("}");
        String string = sb.toString();
        if (string == null) {
            BaseObjectFormatter.$$$reportNull$$$0(12);
        }
        return string;
    }

    protected <T> void appendArrayItem(StringBuilder sb, T o, GridColumn column, ObjectFormatterConfig config) {
        sb.append(this.objectToString(o, column, config));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatsCache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatterCreator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/BaseObjectFormatter";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/BaseObjectFormatter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "numberToString";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "dateToString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteral";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "numberToString";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dateToString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "objectToString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteral";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStringLiteral";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 11, 12 -> new IllegalStateException(string);
        };
    }

    protected static final class MyMap<T>
    extends ClassMap<Converter<Object, T>> {
        private MyMap() {
            super(new ConcurrentHashMap());
        }

        public <X> void register(@NotNull Class<X> aClass, Converter<X, T> value) {
            if (aClass == null) {
                MyMap.$$$reportNull$$$0(0);
            }
            super.put(aClass, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/database/extractors/BaseObjectFormatter$MyMap", "register"));
        }
    }

    public static interface Converter<X, V> {
        public V convert(X var1, GridColumn var2, ObjectFormatterConfig var3);

        default public boolean nullValueIndicatesFailedConversion() {
            return true;
        }
    }
}

