/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;

public class GenericSequence
implements DBSSequence,
DBPQualifiedObject,
DBPNamedObject2,
DBPSaveableObject {
    private final GenericStructContainer container;
    private String name;
    private String description;
    private Number lastValue;
    private Number minValue;
    private Number maxValue;
    private Number incrementBy;
    private boolean persisted;

    public GenericSequence(GenericStructContainer container, String name, String description, Number lastValue, Number minValue, Number maxValue, Number incrementBy) {
        this.container = container;
        this.name = name;
        this.description = description;
        this.lastValue = lastValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.incrementBy = incrementBy;
        this.persisted = true;
    }

    public GenericSequence(@NotNull GenericStructContainer container, @NotNull String name) {
        this.container = container;
        this.name = name;
        this.lastValue = 0;
        this.minValue = 1;
        this.maxValue = Long.MAX_VALUE;
        this.incrementBy = 1;
        this.persisted = false;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=10)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.container;
    }

    @NotNull
    public GenericDataSource getDataSource() {
        return this.container.getDataSource();
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.container.getCatalog(), this.container.getSchema(), this});
    }

    @Property(viewable=true, order=2)
    public Number getLastValue() {
        return this.lastValue;
    }

    public void setLastValue(Number lastValue) {
        this.lastValue = lastValue;
    }

    @Property(viewable=true, order=3)
    public Number getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Number minValue) {
        this.minValue = minValue;
    }

    @Property(viewable=true, order=4)
    public Number getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Number maxValue) {
        this.maxValue = maxValue;
    }

    @Property(viewable=true, order=5)
    public Number getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(Number incrementBy) {
        this.incrementBy = incrementBy;
    }
}

