package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CountNodeTupleOrders invokes the linkwan.CountNodeTupleOrders API synchronously
func (client *Client) CountNodeTupleOrders(request *CountNodeTupleOrdersRequest) (response *CountNodeTupleOrdersResponse, err error) {
	response = CreateCountNodeTupleOrdersResponse()
	err = client.DoAction(request, response)
	return
}

// CountNodeTupleOrdersWithChan invokes the linkwan.CountNodeTupleOrders API asynchronously
func (client *Client) CountNodeTupleOrdersWithChan(request *CountNodeTupleOrdersRequest) (<-chan *CountNodeTupleOrdersResponse, <-chan error) {
	responseChan := make(chan *CountNodeTupleOrdersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CountNodeTupleOrders(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CountNodeTupleOrdersWithCallback invokes the linkwan.CountNodeTupleOrders API asynchronously
func (client *Client) CountNodeTupleOrdersWithCallback(request *CountNodeTupleOrdersRequest, callback func(response *CountNodeTupleOrdersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CountNodeTupleOrdersResponse
		var err error
		defer close(result)
		response, err = client.CountNodeTupleOrders(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CountNodeTupleOrdersRequest is the request struct for api CountNodeTupleOrders
type CountNodeTupleOrdersRequest struct {
	*requests.RpcRequest
	IsKpm       requests.Boolean `position:"Query" name:"IsKpm"`
	States      *[]string        `position:"Query" name:"States"  type:"Repeated"`
	ApiProduct  string           `position:"Body" name:"ApiProduct"`
	ApiRevision string           `position:"Body" name:"ApiRevision"`
}

// CountNodeTupleOrdersResponse is the response struct for api CountNodeTupleOrders
type CountNodeTupleOrdersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      int64  `json:"Data" xml:"Data"`
}

// CreateCountNodeTupleOrdersRequest creates a request to invoke CountNodeTupleOrders API
func CreateCountNodeTupleOrdersRequest() (request *CountNodeTupleOrdersRequest) {
	request = &CountNodeTupleOrdersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "CountNodeTupleOrders", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCountNodeTupleOrdersResponse creates a response to parse from CountNodeTupleOrders response
func CreateCountNodeTupleOrdersResponse() (response *CountNodeTupleOrdersResponse) {
	response = &CountNodeTupleOrdersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
