package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDevopsOrganization invokes the devops_rdc.DeleteDevopsOrganization API synchronously
func (client *Client) DeleteDevopsOrganization(request *DeleteDevopsOrganizationRequest) (response *DeleteDevopsOrganizationResponse, err error) {
	response = CreateDeleteDevopsOrganizationResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDevopsOrganizationWithChan invokes the devops_rdc.DeleteDevopsOrganization API asynchronously
func (client *Client) DeleteDevopsOrganizationWithChan(request *DeleteDevopsOrganizationRequest) (<-chan *DeleteDevopsOrganizationResponse, <-chan error) {
	responseChan := make(chan *DeleteDevopsOrganizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDevopsOrganization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDevopsOrganizationWithCallback invokes the devops_rdc.DeleteDevopsOrganization API asynchronously
func (client *Client) DeleteDevopsOrganizationWithCallback(request *DeleteDevopsOrganizationRequest, callback func(response *DeleteDevopsOrganizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDevopsOrganizationResponse
		var err error
		defer close(result)
		response, err = client.DeleteDevopsOrganization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDevopsOrganizationRequest is the request struct for api DeleteDevopsOrganization
type DeleteDevopsOrganizationRequest struct {
	*requests.RpcRequest
	OrgId string `position:"Body" name:"OrgId"`
}

// DeleteDevopsOrganizationResponse is the response struct for api DeleteDevopsOrganization
type DeleteDevopsOrganizationResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Object       string `json:"Object" xml:"Object"`
}

// CreateDeleteDevopsOrganizationRequest creates a request to invoke DeleteDevopsOrganization API
func CreateDeleteDevopsOrganizationRequest() (request *DeleteDevopsOrganizationRequest) {
	request = &DeleteDevopsOrganizationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "DeleteDevopsOrganization", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDevopsOrganizationResponse creates a response to parse from DeleteDevopsOrganization response
func CreateDeleteDevopsOrganizationResponse() (response *DeleteDevopsOrganizationResponse) {
	response = &DeleteDevopsOrganizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
