package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PreModifyMedia invokes the cloudcallcenter.PreModifyMedia API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/premodifymedia.html
func (client *Client) PreModifyMedia(request *PreModifyMediaRequest) (response *PreModifyMediaResponse, err error) {
	response = CreatePreModifyMediaResponse()
	err = client.DoAction(request, response)
	return
}

// PreModifyMediaWithChan invokes the cloudcallcenter.PreModifyMedia API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/premodifymedia.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PreModifyMediaWithChan(request *PreModifyMediaRequest) (<-chan *PreModifyMediaResponse, <-chan error) {
	responseChan := make(chan *PreModifyMediaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PreModifyMedia(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PreModifyMediaWithCallback invokes the cloudcallcenter.PreModifyMedia API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/premodifymedia.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PreModifyMediaWithCallback(request *PreModifyMediaRequest, callback func(response *PreModifyMediaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PreModifyMediaResponse
		var err error
		defer close(result)
		response, err = client.PreModifyMedia(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PreModifyMediaRequest is the request struct for api PreModifyMedia
type PreModifyMediaRequest struct {
	*requests.RpcRequest
	InstanceId  string `position:"Query" name:"InstanceId"`
	FileName    string `position:"Query" name:"FileName"`
	Name        string `position:"Query" name:"Name"`
	Description string `position:"Query" name:"Description"`
	Type        string `position:"Query" name:"Type"`
	Content     string `position:"Query" name:"Content"`
}

// PreModifyMediaResponse is the response struct for api PreModifyMedia
type PreModifyMediaResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	Success             bool                `json:"Success" xml:"Success"`
	Code                string              `json:"Code" xml:"Code"`
	Message             string              `json:"Message" xml:"Message"`
	HttpStatusCode      int                 `json:"HttpStatusCode" xml:"HttpStatusCode"`
	PreModifyMediaParam PreModifyMediaParam `json:"PreModifyMediaParam" xml:"PreModifyMediaParam"`
}

// CreatePreModifyMediaRequest creates a request to invoke PreModifyMedia API
func CreatePreModifyMediaRequest() (request *PreModifyMediaRequest) {
	request = &PreModifyMediaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "PreModifyMedia", "", "")
	request.Method = requests.POST
	return
}

// CreatePreModifyMediaResponse creates a response to parse from PreModifyMedia response
func CreatePreModifyMediaResponse() (response *PreModifyMediaResponse) {
	response = &PreModifyMediaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
