package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateServerGroupServersAttribute invokes the alb.UpdateServerGroupServersAttribute API synchronously
func (client *Client) UpdateServerGroupServersAttribute(request *UpdateServerGroupServersAttributeRequest) (response *UpdateServerGroupServersAttributeResponse, err error) {
	response = CreateUpdateServerGroupServersAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateServerGroupServersAttributeWithChan invokes the alb.UpdateServerGroupServersAttribute API asynchronously
func (client *Client) UpdateServerGroupServersAttributeWithChan(request *UpdateServerGroupServersAttributeRequest) (<-chan *UpdateServerGroupServersAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateServerGroupServersAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateServerGroupServersAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateServerGroupServersAttributeWithCallback invokes the alb.UpdateServerGroupServersAttribute API asynchronously
func (client *Client) UpdateServerGroupServersAttributeWithCallback(request *UpdateServerGroupServersAttributeRequest, callback func(response *UpdateServerGroupServersAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateServerGroupServersAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateServerGroupServersAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateServerGroupServersAttributeRequest is the request struct for api UpdateServerGroupServersAttribute
type UpdateServerGroupServersAttributeRequest struct {
	*requests.RpcRequest
	ClientToken   string                                      `position:"Query" name:"ClientToken"`
	ServerGroupId string                                      `position:"Query" name:"ServerGroupId"`
	Servers       *[]UpdateServerGroupServersAttributeServers `position:"Query" name:"Servers"  type:"Repeated"`
	DryRun        requests.Boolean                            `position:"Query" name:"DryRun"`
}

// UpdateServerGroupServersAttributeServers is a repeated param struct in UpdateServerGroupServersAttributeRequest
type UpdateServerGroupServersAttributeServers struct {
	ServerType  string `name:"ServerType"`
	Port        string `name:"Port"`
	Description string `name:"Description"`
	ServerIp    string `name:"ServerIp"`
	Weight      string `name:"Weight"`
	ServerId    string `name:"ServerId"`
}

// UpdateServerGroupServersAttributeResponse is the response struct for api UpdateServerGroupServersAttribute
type UpdateServerGroupServersAttributeResponse struct {
	*responses.BaseResponse
	JobId     string `json:"JobId" xml:"JobId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateServerGroupServersAttributeRequest creates a request to invoke UpdateServerGroupServersAttribute API
func CreateUpdateServerGroupServersAttributeRequest() (request *UpdateServerGroupServersAttributeRequest) {
	request = &UpdateServerGroupServersAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "UpdateServerGroupServersAttribute", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateServerGroupServersAttributeResponse creates a response to parse from UpdateServerGroupServersAttribute response
func CreateUpdateServerGroupServersAttributeResponse() (response *UpdateServerGroupServersAttributeResponse) {
	response = &UpdateServerGroupServersAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
