package powerplatformapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/powerplatform/mgmt/2020-10-30/powerplatform"
	"github.com/Azure/go-autorest/autorest"
)

// EnterprisePoliciesClientAPI contains the set of methods on the EnterprisePoliciesClient type.
type EnterprisePoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, enterprisePolicyName string, resourceGroupName string, parameters powerplatform.EnterprisePolicy) (result powerplatform.EnterprisePolicy, err error)
	Delete(ctx context.Context, resourceGroupName string, enterprisePolicyName string) (result autorest.Response, err error)
	Get(ctx context.Context, enterprisePolicyName string, resourceGroupName string) (result powerplatform.EnterprisePolicy, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result powerplatform.EnterprisePolicyList, err error)
	ListBySubscription(ctx context.Context) (result powerplatform.EnterprisePolicyList, err error)
	Update(ctx context.Context, enterprisePolicyName string, resourceGroupName string, parameters powerplatform.EnterprisePolicy) (result powerplatform.EnterprisePolicy, err error)
}

var _ EnterprisePoliciesClientAPI = (*powerplatform.EnterprisePoliciesClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result powerplatform.OperationList, err error)
}

var _ OperationsClientAPI = (*powerplatform.OperationsClient)(nil)

// PrivateEndpointConnectionsClientAPI contains the set of methods on the PrivateEndpointConnectionsClient type.
type PrivateEndpointConnectionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, enterprisePolicyName string, privateEndpointConnectionName string, parameters powerplatform.PrivateEndpointConnection) (result powerplatform.PrivateEndpointConnectionsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, enterprisePolicyName string, privateEndpointConnectionName string) (result powerplatform.PrivateEndpointConnectionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, enterprisePolicyName string, privateEndpointConnectionName string) (result powerplatform.PrivateEndpointConnection, err error)
	ListByEnterprisePolicy(ctx context.Context, resourceGroupName string, enterprisePolicyName string) (result powerplatform.PrivateEndpointConnectionListResult, err error)
}

var _ PrivateEndpointConnectionsClientAPI = (*powerplatform.PrivateEndpointConnectionsClient)(nil)

// PrivateLinkResourcesClientAPI contains the set of methods on the PrivateLinkResourcesClient type.
type PrivateLinkResourcesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, enterprisePolicyName string, groupName string) (result powerplatform.PrivateLinkResource, err error)
	ListByEnterprisePolicy(ctx context.Context, resourceGroupName string, enterprisePolicyName string) (result powerplatform.PrivateLinkResourceListResult, err error)
}

var _ PrivateLinkResourcesClientAPI = (*powerplatform.PrivateLinkResourcesClient)(nil)

// SubnetsClientAPI contains the set of methods on the SubnetsClient type.
type SubnetsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, enterprisePolicyName string, subnetName string) (result powerplatform.Subnet, err error)
	Get(ctx context.Context, resourceGroupName string, enterprisePolicyName string, subnetName string) (result powerplatform.Subnet, err error)
	ListByEnterprisePolicy(ctx context.Context, resourceGroupName string, enterprisePolicyName string) (result powerplatform.SubnetListResult, err error)
}

var _ SubnetsClientAPI = (*powerplatform.SubnetsClient)(nil)
