/* Steve, the jobserver
 * (c) 2025 Michał Górny
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#pragma once

#ifndef STEVE_H
#define STEVE_H 1

#include <sys/ioctl.h>

/* get number of currently available tokens */
#define STEVE_IOC_GET_TOKENS _IOR(0x53, 0x00, int64_t)
/* get/set total job count (may lower min-jobs) */
#define STEVE_IOC_GET_JOBS _IOR(0x53, 0x01, int64_t)
#define STEVE_IOC_SET_JOBS _IOW(0x53, 0x01, int64_t)
/* get/set min-jobs (must be no higher than jobs) */
#define STEVE_IOC_GET_MIN_JOBS _IOR(0x53, 0x02, int64_t)
#define STEVE_IOC_SET_MIN_JOBS _IOW(0x53, 0x02, int64_t)
/* get/set load-average */
#define STEVE_IOC_GET_LOAD_AVG _IOR(0x53, 0x03, double)
#define STEVE_IOC_SET_LOAD_AVG _IOW(0x53, 0x03, double)
/* get/set load-recheck-timeout */
#define STEVE_IOC_GET_LOAD_RECHECK_TIMEOUT _IOR(0x53, 0x04, double)
#define STEVE_IOC_SET_LOAD_RECHECK_TIMEOUT _IOW(0x53, 0x04, double)

#define STEVE_IOC_MASK_GET _IOR(0x53, 0, int64_t)
#define STEVE_IOC_MASK_SET _IOW(0x53, 0, int64_t)

#define STEVE_IOC_IS_GET(num) ((num & STEVE_IOC_MASK_GET) == STEVE_IOC_MASK_GET)
#define STEVE_IOC_IS_SET(num) ((num & STEVE_IOC_MASK_SET) == STEVE_IOC_MASK_SET)

#endif /*STEVE_H*/
