/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.util.Locale;

public class MimeType {
    private String primaryType;
    private String subType;

    public MimeType() {
        this.primaryType = "application";
        this.subType = "*";
    }

    public MimeType(String rawdata) throws IllegalArgumentException {
        this.parse(rawdata);
    }

    public MimeType(String primary, String sub) {
        this.primaryType = primary.toLowerCase(Locale.ENGLISH);
        this.subType = sub.toLowerCase(Locale.ENGLISH);
    }

    private void parse(String rawdata) throws IllegalArgumentException {
        int slashIndex = rawdata.indexOf(47);
        int semIndex = rawdata.indexOf(59);
        if (slashIndex < 0 && semIndex < 0) {
            this.primaryType = rawdata;
            this.subType = "*";
        } else if (slashIndex < 0 && semIndex >= 0) {
            this.primaryType = rawdata.substring(0, semIndex);
            this.subType = "*";
        } else if (slashIndex >= 0 && semIndex < 0) {
            this.primaryType = rawdata.substring(0, slashIndex).trim().toLowerCase(Locale.ENGLISH);
            this.subType = rawdata.substring(slashIndex + 1).trim().toLowerCase(Locale.ENGLISH);
        } else if (slashIndex < semIndex) {
            this.primaryType = rawdata.substring(0, slashIndex).trim().toLowerCase(Locale.ENGLISH);
            this.subType = rawdata.substring(slashIndex + 1, semIndex).trim().toLowerCase(Locale.ENGLISH);
        } else {
            throw new IllegalArgumentException("Unable to find a sub type.");
        }
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String toString() {
        return this.getBaseType();
    }

    public String getBaseType() {
        return this.primaryType + "/" + this.subType;
    }

    public boolean match(MimeType type) {
        return this.primaryType.equals(type.getPrimaryType()) && (this.subType.equals("*") || type.getSubType().equals("*") || this.subType.equals(type.getSubType()));
    }

    public boolean match(String rawdata) throws IllegalArgumentException {
        return this.match(new MimeType(rawdata));
    }
}

