/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables.panel.filtering;

import com.intellij.CommonBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.observable.util.PropertyOperationUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.scientific.tables.DSTableBundle;
import com.intellij.scientific.tables.api.FilterComparisonType;
import com.intellij.scientific.tables.api.FilterExpression;
import com.intellij.scientific.tables.api.FilterOperator;
import com.intellij.scientific.tables.panel.UtilKt;
import com.intellij.scientific.tables.panel.filtering.DSFilterView;
import com.intellij.scientific.tables.panel.filtering.DSFilteringPanelSettings;
import com.intellij.scientific.tables.panel.filtering.DSSingleFilterExpression;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.LabelKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001HB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010#\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0014\u0010%\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0014\u0010&\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0014\u0010'\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0014\u0010(\u001a\u00020 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\b\u0010*\u001a\u0004\u0018\u00010+J\u0006\u0010,\u001a\u00020 J\u0006\u0010-\u001a\u00020 J\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u00020\u001d2\b\u00101\u001a\u0004\u0018\u00010+J\u0010\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020/H\u0002J\u0012\u00104\u001a\u00020 2\b\u00105\u001a\u0004\u0018\u00010+H\u0002J\u0006\u00106\u001a\u00020 J\u001c\u00107\u001a\u0004\u0018\u00010\u00102\u0006\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010;H\u0002J\u0010\u0010<\u001a\u00020\u001b2\u0006\u00108\u001a\u000209H\u0002J\b\u0010=\u001a\u00020>H\u0002J\u0016\u0010?\u001a\u00020\u001b2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010A\u001a\u00020\u001b2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020\u001dH\u0002J\u0010\u0010F\u001a\u0002092\u0006\u0010G\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/intellij/scientific/tables/panel/filtering/DSFilterView;", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "columnsFromStart", "", "Lcom/intellij/database/datagrid/GridColumn;", "comparisonTypes", "Lcom/intellij/scientific/tables/api/FilterComparisonType;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;Ljava/util/List;Ljava/util/List;)V", "columns", "", "propertyGraph", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "currentFiltersFlatExpression", "Lcom/intellij/scientific/tables/panel/filtering/DSSingleFilterExpression;", "currentOperatorPropertyGraph", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "Lcom/intellij/scientific/tables/api/FilterOperator;", "cancelButton", "Ljavax/swing/JButton;", "applyButton", "deleteButton", "addFilterLink", "Lcom/intellij/ui/HyperlinkLabel;", "panelWithFilters", "Ljavax/swing/JPanel;", "popUp", "Lcom/intellij/openapi/ui/popup/JBPopup;", "applyAction", "Lkotlin/Function0;", "", "minPopupSize", "Lcom/intellij/util/ui/JBDimension;", "addOnApplyAction", "action", "addOnDeleteAction", "addOnCancelAction", "addOnAddFilterAction", "columnsAddedToTable", "addedColumns", "getFilters", "Lcom/intellij/scientific/tables/api/FilterExpression;", "clearFilters", "closePopUp", "isPopupOpened", "", "createPopUp", "appliedFilters", "createPanelWithButtons", "toDisplayDeleteButton", "updatePanelWithFilters", "filters", "addNewFilter", "createSingleFilterExpression", "index", "", "filter", "Lcom/intellij/scientific/tables/api/FilterExpression$SingleExpression;", "createFirstPanel", "createFirstPanelWhereLabel", "Lcom/intellij/openapi/ui/DialogPanel;", "createFirstPanelOperatorCombobox", "operator", "createFirstPanelOperatorLabel", "currentOperator", "computePopupSize", "Ljava/awt/Dimension;", "currentPopup", "computeLeftGapForFirstPanel", "currentPanel", "DuplicateRemoveActionGroup", "intellij.scientific.tables"})
@SourceDebugExtension(value={"SMAP\nDSFilterView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DSFilterView.kt\ncom/intellij/scientific/tables/panel/filtering/DSFilterView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,353:1\n1#2:354\n1669#3,8:355\n1056#3:363\n1563#3:364\n1634#3,3:365\n1878#3,3:368\n*S KotlinDebug\n*F\n+ 1 DSFilterView.kt\ncom/intellij/scientific/tables/panel/filtering/DSFilterView\n*L\n98#1:355,8\n98#1:363\n104#1:364\n104#1:365,3\n184#1:368,3\n*E\n"})
public final class DSFilterView {
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final List<FilterComparisonType> comparisonTypes;
    @NotNull
    private final List<GridColumn> columns;
    @NotNull
    private final PropertyGraph propertyGraph;
    @NotNull
    private final List<DSSingleFilterExpression> currentFiltersFlatExpression;
    @NotNull
    private final GraphProperty<FilterOperator> currentOperatorPropertyGraph;
    @NotNull
    private final JButton cancelButton;
    @NotNull
    private final JButton applyButton;
    @NotNull
    private final JButton deleteButton;
    @NotNull
    private final HyperlinkLabel addFilterLink;
    @NotNull
    private final JPanel panelWithFilters;
    @Nullable
    private JBPopup popUp;
    @Nullable
    private Function0<Unit> applyAction;
    @NotNull
    private final JBDimension minPopupSize;

    /*
     * WARNING - void declaration
     */
    public DSFilterView(@NotNull DataGrid grid2, @NotNull List<? extends GridColumn> columnsFromStart, @NotNull List<? extends FilterComparisonType> comparisonTypes) {
        void $this$panelWithFilters_u24lambda_u241;
        JComponent $this$applyButton_u24lambda_u240;
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)grid2, (String)"grid");
        Intrinsics.checkNotNullParameter(columnsFromStart, (String)"columnsFromStart");
        Intrinsics.checkNotNullParameter(comparisonTypes, (String)"comparisonTypes");
        this.grid = grid2;
        this.comparisonTypes = comparisonTypes;
        this.columns = CollectionsKt.toMutableList((Collection)columnsFromStart);
        this.propertyGraph = new PropertyGraph(null, false, 3, null);
        this.currentFiltersFlatExpression = new ArrayList();
        this.currentOperatorPropertyGraph = this.propertyGraph.property((Object)FilterOperator.AND);
        this.cancelButton = new JButton(CommonBundle.getCancelButtonText());
        JButton jButton = jComponent = new JButton(CommonBundle.getApplyButtonText());
        DSFilterView dSFilterView = this;
        boolean bl = false;
        UtilKt.defaultStyle($this$applyButton_u24lambda_u240);
        dSFilterView.applyButton = jComponent;
        this.deleteButton = new JButton(DSTableBundle.message("ds.TableFiltering.FilterView.panel.delete", new Object[0]));
        this.addFilterLink = new HyperlinkLabel(DSTableBundle.message("ds.TableFiltering.FilterView.panel.addFilter", new Object[0]));
        $this$applyButton_u24lambda_u240 = jComponent = new JPanel((LayoutManager)new VerticalLayout(10));
        dSFilterView = this;
        boolean bl2 = false;
        $this$panelWithFilters_u24lambda_u241.setBorder(JBUI.Borders.empty((int)10));
        dSFilterView.panelWithFilters = jComponent;
        this.minPopupSize = new JBDimension(DSFilteringPanelSettings.INSTANCE.getMIN_POPUP_WIDTH(), DSFilteringPanelSettings.INSTANCE.getMIN_POPUP_HEIGHT());
    }

    public final void addOnApplyAction(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.applyAction = action2;
        this.applyButton.addActionListener(arg_0 -> DSFilterView.addOnApplyAction$lambda$2(action2, arg_0));
    }

    public final void addOnDeleteAction(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.deleteButton.addActionListener(arg_0 -> DSFilterView.addOnDeleteAction$lambda$3(action2, arg_0));
    }

    public final void addOnCancelAction(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.cancelButton.addActionListener(arg_0 -> DSFilterView.addOnCancelAction$lambda$4(action2, arg_0));
    }

    public final void addOnAddFilterAction(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.addFilterLink.addHyperlinkListener(arg_0 -> DSFilterView.addOnAddFilterAction$lambda$5(action2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final void columnsAddedToTable(@NotNull List<? extends GridColumn> addedColumns) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(addedColumns, (String)"addedColumns");
        List bothColumns = CollectionsKt.plus((Collection)this.columns, (Iterable)addedColumns);
        Iterable $this$distinctBy$iv = bothColumns;
        boolean $i$f$distinctBy = false;
        HashSet<Integer> set$iv = new HashSet<Integer>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            GridColumn it = (GridColumn)e$iv;
            boolean bl = false;
            Integer key$iv = it.getColumnNumber();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$sortedBy = false;
        List uniqueColumns = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                GridColumn it = (GridColumn)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getColumnNumber());
                it = (GridColumn)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getColumnNumber()));
            }
        });
        this.columns.clear();
        this.columns.addAll(uniqueColumns);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FilterExpression getFilters() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.currentFiltersFlatExpression;
        FilterExpression.Companion companion = FilterExpression.Companion;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DSSingleFilterExpression dSSingleFilterExpression = (DSSingleFilterExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFilterSingleExpression());
        }
        return companion.fromFlatExpression((List)destination$iv$iv, (FilterOperator)((Object)this.currentOperatorPropertyGraph.get()));
    }

    public final void clearFilters() {
        this.currentFiltersFlatExpression.clear();
    }

    public final void closePopUp() {
        JBPopup jBPopup = this.popUp;
        if (jBPopup != null) {
            jBPopup.cancel();
        }
        this.popUp = null;
    }

    public final boolean isPopupOpened() {
        JBPopup currentPopup = this.popUp;
        return currentPopup != null && !currentPopup.isDisposed();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JBPopup createPopUp(@Nullable FilterExpression appliedFilters) {
        JBPopup jBPopup;
        Dimension newPopupSize;
        JBPopup jBPopup2;
        void $this$createPopUp_u24lambda_u2411;
        JPanel thisPanel = new JPanel(new BorderLayout());
        thisPanel.setBorder(JBUI.Borders.empty((int)10));
        this.updatePanelWithFilters(appliedFilters);
        JBScrollPane scrollPane = new JBScrollPane((Component)this.panelWithFilters);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        thisPanel.add((Component)scrollPane, "Center");
        thisPanel.add((Component)this.createPanelWithButtons(appliedFilters != null), "South");
        Ref.ObjectRef mainPopup = new Ref.ObjectRef();
        JBPopup jBPopup3 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)thisPanel, null).setProject(this.grid.getProject()).setRequestFocus(true).setResizable(true).setMovable(true).setCancelOnClickOutside(false).setTitle(DSTableBundle.message("ds.TableFiltering.FilterView.panel.name", new Object[0])).setMinSize((Dimension)this.minPopupSize).setKeyEventHandler(arg_0 -> DSFilterView.createPopUp$lambda$10(arg_0 -> DSFilterView.createPopUp$lambda$9(this, mainPopup, arg_0), arg_0)).setLocateWithinScreenBounds(false).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup3, (String)"createPopup(...)");
        JBPopup jBPopup4 = jBPopup3;
        Ref.ObjectRef objectRef = mainPopup;
        boolean bl = false;
        $this$createPopUp_u24lambda_u2411.canClose();
        objectRef.element = jBPopup3;
        if (mainPopup.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainPopup");
            jBPopup2 = null;
        } else {
            jBPopup2 = (JBPopup)mainPopup.element;
        }
        Dimension dimension = newPopupSize = this.computePopupSize(jBPopup2);
        if (dimension != null) {
            JBPopup jBPopup5;
            Dimension size = dimension;
            boolean bl2 = false;
            if (mainPopup.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainPopup");
                jBPopup5 = null;
            } else {
                jBPopup5 = (JBPopup)mainPopup.element;
            }
            jBPopup5.setSize(size);
        }
        if (mainPopup.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainPopup");
            v3 = null;
        } else {
            v3 = this.popUp = (JBPopup)mainPopup.element;
        }
        if (mainPopup.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainPopup");
            jBPopup = null;
        } else {
            jBPopup = (JBPopup)mainPopup.element;
        }
        return jBPopup;
    }

    private final JPanel createPanelWithButtons(boolean toDisplayDeleteButton) {
        return (JPanel)BuilderKt.panel(arg_0 -> DSFilterView.createPanelWithButtons$lambda$14(this, toDisplayDeleteButton, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePanelWithFilters(FilterExpression filters) {
        this.panelWithFilters.removeAll();
        this.currentFiltersFlatExpression.clear();
        if (filters == null) {
            this.addNewFilter();
        } else {
            Iterable $this$forEachIndexed$iv = filters.getFlatFilterExpression();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void filter;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FilterExpression.SingleExpression singleExpression = (FilterExpression.SingleExpression)item$iv;
                int index = n;
                boolean bl = false;
                DSSingleFilterExpression oneFilter = this.createSingleFilterExpression(index, (FilterExpression.SingleExpression)filter);
                if (oneFilter == null) continue;
                this.panelWithFilters.add((Component)oneFilter.createPanel());
                this.currentFiltersFlatExpression.add(oneFilter);
            }
        }
    }

    public final void addNewFilter() {
        DSSingleFilterExpression dSSingleFilterExpression = this.createSingleFilterExpression(this.currentFiltersFlatExpression.size(), null);
        if (dSSingleFilterExpression == null) {
            return;
        }
        DSSingleFilterExpression singleFilterExpression = dSSingleFilterExpression;
        DialogPanel newFilterPanel = singleFilterExpression.createPanel();
        this.panelWithFilters.add((Component)newFilterPanel);
        this.currentFiltersFlatExpression.add(singleFilterExpression);
        JBPopup currentPopup = this.popUp;
        if (currentPopup != null && !currentPopup.isDisposed()) {
            Dimension newPopupSize;
            Dimension dimension = newPopupSize = this.computePopupSize(currentPopup);
            if (dimension != null) {
                Dimension size = dimension;
                boolean bl = false;
                currentPopup.setSize(size);
            }
        }
        this.panelWithFilters.validate();
        this.panelWithFilters.scrollRectToVisible(newFilterPanel.getBounds());
    }

    private final DSSingleFilterExpression createSingleFilterExpression(int index, FilterExpression.SingleExpression filter) {
        if (this.columns.isEmpty()) {
            return null;
        }
        JPanel firstPanel = this.createFirstPanel(index);
        FilterExpression.SingleExpression singleExpression = filter;
        if (singleExpression == null) {
            String string = this.columns.get(0).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            singleExpression = new FilterExpression.SingleExpression(string, FilterComparisonType.EQUALS, "");
        }
        FilterExpression.SingleExpression initialSingleExpression = singleExpression;
        DataGrid dataGrid = this.grid;
        int n = this.computeLeftGapForFirstPanel(firstPanel);
        List<GridColumn> list = this.columns;
        PropertyGraph propertyGraph = this.propertyGraph;
        Object object = new AnAction[]{new DuplicateRemoveActionGroup(index)};
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(object);
        object = this.comparisonTypes;
        return new DSSingleFilterExpression(dataGrid, list, (List<? extends FilterComparisonType>)object, firstPanel, n, (ActionGroup)defaultActionGroup, propertyGraph, initialSingleExpression);
    }

    private final JPanel createFirstPanel(int index) {
        return switch (index) {
            case 0 -> (JPanel)this.createFirstPanelWhereLabel();
            case 1 -> this.createFirstPanelOperatorCombobox(this.currentOperatorPropertyGraph);
            default -> this.createFirstPanelOperatorLabel(this.currentOperatorPropertyGraph);
        };
    }

    private final DialogPanel createFirstPanelWhereLabel() {
        return BuilderKt.panel(DSFilterView::createFirstPanelWhereLabel$lambda$18);
    }

    private final JPanel createFirstPanelOperatorCombobox(GraphProperty<FilterOperator> operator) {
        return (JPanel)BuilderKt.panel(arg_0 -> DSFilterView.createFirstPanelOperatorCombobox$lambda$21(operator, arg_0));
    }

    private final JPanel createFirstPanelOperatorLabel(GraphProperty<FilterOperator> currentOperator) {
        return (JPanel)BuilderKt.panel(arg_0 -> DSFilterView.createFirstPanelOperatorLabel$lambda$24(currentOperator, arg_0));
    }

    private final Dimension computePopupSize(JBPopup currentPopup) {
        int n;
        Dimension dimension = currentPopup.getContent().getPreferredSize();
        if (dimension == null) {
            return null;
        }
        Dimension popupPreferredSize = dimension;
        Component component = this.panelWithFilters.getComponent(0);
        JComponent jComponent = component instanceof JComponent ? (JComponent)component : null;
        if (jComponent == null) {
            return null;
        }
        JComponent firstFilter = jComponent;
        int oneFilterHeight = UiSizeUtilKt.getPreferredHeight((JComponent)firstFilter);
        int filtersNumber = this.currentFiltersFlatExpression.size();
        if (currentPopup.isVisible()) {
            n = filtersNumber < 5 ? popupPreferredSize.height + oneFilterHeight : popupPreferredSize.height;
        } else if (filtersNumber < 5) {
            n = popupPreferredSize.height;
        } else {
            int numberOfExtraFilters = filtersNumber - 5;
            n = popupPreferredSize.height - oneFilterHeight * numberOfExtraFilters;
        }
        int newPopupHeight = n;
        return new Dimension(popupPreferredSize.width, newPopupHeight);
    }

    private final int computeLeftGapForFirstPanel(JPanel currentPanel) {
        return UiSizeUtilKt.getPreferredWidth((JComponent)this.createFirstPanel(1)) - UiSizeUtilKt.getPreferredWidth((JComponent)currentPanel);
    }

    private static final void addOnApplyAction$lambda$2(Function0 $action, ActionEvent it) {
        $action.invoke();
    }

    private static final void addOnDeleteAction$lambda$3(Function0 $action, ActionEvent it) {
        $action.invoke();
    }

    private static final void addOnCancelAction$lambda$4(Function0 $action, ActionEvent it) {
        $action.invoke();
    }

    private static final void addOnAddFilterAction$lambda$5(Function0 $action, HyperlinkEvent it) {
        $action.invoke();
    }

    private static final boolean createPopUp$lambda$9(DSFilterView this$0, Ref.ObjectRef $mainPopup, KeyEvent it) {
        boolean bl;
        KeyEvent keyEvent = it;
        boolean bl2 = keyEvent != null ? keyEvent.getKeyCode() == 10 : false;
        if (bl2) {
            JBPopup jBPopup;
            Function0<Unit> function0 = this$0.applyAction;
            if (function0 != null) {
                function0.invoke();
            }
            if ($mainPopup.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainPopup");
                jBPopup = null;
            } else {
                jBPopup = (JBPopup)$mainPopup.element;
            }
            jBPopup.closeOk((InputEvent)it);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean createPopUp$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit createPanelWithButtons$lambda$14$lambda$13(DSFilterView this$0, boolean $toDisplayDeleteButton, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.addFilterLink).align((Align)AlignX.LEFT.INSTANCE);
        $this$row.label("").resizableColumn();
        if ($toDisplayDeleteButton) {
            $this$row.cell((JComponent)this$0.deleteButton).align((Align)AlignX.RIGHT.INSTANCE).gap(RightGap.SMALL);
        }
        $this$row.cell((JComponent)this$0.cancelButton).align((Align)AlignX.RIGHT.INSTANCE).gap(RightGap.SMALL);
        $this$row.cell((JComponent)this$0.applyButton).align((Align)AlignX.RIGHT.INSTANCE).gap(RightGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final Unit createPanelWithButtons$lambda$14(DSFilterView this$0, boolean $toDisplayDeleteButton, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DSFilterView.createPanelWithButtons$lambda$14$lambda$13(this$0, $toDisplayDeleteButton, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createFirstPanelWhereLabel$lambda$18$lambda$17(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(DSTableBundle.message("ds.TableFiltering.FilterView.panel.where", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit createFirstPanelWhereLabel$lambda$18(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, DSFilterView::createFirstPanelWhereLabel$lambda$18$lambda$17, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final String createFirstPanelOperatorCombobox$lambda$21$lambda$20$lambda$19(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit createFirstPanelOperatorCombobox$lambda$21$lambda$20(GraphProperty $operator, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ComboBoxKt.bindItem((Cell)$this$row.comboBox((Collection)FilterOperator.getEntries(), (ListCellRenderer)SimpleListCellRenderer.create((String)"", arg_0 -> DSFilterView.createFirstPanelOperatorCombobox$lambda$21$lambda$20$lambda$19((Function1)createFirstPanelOperatorCombobox.1.1.1.INSTANCE, arg_0))), (ObservableMutableProperty)((ObservableMutableProperty)$operator));
        return Unit.INSTANCE;
    }

    private static final Unit createFirstPanelOperatorCombobox$lambda$21(GraphProperty $operator, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DSFilterView.createFirstPanelOperatorCombobox$lambda$21$lambda$20($operator, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final String createFirstPanelOperatorLabel$lambda$24$lambda$23$lambda$22(GraphProperty $currentOperator, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((FilterOperator)((Object)$currentOperator.get())).getDisplayName();
    }

    private static final Unit createFirstPanelOperatorLabel$lambda$24$lambda$23(GraphProperty $currentOperator, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ObservableProperty[] observablePropertyArray = new ObservableProperty[]{$currentOperator};
        LabelKt.bindText((Cell)$this$row.label(((FilterOperator)((Object)$currentOperator.get())).getDisplayName()), (ObservableProperty)PropertyOperationUtil.operation((ObservableProperty[])observablePropertyArray, arg_0 -> DSFilterView.createFirstPanelOperatorLabel$lambda$24$lambda$23$lambda$22($currentOperator, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit createFirstPanelOperatorLabel$lambda$24(GraphProperty $currentOperator, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DSFilterView.createFirstPanelOperatorLabel$lambda$24$lambda$23($currentOperator, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/scientific/tables/panel/filtering/DSFilterView$DuplicateRemoveActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "index", "", "<init>", "(Lcom/intellij/scientific/tables/panel/filtering/DSFilterView;I)V", "getIndex", "()I", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "RemoveFilterAction", "DuplicateFilterAction", "intellij.scientific.tables"})
    public final class DuplicateRemoveActionGroup
    extends ActionGroup {
        private final int index;

        public DuplicateRemoveActionGroup(int index) {
            super(DSTableBundle.message("ds.TableFiltering.FilterView.panel.group.text", new Object[0]), DSTableBundle.message("ds.TableFiltering.FilterView.panel.group.description", new Object[0]), AllIcons.Actions.More);
            this.index = index;
            this.setPopup(true);
            this.getTemplatePresentation().putClientProperty(ActionUtil.HIDE_DROPDOWN_ICON, (Object)true);
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (e == null) {
                return new AnAction[0];
            }
            AnAction[] anActionArray = new AnAction[]{new RemoveFilterAction(), new DuplicateFilterAction()};
            return anActionArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/scientific/tables/panel/filtering/DSFilterView$DuplicateRemoveActionGroup$DuplicateFilterAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/scientific/tables/panel/filtering/DSFilterView$DuplicateRemoveActionGroup;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.scientific.tables"})
        @SourceDebugExtension(value={"SMAP\nDSFilterView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DSFilterView.kt\ncom/intellij/scientific/tables/panel/filtering/DSFilterView$DuplicateRemoveActionGroup$DuplicateFilterAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,353:1\n1#2:354\n*E\n"})
        public final class DuplicateFilterAction
        extends DumbAwareAction {
            public DuplicateFilterAction() {
                super(DSTableBundle.message("ds.TableFiltering.FilterView.panel.duplicateFilter", new Object[0]));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DSSingleFilterExpression originalFilter = (DSSingleFilterExpression)DSFilterView.this.currentFiltersFlatExpression.get(DuplicateRemoveActionGroup.this.getIndex());
                DSSingleFilterExpression dSSingleFilterExpression = DSFilterView.this.createSingleFilterExpression(DSFilterView.this.currentFiltersFlatExpression.size(), originalFilter.getFilterSingleExpression());
                if (dSSingleFilterExpression == null) {
                    return;
                }
                DSSingleFilterExpression duplicatedFilter = dSSingleFilterExpression;
                DialogPanel duplicatedFilterPanel = duplicatedFilter.createPanel();
                DSFilterView.this.panelWithFilters.add((Component)duplicatedFilterPanel);
                JBPopup currentPopup = DSFilterView.this.popUp;
                if (currentPopup != null && !currentPopup.isDisposed()) {
                    Dimension newPopupSize;
                    Dimension dimension = newPopupSize = DSFilterView.this.computePopupSize(currentPopup);
                    if (dimension != null) {
                        Dimension size = dimension;
                        boolean bl = false;
                        currentPopup.setSize(size);
                    }
                }
                DSFilterView.this.panelWithFilters.validate();
                DSFilterView.this.currentFiltersFlatExpression.add(duplicatedFilter);
                DSFilterView.this.panelWithFilters.scrollRectToVisible(duplicatedFilterPanel.getBounds());
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/scientific/tables/panel/filtering/DSFilterView$DuplicateRemoveActionGroup$RemoveFilterAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/scientific/tables/panel/filtering/DSFilterView$DuplicateRemoveActionGroup;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.scientific.tables"})
        @SourceDebugExtension(value={"SMAP\nDSFilterView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DSFilterView.kt\ncom/intellij/scientific/tables/panel/filtering/DSFilterView$DuplicateRemoveActionGroup$RemoveFilterAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,353:1\n1563#2:354\n1634#2,3:355\n*S KotlinDebug\n*F\n+ 1 DSFilterView.kt\ncom/intellij/scientific/tables/panel/filtering/DSFilterView$DuplicateRemoveActionGroup$RemoveFilterAction\n*L\n329#1:354\n329#1:355,3\n*E\n"})
        public final class RemoveFilterAction
        extends DumbAwareAction {
            public RemoveFilterAction() {
                super(DSTableBundle.message("ds.TableFiltering.FilterView.panel.removeFilter", new Object[0]));
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DSFilterView.this.currentFiltersFlatExpression.remove(DuplicateRemoveActionGroup.this.getIndex());
                if (DuplicateRemoveActionGroup.this.getIndex() > 1) {
                    DSFilterView.this.panelWithFilters.remove(DuplicateRemoveActionGroup.this.getIndex());
                } else {
                    Collection<FilterExpression.SingleExpression> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = DSFilterView.this.currentFiltersFlatExpression;
                    FilterExpression.Companion companion = FilterExpression.Companion;
                    DSFilterView dSFilterView = DSFilterView.this;
                    boolean $i$f$map = false;
                    void var4_6 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        DSSingleFilterExpression dSSingleFilterExpression = (DSSingleFilterExpression)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getFilterSingleExpression());
                    }
                    collection = (List)destination$iv$iv;
                    dSFilterView.updatePanelWithFilters(companion.fromFlatExpression((List<FilterExpression.SingleExpression>)collection, (FilterOperator)((Object)DSFilterView.this.currentOperatorPropertyGraph.get())));
                    DSFilterView.this.panelWithFilters.revalidate();
                }
            }
        }
    }
}

