/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.resources;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.kotlin.jupyter.core.resources.ArtifactDescriptionWithKind;
import com.intellij.kotlin.jupyter.core.resources.KotlinNotebookMavenArtifacts;
import com.intellij.kotlin.jupyter.core.resources.KotlinNotebookMavenArtifactsDownloader;
import com.intellij.kotlin.jupyter.core.resources.RepositoriesKt;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookProjectOptionsProvider;
import com.intellij.kotlin.jupyter.core.settings.OptionsUtilKt;
import com.intellij.kotlin.jupyter.core.util.CachesKt;
import com.intellij.kotlin.jupyter.core.util.KotlinNotebookPluginScope;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 82\u00020\u0001:\u0003678B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0086@\u00a2\u0006\u0002\u0010\u001eJ \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007J$\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0082@\u00a2\u0006\u0002\u0010\u001eJ\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0010H\u0002J\u0012\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\u001aH\u0002J$\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010*\u001a\u00020\r2\u0006\u0010.\u001a\u00020/H\u0002J$\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0006\u00101\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/H\u0002J\u001a\u00102\u001a\u0010\u0012\f\u0012\n 3*\u0004\u0018\u00010\u00100\u00100\u000f*\u00020\u0010H\u0002J\u001a\u00104\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\r2\b\b\u0002\u00105\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00069"}, d2={"Lcom/intellij/kotlin/jupyter/core/resources/KotlinNotebookMavenArtifactsDownloader;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "onlyJars", "", "Lorg/jetbrains/idea/maven/aether/ArtifactKind;", "onlySources", "onlyZip", "downloadJobs", "", "Lcom/intellij/kotlin/jupyter/core/resources/KotlinNotebookMavenArtifactsDownloader$ArtifactDescriptionWithVersion;", "Lkotlinx/coroutines/Deferred;", "", "Ljava/io/File;", "cacheSearchLock", "Ljava/util/concurrent/locks/ReentrantLock;", "projectScope", "Lcom/intellij/kotlin/jupyter/core/util/KotlinNotebookPluginScope;", "downloadJobsScope", "Lkotlinx/coroutines/CoroutineScope;", "preloadJobScope", "downloadArtifactBlocking", "artifact", "Lcom/intellij/kotlin/jupyter/core/resources/ArtifactDescriptionWithKind;", "version", "", "downloadArtifactAsync", "(Lcom/intellij/kotlin/jupyter/core/resources/ArtifactDescriptionWithKind;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadAndUnzipBlocking", "kernelsDirectoryPath", "Ljava/nio/file/Path;", "getKernelsDirectoryPath", "()Ljava/nio/file/Path;", "downloadAndUnzipAsync", "dispose", "", "preloadArtifacts", "downloadAndSaveToDirectory", "", "artifactWithVersion", "directory", "selectKinds", "downloadWithCache", "downloader", "Lcom/intellij/kotlin/jupyter/core/resources/KotlinNotebookMavenArtifactsDownloader$Downloader;", "startDownload", "cacheDirectory", "files", "kotlin.jvm.PlatformType", "locateDirectoryForArtifactInCache", "directorySuffix", "Downloader", "ArtifactDescriptionWithVersion", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookMavenArtifactsDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookMavenArtifactsDownloader.kt\ncom/intellij/kotlin/jupyter/core/resources/KotlinNotebookMavenArtifactsDownloader\n+ 2 coroutines.kt\ncom/intellij/kotlin/jupyter/core/util/KotlinNotebookPluginScope\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,238:1\n73#2,5:239\n48#2,11:244\n73#2,5:255\n48#2,11:260\n1617#3,9:271\n1869#3:280\n1870#3:282\n1626#3:283\n1#4:281\n1#4:291\n382#5,7:284\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookMavenArtifactsDownloader.kt\ncom/intellij/kotlin/jupyter/core/resources/KotlinNotebookMavenArtifactsDownloader\n*L\n61#1:239,5\n61#1:244,11\n90#1:255,5\n90#1:260,11\n156#1:271,9\n156#1:280\n156#1:282\n156#1:283\n156#1:281\n181#1:284,7\n*E\n"})
public final class KotlinNotebookMavenArtifactsDownloader
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Set<ArtifactKind> onlyJars;
    @NotNull
    private final Set<ArtifactKind> onlySources;
    @NotNull
    private final Set<ArtifactKind> onlyZip;
    @NotNull
    private final Map<ArtifactDescriptionWithVersion, Deferred<List<File>>> downloadJobs;
    @NotNull
    private final ReentrantLock cacheSearchLock;
    @NotNull
    private final KotlinNotebookPluginScope projectScope;
    @NotNull
    private final CoroutineScope downloadJobsScope;
    @NotNull
    private final CoroutineScope preloadJobScope;

    public KotlinNotebookMavenArtifactsDownloader(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.onlyJars = SetsKt.setOf((Object)ArtifactKind.ARTIFACT);
        this.onlySources = SetsKt.setOf((Object)ArtifactKind.SOURCES);
        this.onlyZip = SetsKt.setOf((Object)ArtifactKind.ZIP);
        this.downloadJobs = new LinkedHashMap();
        this.cacheSearchLock = new ReentrantLock();
        this.projectScope = KotlinNotebookPluginScope.Companion.getForProject(this.project);
        this.downloadJobsScope = CoroutineScopeKt.childScope$default((CoroutineScope)this.projectScope, (String)"Kotlin Notebook artifacts download", (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (boolean)false, (int)4, null);
        this.preloadJobScope = CoroutineScopeKt.childScope$default((CoroutineScope)this.projectScope, (String)"Kotlin Notebook artifacts preload", (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (boolean)false, (int)4, null);
        this.preloadArtifacts();
        KotlinNotebookProjectOptionsProvider.Companion.getInstance(this.project).addListener((EventListener)new KotlinNotebookProjectOptionsProvider.Listener(){

            @Override
            public void onKernelVersionChanged() {
                this.preloadArtifacts();
            }
        }, this);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @NotNull
    public final List<File> downloadArtifactBlocking(@NotNull ArtifactDescriptionWithKind artifact, @NotNull String version) {
        void this_$iv$iv;
        Deferred deferred2;
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        KotlinNotebookPluginScope $this$iv = this.projectScope;
        Duration timeout$iv = null;
        boolean bl = false;
        KotlinNotebookPluginScope kotlinNotebookPluginScope = $this$iv;
        Duration timeout$iv$iv = timeout$iv;
        boolean bl2 = false;
        Deferred $this$invokeAndWait_k1IrOU0_u24lambda_u240$iv$iv = deferred2 = BuildersKt.async$default((CoroutineScope)((CoroutineScope)this_$iv$iv), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends File>>, Object>(null, this, artifact, version){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ KotlinNotebookMavenArtifactsDownloader this$0;
            final /* synthetic */ ArtifactDescriptionWithKind $artifact$inlined;
            final /* synthetic */ String $version$inlined;
            Object L$1;
            Object L$2;
            int I$0;
            {
                this.this$0 = kotlinNotebookMavenArtifactsDownloader;
                this.$artifact$inlined = artifactDescriptionWithKind;
                this.$version$inlined = string;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $completion;
                        void $this$async;
                        ResultKt.throwOnFailure((Object)$result);
                        Continuation continuation = (Continuation)this;
                        void $this$downloadArtifactBlocking_u24lambda_u240 = $this$async;
                        int n = 0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$async);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$downloadArtifactBlocking_u24lambda_u240);
                        this.I$0 = n;
                        this.label = 1;
                        Object object2 = this.this$0.downloadArtifactAsync(this.$artifact$inlined, this.$version$inlined, (Continuation<? super List<? extends File>>)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        int n = this.I$0;
                        CoroutineScope $this$downloadArtifactBlocking_u24lambda_u240 = (CoroutineScope)this.L$2;
                        Continuation $completion = (Continuation)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends File>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        boolean bl3 = false;
        $this$invokeAndWait_k1IrOU0_u24lambda_u240$iv$iv.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(){

            public final void invoke(Throwable throwable) {
                if (throwable != null) {
                    Throwable error = throwable;
                    boolean bl = false;
                    throw error;
                }
            }
        });
        Deferred deferred$iv$iv = deferred2;
        List list = (List)CoroutinesKt.runBlockingMaybeCancellable((Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(timeout$iv$iv, deferred$iv$iv, null){
            int label;
            final /* synthetic */ Duration $timeout;
            final /* synthetic */ Deferred<T> $deferred;
            {
                this.$timeout = $timeout;
                this.$deferred = $deferred;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (this.$timeout != null) break;
                        this.label = 1;
                        object = this.$deferred.await((Continuation)this);
                        if (object != object2) return object;
                        return object2;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        object = $result;
                        return object;
                    }
                }
                this.label = 2;
                object = TimeoutKt.withTimeout-KLykuaI((long)this.$timeout.unbox-impl(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(this.$deferred, null){
                    int label;
                    final /* synthetic */ Deferred<T> $deferred;
                    {
                        this.$deferred = $deferred;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.$deferred.await((Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)((Continuation)this));
                if (object != object2) return object;
                return object2;
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        object = $result;
                        return object;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final Object downloadArtifactAsync(@NotNull ArtifactDescriptionWithKind artifact, @NotNull String version, @NotNull Continuation<? super List<? extends File>> $completion) {
        ArtifactDescriptionWithVersion artifactWithVersion = new ArtifactDescriptionWithVersion(artifact, version);
        Object[] objectArray = new Object[]{artifactWithVersion.getMavenCoordinates()};
        return TasksKt.withBackgroundProgress((Project)this.project, (String)KotlinNotebookBundle.message("kotlin.notebook.progress.title.kotlin.kernel.downloading", objectArray), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends File>>, Object>(this, artifactWithVersion, null){
            int label;
            final /* synthetic */ KotlinNotebookMavenArtifactsDownloader this$0;
            final /* synthetic */ ArtifactDescriptionWithVersion $artifactWithVersion;
            {
                this.this$0 = $receiver;
                this.$artifactWithVersion = $artifactWithVersion;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = KotlinNotebookMavenArtifactsDownloader.access$downloadWithCache(this.this$0, this.$artifactWithVersion, new Downloader(this.this$0, this.$artifactWithVersion){
                            final /* synthetic */ KotlinNotebookMavenArtifactsDownloader this$0;
                            final /* synthetic */ ArtifactDescriptionWithVersion $artifactWithVersion;
                            {
                                this.this$0 = $receiver;
                                this.$artifactWithVersion = $artifactWithVersion;
                            }

                            public final Object download(File cacheDirectory, Continuation<? super Boolean> $completion) {
                                return Boxing.boxBoolean((boolean)KotlinNotebookMavenArtifactsDownloader.access$downloadAndSaveToDirectory(this.this$0, this.$artifactWithVersion, cacheDirectory));
                            }
                        }).await((Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends File>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @NotNull
    public final List<File> downloadAndUnzipBlocking(@NotNull ArtifactDescriptionWithKind artifact, @NotNull String version) {
        void this_$iv$iv;
        Deferred deferred2;
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        KotlinNotebookPluginScope $this$iv = this.projectScope;
        Duration timeout$iv = null;
        boolean bl = false;
        KotlinNotebookPluginScope kotlinNotebookPluginScope = $this$iv;
        Duration timeout$iv$iv = timeout$iv;
        boolean bl2 = false;
        Deferred $this$invokeAndWait_k1IrOU0_u24lambda_u240$iv$iv = deferred2 = BuildersKt.async$default((CoroutineScope)((CoroutineScope)this_$iv$iv), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends File>>, Object>(null, this, artifact, version){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ KotlinNotebookMavenArtifactsDownloader this$0;
            final /* synthetic */ ArtifactDescriptionWithKind $artifact$inlined;
            final /* synthetic */ String $version$inlined;
            Object L$1;
            Object L$2;
            int I$0;
            {
                this.this$0 = kotlinNotebookMavenArtifactsDownloader;
                this.$artifact$inlined = artifactDescriptionWithKind;
                this.$version$inlined = string;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $completion;
                        void $this$async;
                        ResultKt.throwOnFailure((Object)$result);
                        Continuation continuation = (Continuation)this;
                        void $this$downloadAndUnzipBlocking_u24lambda_u241 = $this$async;
                        int n = 0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$async);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$downloadAndUnzipBlocking_u24lambda_u241);
                        this.I$0 = n;
                        this.label = 1;
                        Object object2 = KotlinNotebookMavenArtifactsDownloader.access$downloadAndUnzipAsync(this.this$0, this.$artifact$inlined, this.$version$inlined, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        int n = this.I$0;
                        CoroutineScope $this$downloadAndUnzipBlocking_u24lambda_u241 = (CoroutineScope)this.L$2;
                        Continuation $completion = (Continuation)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends File>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        boolean bl3 = false;
        $this$invokeAndWait_k1IrOU0_u24lambda_u240$iv$iv.invokeOnCompletion((Function1)new /* invalid duplicate definition of identical inner class */);
        Deferred deferred$iv$iv = deferred2;
        List list = (List)CoroutinesKt.runBlockingMaybeCancellable((Function2)new /* invalid duplicate definition of identical inner class */);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public static /* synthetic */ List downloadAndUnzipBlocking$default(KotlinNotebookMavenArtifactsDownloader kotlinNotebookMavenArtifactsDownloader, ArtifactDescriptionWithKind artifactDescriptionWithKind, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = OptionsUtilKt.getSelectedKernelVersionAsString(kotlinNotebookMavenArtifactsDownloader.project);
        }
        return kotlinNotebookMavenArtifactsDownloader.downloadAndUnzipBlocking(artifactDescriptionWithKind, string);
    }

    @NotNull
    public final Path getKernelsDirectoryPath() {
        Path path = CachesKt.getKotlinNotebookCacheDirectory(this.project).resolve("kernels");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    /*
     * Unable to fully structure code
     */
    private final Object downloadAndUnzipAsync(ArtifactDescriptionWithKind artifact, String version, Continuation<? super List<? extends File>> $completion) {
        if (!($completion instanceof downloadAndUnzipAsync.1)) ** GOTO lbl-1000
        var11_4 = $completion;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ KotlinNotebookMavenArtifactsDownloader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return KotlinNotebookMavenArtifactsDownloader.access$downloadAndUnzipAsync(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_7 = Intrinsics.areEqual((Object)artifact.getKind().getExtension(), (Object)"zip");
                if (_Assertions.ENABLED && !var4_7) {
                    var5_9 = "Assertion failed";
                    throw new AssertionError((Object)var5_9);
                }
                $continuation.L$0 = artifact;
                $continuation.L$1 = version;
                $continuation.label = 1;
                v0 = this.downloadArtifactAsync(artifact, version, (Continuation<? super List<? extends File>>)$continuation);
                if (v0 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                version = (String)$continuation.L$1;
                artifact = (ArtifactDescriptionWithKind)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                zipFiles = (List)v0;
                outputDirectory = this.locateDirectoryForArtifactInCache(new ArtifactDescriptionWithVersion(artifact, version), "_extracted");
                artifacts = this.files(outputDirectory);
                if (((Collection)artifacts).isEmpty() == false) {
                    return artifacts;
                }
                outputDirPath = outputDirectory.toPath();
                for (File zipFile : zipFiles) {
                    ZipUtil.extract((Path)zipFile.toPath(), (Path)outputDirPath, null, (boolean)true);
                }
                return this.files(outputDirectory);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public void dispose() {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.downloadJobsScope, null, (int)1, null);
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.preloadJobScope, null, (int)1, null);
        this.downloadJobs.clear();
    }

    private final void preloadArtifacts() {
        BuildersKt.launch$default((CoroutineScope)this.preloadJobScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ KotlinNotebookMavenArtifactsDownloader this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        version = OptionsUtilKt.getSelectedKernelVersionAsString(KotlinNotebookMavenArtifactsDownloader.access$getProject$p(this.this$0));
                        var3_4 = KotlinNotebookMavenArtifacts.INSTANCE.all().iterator();
lbl7:
                        // 3 sources

                        while (var3_4.hasNext()) {
                            artifact = var3_4.next();
                            this.L$0 = version;
                            this.L$1 = var3_4;
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)artifact);
                            this.label = 1;
                            v0 = this.this$0.downloadArtifactAsync(artifact, version, (Continuation<? super List<? extends File>>)((Continuation)this));
                            if (v0 != var5_2) continue;
                            return var5_2;
                        }
                        break;
                    }
                    case 1: {
                        artifact = (ArtifactDescriptionWithKind)this.L$2;
                        var3_4 = (Iterator<ArtifactDescriptionWithKind>)this.L$1;
                        version = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean downloadAndSaveToDirectory(ArtifactDescriptionWithVersion artifactWithVersion, File directory) {
        void $this$mapNotNullTo$iv$iv;
        ArtifactDescriptionWithKind artifact = artifactWithVersion.component1();
        String version = artifactWithVersion.component2();
        List list = JarRepositoryManager.loadDependenciesSync((Project)this.project, (JpsMavenRepositoryLibraryDescriptor)new JpsMavenRepositoryLibraryDescriptor(artifact.getGroup(), artifact.getArtifact(), version, false, CollectionsKt.emptyList()), this.selectKinds(artifact), RepositoriesKt.getDefaultRemoteArtifactsRepositories(), (String)directory.getAbsolutePath());
        if (list == null) {
            return false;
        }
        List resolvedLibraryRoots = list;
        Iterable $this$mapNotNull$iv = resolvedLibraryRoots;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            File it$iv$iv;
            VirtualFile virtualFile;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            OrderRoot root = (OrderRoot)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)root.getFile(), (String)"getFile(...)");
            if (VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return true;
    }

    private final Set<ArtifactKind> selectKinds(ArtifactDescriptionWithKind $this$selectKinds) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$selectKinds.getKind().ordinal()]) {
            case 1 -> this.onlyJars;
            case 2 -> this.onlySources;
            case 3 -> this.onlyZip;
            default -> SetsKt.setOf((Object)$this$selectKinds.getKind());
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Deferred<List<File>> downloadWithCache(ArtifactDescriptionWithVersion artifactWithVersion, Downloader downloader) {
        Deferred deferred2;
        Lock lock = this.cacheSearchLock;
        lock.lock();
        try {
            Object object;
            void $this$getOrPut$iv;
            boolean bl = false;
            Map<ArtifactDescriptionWithVersion, Deferred<List<File>>> map = this.downloadJobs;
            ArtifactDescriptionWithVersion key$iv = artifactWithVersion;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                File cacheDirectory = KotlinNotebookMavenArtifactsDownloader.locateDirectoryForArtifactInCache$default(this, artifactWithVersion, null, 2, null);
                List<File> artifacts = this.files(cacheDirectory);
                Deferred<List<File>> answer$iv = !((Collection)artifacts).isEmpty() ? (Deferred<List<File>>)CompletableDeferredKt.CompletableDeferred(artifacts) : this.startDownload(cacheDirectory, downloader);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            deferred2 = (Deferred)object;
        }
        finally {
            lock.unlock();
        }
        return deferred2;
    }

    private final Deferred<List<File>> startDownload(File cacheDirectory, Downloader downloader) {
        return BuildersKt.async$default((CoroutineScope)this.downloadJobsScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends File>>, Object>(downloader, cacheDirectory, this, null){
            int label;
            final /* synthetic */ Downloader $downloader;
            final /* synthetic */ File $cacheDirectory;
            final /* synthetic */ KotlinNotebookMavenArtifactsDownloader this$0;
            {
                this.$downloader = $downloader;
                this.$cacheDirectory = $cacheDirectory;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$downloader.download(this.$cacheDirectory, (Continuation<? super Boolean>)((Continuation)this));
                        if (object2 != object) return (Boolean)object2 != false ? KotlinNotebookMavenArtifactsDownloader.access$files(this.this$0, this.$cacheDirectory) : CollectionsKt.emptyList();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return (Boolean)object2 != false ? KotlinNotebookMavenArtifactsDownloader.access$files(this.this$0, this.$cacheDirectory) : CollectionsKt.emptyList();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends File>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final List<File> files(File $this$files) {
        Object[] objectArray = $this$files.listFiles();
        List list = objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final File locateDirectoryForArtifactInCache(ArtifactDescriptionWithVersion artifactWithVersion, String directorySuffix) {
        String string;
        StringBuilder stringBuilder;
        ArtifactDescriptionWithKind artifact = artifactWithVersion.component1();
        String version = artifactWithVersion.component2();
        Path versionDirectory = this.getKernelsDirectoryPath().resolve(version);
        StringBuilder $this$locateDirectoryForArtifactInCache_u24lambda_u249 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$locateDirectoryForArtifactInCache_u24lambda_u249.append(artifact.getArtifact());
        String it = string = artifact.getKind().getClassifier();
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)it);
        String string2 = ((CharSequence)it).length() > 0 ? string : null;
        if (string2 != null) {
            String classifier = string2;
            boolean bl3 = false;
            $this$locateDirectoryForArtifactInCache_u24lambda_u249.append('-');
            $this$locateDirectoryForArtifactInCache_u24lambda_u249.append(classifier);
        }
        it = string = artifact.getKind().getExtension();
        boolean bl4 = false;
        Intrinsics.checkNotNull((Object)it);
        String string3 = ((CharSequence)it).length() > 0 ? string : null;
        if (string3 != null) {
            String extension = string3;
            boolean bl5 = false;
            $this$locateDirectoryForArtifactInCache_u24lambda_u249.append('-');
            $this$locateDirectoryForArtifactInCache_u24lambda_u249.append(extension);
        }
        String artifactDirectoryName = stringBuilder.toString();
        Path artifactDirectory = versionDirectory.resolve(artifactDirectoryName + directorySuffix);
        artifactDirectory.toFile().mkdirs();
        File file = artifactDirectory.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    static /* synthetic */ File locateDirectoryForArtifactInCache$default(KotlinNotebookMavenArtifactsDownloader kotlinNotebookMavenArtifactsDownloader, ArtifactDescriptionWithVersion artifactDescriptionWithVersion, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return kotlinNotebookMavenArtifactsDownloader.locateDirectoryForArtifactInCache(artifactDescriptionWithVersion, string);
    }

    public static final /* synthetic */ Deferred access$downloadWithCache(KotlinNotebookMavenArtifactsDownloader $this, ArtifactDescriptionWithVersion artifactWithVersion, Downloader downloader) {
        return $this.downloadWithCache(artifactWithVersion, downloader);
    }

    public static final /* synthetic */ boolean access$downloadAndSaveToDirectory(KotlinNotebookMavenArtifactsDownloader $this, ArtifactDescriptionWithVersion artifactWithVersion, File directory) {
        return $this.downloadAndSaveToDirectory(artifactWithVersion, directory);
    }

    public static final /* synthetic */ Object access$downloadAndUnzipAsync(KotlinNotebookMavenArtifactsDownloader $this, ArtifactDescriptionWithKind artifact, String version, Continuation $completion) {
        return $this.downloadAndUnzipAsync(artifact, version, (Continuation<? super List<? extends File>>)$completion);
    }

    public static final /* synthetic */ Project access$getProject$p(KotlinNotebookMavenArtifactsDownloader $this) {
        return $this.project;
    }

    public static final /* synthetic */ List access$files(KotlinNotebookMavenArtifactsDownloader $this, File $receiver) {
        return $this.files($receiver);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/kotlin/jupyter/core/resources/KotlinNotebookMavenArtifactsDownloader$ArtifactDescriptionWithVersion;", "", "artifact", "Lcom/intellij/kotlin/jupyter/core/resources/ArtifactDescriptionWithKind;", "version", "", "<init>", "(Lcom/intellij/kotlin/jupyter/core/resources/ArtifactDescriptionWithKind;Ljava/lang/String;)V", "getArtifact", "()Lcom/intellij/kotlin/jupyter/core/resources/ArtifactDescriptionWithKind;", "getVersion", "()Ljava/lang/String;", "mavenCoordinates", "getMavenCoordinates", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.kotlin.jupyter.core"})
    private static final class ArtifactDescriptionWithVersion {
        @NotNull
        private final ArtifactDescriptionWithKind artifact;
        @NotNull
        private final String version;

        public ArtifactDescriptionWithVersion(@NotNull ArtifactDescriptionWithKind artifact, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            this.artifact = artifact;
            this.version = version;
        }

        @NotNull
        public final ArtifactDescriptionWithKind getArtifact() {
            return this.artifact;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final String getMavenCoordinates() {
            return this.artifact.getMavenCoordinates() + ":" + this.version;
        }

        @NotNull
        public final ArtifactDescriptionWithKind component1() {
            return this.artifact;
        }

        @NotNull
        public final String component2() {
            return this.version;
        }

        @NotNull
        public final ArtifactDescriptionWithVersion copy(@NotNull ArtifactDescriptionWithKind artifact, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new ArtifactDescriptionWithVersion(artifact, version);
        }

        public static /* synthetic */ ArtifactDescriptionWithVersion copy$default(ArtifactDescriptionWithVersion artifactDescriptionWithVersion, ArtifactDescriptionWithKind artifactDescriptionWithKind, String string, int n, Object object) {
            if ((n & 1) != 0) {
                artifactDescriptionWithKind = artifactDescriptionWithVersion.artifact;
            }
            if ((n & 2) != 0) {
                string = artifactDescriptionWithVersion.version;
            }
            return artifactDescriptionWithVersion.copy(artifactDescriptionWithKind, string);
        }

        @NotNull
        public String toString() {
            return "ArtifactDescriptionWithVersion(artifact=" + this.artifact + ", version=" + this.version + ")";
        }

        public int hashCode() {
            int result2 = this.artifact.hashCode();
            result2 = result2 * 31 + this.version.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArtifactDescriptionWithVersion)) {
                return false;
            }
            ArtifactDescriptionWithVersion artifactDescriptionWithVersion = (ArtifactDescriptionWithVersion)other;
            if (!Intrinsics.areEqual((Object)this.artifact, (Object)artifactDescriptionWithVersion.artifact)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.version, (Object)artifactDescriptionWithVersion.version);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/kotlin/jupyter/core/resources/KotlinNotebookMavenArtifactsDownloader$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/kotlin/jupyter/core/resources/KotlinNotebookMavenArtifactsDownloader;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.kotlin.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nKotlinNotebookMavenArtifactsDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookMavenArtifactsDownloader.kt\ncom/intellij/kotlin/jupyter/core/resources/KotlinNotebookMavenArtifactsDownloader$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,238:1\n30#2,2:239\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookMavenArtifactsDownloader.kt\ncom/intellij/kotlin/jupyter/core/resources/KotlinNotebookMavenArtifactsDownloader$Companion\n*L\n235#1:239,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinNotebookMavenArtifactsDownloader getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinNotebookMavenArtifactsDownloader> serviceClass$iv = KotlinNotebookMavenArtifactsDownloader.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KotlinNotebookMavenArtifactsDownloader)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e2\u0080\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u00a6@\u00a2\u0006\u0002\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/kotlin/jupyter/core/resources/KotlinNotebookMavenArtifactsDownloader$Downloader;", "", "download", "", "cacheLocation", "Ljava/io/File;", "(Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.kotlin.jupyter.core"})
    private static interface Downloader {
        @Nullable
        public Object download(@NotNull File var1, @NotNull Continuation<? super Boolean> var2);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ArtifactKind.values().length];
            try {
                nArray[ArtifactKind.ARTIFACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArtifactKind.SOURCES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArtifactKind.ZIP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

