/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0;

import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.DataType;
import org.openjdk.jmc.flightrecorder.internal.util.DataInputToolkit;
import org.openjdk.jmc.flightrecorder.parser.ByteBufferWrapper;

class NumberReaders {
    NumberReaders() {
    }

    static long readLong(ByteBufferWrapper bytes, Offset offset) throws InvalidJfrFileException {
        return DataInputToolkit.readLong(bytes, offset.getAndIncrease(8));
    }

    static int readInt(ByteBufferWrapper bytes, Offset offset) throws InvalidJfrFileException {
        return DataInputToolkit.readInt(bytes, offset.getAndIncrease(4));
    }

    static byte readByte(ByteBufferWrapper bytes, Offset offset) throws InvalidJfrFileException {
        return DataInputToolkit.readByte(bytes, offset.getAndIncrease(1));
    }

    static short readShort(ByteBufferWrapper bytes, Offset offset) throws InvalidJfrFileException {
        return DataInputToolkit.readShort(bytes, offset.getAndIncrease(2));
    }

    static float readFloat(ByteBufferWrapper bytes, Offset offset) throws InvalidJfrFileException {
        return DataInputToolkit.readFloat(bytes, offset.getAndIncrease(4));
    }

    static double readDouble(ByteBufferWrapper bytes, Offset offset) throws InvalidJfrFileException {
        return DataInputToolkit.readDouble(bytes, offset.getAndIncrease(8));
    }

    static long readKey(ByteBufferWrapper data, Offset offset, DataType keyType) throws InvalidJfrFileException {
        switch (keyType) {
            case U1: 
            case BYTE: {
                return NumberReaders.readByte(data, offset);
            }
            case SHORT: 
            case U2: {
                return NumberReaders.readShort(data, offset);
            }
            case INTEGER: 
            case U4: 
            case FLOAT: {
                return NumberReaders.readInt(data, offset);
            }
            case LONG: 
            case U8: 
            case DOUBLE: {
                return NumberReaders.readLong(data, offset);
            }
        }
        throw new InvalidJfrFileException();
    }
}

