/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.blockingCallsDetection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.blockingCallsDetection.ContextType;
import com.intellij.codeInspection.blockingCallsDetection.ElementContext;
import com.intellij.codeInspection.blockingCallsDetection.NonBlockingContextChecker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public final class AnnotationBasedNonBlockingContextChecker
implements NonBlockingContextChecker {
    private final Collection<String> myBlockingAnnotations;
    private final Collection<String> myNonBlockingAnnotations;

    public AnnotationBasedNonBlockingContextChecker(@NotNull Collection<String> blockingAnnotations, @NotNull Collection<String> nonBlockingAnnotations) {
        if (blockingAnnotations == null) {
            AnnotationBasedNonBlockingContextChecker.$$$reportNull$$$0(0);
        }
        if (nonBlockingAnnotations == null) {
            AnnotationBasedNonBlockingContextChecker.$$$reportNull$$$0(1);
        }
        this.myBlockingAnnotations = blockingAnnotations;
        this.myNonBlockingAnnotations = nonBlockingAnnotations;
    }

    public boolean isApplicable(@NotNull PsiFile file) {
        if (file == null) {
            AnnotationBasedNonBlockingContextChecker.$$$reportNull$$$0(2);
        }
        JavaPsiFacade javaPsi = JavaPsiFacade.getInstance((Project)file.getProject());
        for (String annotation : this.myNonBlockingAnnotations) {
            if (javaPsi.findClass(annotation, file.getResolveScope()) == null) continue;
            return true;
        }
        return false;
    }

    public ContextType computeContextType(@NotNull ElementContext elementContext) {
        UMethod callingMethod;
        UMethod method;
        if (elementContext == null) {
            AnnotationBasedNonBlockingContextChecker.$$$reportNull$$$0(3);
        }
        if ((method = (UMethod)UastContextKt.toUElement((PsiElement)elementContext.getElement(), UMethod.class)) != null) {
            callingMethod = method;
        } else {
            UCallExpression callExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)elementContext.getElement(), UCallExpression.class);
            if (callExpression == null) {
                return ContextType.Unsure.INSTANCE;
            }
            callingMethod = (UMethod)UastUtils.getParentOfType((UElement)callExpression, UMethod.class);
        }
        if (callingMethod == null) {
            return ContextType.Unsure.INSTANCE;
        }
        PsiMethod psiCallingMethod = callingMethod.getJavaPsi();
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiCallingMethod, this.myNonBlockingAnnotations, (boolean)false) != null) {
            return ContextType.NonBlocking.INSTANCE;
        }
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiCallingMethod, this.myBlockingAnnotations, (boolean)false) != null) {
            return ContextType.Blocking.INSTANCE;
        }
        PsiClass containingClass = psiCallingMethod.getContainingClass();
        boolean isClassAnnotated = containingClass != null && AnnotationUtil.findAnnotation((PsiModifierListOwner)containingClass, this.myNonBlockingAnnotations, (boolean)false) != null;
        return isClassAnnotated ? ContextType.NonBlocking.INSTANCE : ContextType.Unsure.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockingAnnotations";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonBlockingAnnotations";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/blockingCallsDetection/AnnotationBasedNonBlockingContextChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "computeContextType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

