/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.model.catboost;

import ai.catboost.CatBoostModel;
import com.jetbrains.ml.tools.model.MLModel;
import com.jetbrains.ml.tools.model.catboost.CatBoostClassifier;
import com.jetbrains.ml.tools.model.catboost.CatBoostRanker;
import com.jetbrains.ml.tools.model.catboost.CatBoostRegressor;
import com.jetbrains.ml.tools.model.catboost.decisionFunction.CatBoostClassifierDecisionFunction;
import com.jetbrains.ml.tools.model.catboost.decisionFunction.CatBoostRegressorDecisionFunction;
import com.jetbrains.ml.tools.model.catboost.decisionFunction.MLApi2CatBoostConverter;
import com.jetbrains.ml.tools.model.pipeline.ModelPipelineComponent;
import com.jetbrains.ml.tools.model.pipeline.VFSNode;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J*\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/ml/tools/model/catboost/CatBoostModelComponent;", "Lcom/jetbrains/ml/tools/model/pipeline/ModelPipelineComponent;", "Lcom/jetbrains/ml/tools/model/MLModel;", "()V", "name", "", "getName", "()Ljava/lang/String;", "isVersionSupported", "", "version", "load", "Ljava/util/concurrent/CompletableFuture;", "executor", "Ljava/util/concurrent/ExecutorService;", "metadata", "Lkotlinx/serialization/json/JsonObject;", "componentDirectory", "Lcom/jetbrains/ml/tools/model/pipeline/VFSNode$Directory;", "ml-tools"})
public final class CatBoostModelComponent
extends ModelPipelineComponent<MLModel<?>> {
    @NotNull
    public static final CatBoostModelComponent INSTANCE = new CatBoostModelComponent();
    @NotNull
    private static final String name = "catboost";

    private CatBoostModelComponent() {
    }

    @Override
    public boolean isVersionSupported(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return Intrinsics.areEqual((Object)version, (Object)"0");
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    @NotNull
    protected CompletableFuture<MLModel<?>> load(@NotNull ExecutorService executor, @NotNull JsonObject metadata, @NotNull VFSNode.Directory componentDirectory) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)componentDirectory, (String)"componentDirectory");
        String modelType = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)metadata), (Object)"model_type"))).getContent();
        CompletableFuture<MLModel<?>> completableFuture = CompletableFuture.supplyAsync(() -> CatBoostModelComponent.load$lambda$0(componentDirectory, modelType), executor);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    private static final MLModel load$lambda$0(VFSNode.Directory $componentDirectory, String $modelType) {
        Intrinsics.checkNotNullParameter((Object)$componentDirectory, (String)"$componentDirectory");
        Intrinsics.checkNotNullParameter((Object)$modelType, (String)"$modelType");
        CatBoostModel model = CatBoostModel.loadModel($componentDirectory.getFile("model.cbm").getContent());
        Intrinsics.checkNotNull((Object)model);
        MLApi2CatBoostConverter converter = new MLApi2CatBoostConverter(model);
        return switch ($modelType) {
            case "regressor" -> new CatBoostRegressor(converter, new CatBoostRegressorDecisionFunction(model));
            case "classifier" -> new CatBoostClassifier(converter, new CatBoostClassifierDecisionFunction(model));
            case "ranker" -> new CatBoostRanker(converter, new CatBoostRegressorDecisionFunction(model));
            default -> throw new IllegalStateException(("This catboost model type is not supported: " + $modelType).toString());
        };
    }
}

