/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.guide;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.render.svg.MultilineLabel;
import org.jetbrains.letsPlot.core.plot.base.render.svg.StrokeDashArraySupport;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.AxisUtil;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0019\u001aBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0014J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "length", "", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "breaksData", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$BreaksData;", "labelAdjustments", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "axisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "hideAxis", "", "hideAxisBreaks", "(DLorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$BreaksData;Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;ZZ)V", "buildAxis", "", "buildComponent", "buildTick", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "label", "", "labelOffset", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "BreaksData", "TickLabelAdjustments", "plot-builder"})
public final class AxisComponent
extends SvgComponent {
    private final double length;
    @NotNull
    private final Orientation orientation;
    @NotNull
    private final BreaksData breaksData;
    @NotNull
    private final TickLabelAdjustments labelAdjustments;
    @NotNull
    private final AxisTheme axisTheme;
    private final boolean hideAxis;
    private final boolean hideAxisBreaks;

    public AxisComponent(double length, @NotNull Orientation orientation, @NotNull BreaksData breaksData, @NotNull TickLabelAdjustments labelAdjustments, @NotNull AxisTheme axisTheme, boolean hideAxis, boolean hideAxisBreaks) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)breaksData, (String)"breaksData");
        Intrinsics.checkNotNullParameter((Object)labelAdjustments, (String)"labelAdjustments");
        Intrinsics.checkNotNullParameter((Object)axisTheme, (String)"axisTheme");
        this.length = length;
        this.orientation = orientation;
        this.breaksData = breaksData;
        this.labelAdjustments = labelAdjustments;
        this.axisTheme = axisTheme;
        this.hideAxis = hideAxis;
        this.hideAxisBreaks = hideAxisBreaks;
    }

    public /* synthetic */ AxisComponent(double d, Orientation orientation, BreaksData breaksData, TickLabelAdjustments tickLabelAdjustments, AxisTheme axisTheme, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            tickLabelAdjustments = new TickLabelAdjustments(orientation, null, null, 0.0, null, null, 62, null);
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        this(d, orientation, breaksData, tickLabelAdjustments, axisTheme, bl, bl2);
    }

    @Override
    protected void buildComponent() {
        this.buildAxis();
    }

    private final void buildAxis() {
        double y2;
        SvgGElement rootElement = this.getRootGroup();
        double start2 = 0.0;
        double end = this.length;
        double x1 = this.orientation.isHorizontal() ? start2 : 0.0;
        double x2 = this.orientation.isHorizontal() ? end : 0.0;
        double y1 = !this.orientation.isHorizontal() ? start2 : 0.0;
        double d = y2 = !this.orientation.isHorizontal() ? end : 0.0;
        if (!this.hideAxis) {
            Object object;
            if (!this.hideAxisBreaks && (this.axisTheme.showLabels() || this.axisTheme.showTickMarks())) {
                DoubleVector tickLabelBaseOffset = AxisUtil.INSTANCE.tickLabelBaseOffset(this.axisTheme, this.orientation);
                object = this.breaksData.getMajorBreaks().iterator();
                int n = 0;
                while (object.hasNext()) {
                    double d2;
                    int i = n++;
                    DoubleVector br = (DoubleVector)object.next();
                    boolean bl = this.orientation.isHorizontal();
                    if (bl) {
                        d2 = br.getX();
                    } else if (!bl) {
                        d2 = br.getY();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    double loc = d2;
                    boolean bl2 = start2 <= loc ? loc <= end : false;
                    if (!bl2) continue;
                    String label = this.breaksData.getMajorLabels().get(i % this.breaksData.getMajorLabels().size());
                    DoubleVector labelOffset = tickLabelBaseOffset.add(this.labelAdjustments.additionalOffset(i));
                    SvgGElement group2 = this.buildTick(label, labelOffset, this.axisTheme);
                    boolean bl3 = this.orientation.isHorizontal();
                    if (!bl3) {
                        SvgUtils.INSTANCE.transformTranslate(group2, 0.0, loc);
                    } else if (bl3) {
                        SvgUtils.INSTANCE.transformTranslate(group2, loc, 0.0);
                    }
                    rootElement.children().add(group2);
                }
            }
            if (!this.hideAxisBreaks && this.axisTheme.showLine()) {
                Object $this$buildAxis_u24lambda_u240 = object = new SvgLineElement(x1, y1, x2, y2);
                boolean bl = false;
                ((SvgLineElement)$this$buildAxis_u24lambda_u240).strokeWidth().set(this.axisTheme.lineWidth());
                ((SvgLineElement)$this$buildAxis_u24lambda_u240).strokeColor().set(this.axisTheme.lineColor());
                StrokeDashArraySupport.INSTANCE.apply((SvgShape)$this$buildAxis_u24lambda_u240, this.axisTheme.lineWidth(), this.axisTheme.lineType());
                Object axisLine = object;
                rootElement.children().add(axisLine);
            }
        }
    }

    private final SvgGElement buildTick(String label, DoubleVector labelOffset, AxisTheme axisTheme) {
        SvgLineElement tickMark = null;
        if (axisTheme.showTickMarks()) {
            tickMark = new SvgLineElement();
            tickMark.strokeWidth().set(axisTheme.tickMarkWidth());
            tickMark.strokeColor().set(axisTheme.tickMarkColor());
            StrokeDashArraySupport.INSTANCE.apply(tickMark, axisTheme.tickMarkWidth(), axisTheme.tickMarkLineType());
        }
        MultilineLabel tickLabel = null;
        if (axisTheme.showLabels()) {
            tickLabel = new MultilineLabel(label, 0, false, 6, null);
            tickLabel.addClassName("axis-text-" + axisTheme.getAxis());
        }
        double markLength = axisTheme.tickMarkLength();
        switch (WhenMappings.$EnumSwitchMapping$0[this.orientation.ordinal()]) {
            case 1: {
                if (tickMark == null) break;
                tickMark.x2().set(-markLength);
                tickMark.y2().set(0.0);
                break;
            }
            case 2: {
                if (tickMark == null) break;
                tickMark.x2().set(markLength);
                tickMark.y2().set(0.0);
                break;
            }
            case 3: {
                if (tickMark == null) break;
                tickMark.x2().set(0.0);
                tickMark.y2().set(-markLength);
                break;
            }
            case 4: {
                if (tickMark == null) break;
                tickMark.x2().set(0.0);
                tickMark.y2().set(markLength);
            }
        }
        SvgGElement g = new SvgGElement();
        if (tickMark != null) {
            g.children().add(tickMark);
        }
        if (tickLabel != null) {
            tickLabel.moveTo(labelOffset.getX(), labelOffset.getY());
            tickLabel.setHorizontalAnchor(this.labelAdjustments.getHorizontalAnchor());
            tickLabel.setVerticalAnchor(this.labelAdjustments.getVerticalAnchor());
            double lineHeight = PlotLabelSpecFactory.INSTANCE.axisTick(axisTheme).height();
            tickLabel.setLineHeight(lineHeight);
            tickLabel.rotate(this.labelAdjustments.getRotationDegree());
            g.children().add(tickLabel.getRootGroup());
        }
        return g;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001BW\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\u0002\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$BreaksData;", "", "majorBreaks", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "majorLabels", "", "minorBreaks", "majorGrid", "minorGrid", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getMajorBreaks", "()Ljava/util/List;", "getMajorGrid", "getMajorLabels", "getMinorBreaks", "getMinorGrid", "plot-builder"})
    public static final class BreaksData {
        @NotNull
        private final List<DoubleVector> majorBreaks;
        @NotNull
        private final List<String> majorLabels;
        @NotNull
        private final List<DoubleVector> minorBreaks;
        @NotNull
        private final List<List<DoubleVector>> majorGrid;
        @NotNull
        private final List<List<DoubleVector>> minorGrid;

        public BreaksData(@NotNull List<DoubleVector> majorBreaks, @NotNull List<String> majorLabels, @NotNull List<DoubleVector> minorBreaks, @NotNull List<? extends List<DoubleVector>> majorGrid, @NotNull List<? extends List<DoubleVector>> minorGrid) {
            Intrinsics.checkNotNullParameter(majorBreaks, (String)"majorBreaks");
            Intrinsics.checkNotNullParameter(majorLabels, (String)"majorLabels");
            Intrinsics.checkNotNullParameter(minorBreaks, (String)"minorBreaks");
            Intrinsics.checkNotNullParameter(majorGrid, (String)"majorGrid");
            Intrinsics.checkNotNullParameter(minorGrid, (String)"minorGrid");
            this.majorBreaks = majorBreaks;
            this.majorLabels = majorLabels;
            this.minorBreaks = minorBreaks;
            this.majorGrid = majorGrid;
            this.minorGrid = minorGrid;
        }

        @NotNull
        public final List<DoubleVector> getMajorBreaks() {
            return this.majorBreaks;
        }

        @NotNull
        public final List<String> getMajorLabels() {
            return this.majorLabels;
        }

        @NotNull
        public final List<DoubleVector> getMinorBreaks() {
            return this.minorBreaks;
        }

        @NotNull
        public final List<List<DoubleVector>> getMajorGrid() {
            return this.majorGrid;
        }

        @NotNull
        public final List<List<DoubleVector>> getMinorGrid() {
            return this.minorGrid;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aR\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "horizontalAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "verticalAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;", "rotationDegree", "", "bounds", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "additionalOffsets", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "(Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;DLjava/util/List;Ljava/util/List;)V", "getBounds", "()Ljava/util/List;", "getHorizontalAnchor", "()Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "getRotationDegree", "()D", "getVerticalAnchor", "()Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;", "additionalOffset", "tickIndex", "", "plot-builder"})
    public static final class TickLabelAdjustments {
        private final double rotationDegree;
        @Nullable
        private final List<DoubleRectangle> bounds;
        @Nullable
        private final List<DoubleVector> additionalOffsets;
        @NotNull
        private final Text.HorizontalAnchor horizontalAnchor;
        @NotNull
        private final Text.VerticalAnchor verticalAnchor;

        public TickLabelAdjustments(@NotNull Orientation orientation, @Nullable Text.HorizontalAnchor horizontalAnchor, @Nullable Text.VerticalAnchor verticalAnchor, double rotationDegree, @Nullable List<DoubleRectangle> bounds, @Nullable List<DoubleVector> additionalOffsets) {
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            this.rotationDegree = rotationDegree;
            this.bounds = bounds;
            this.additionalOffsets = additionalOffsets;
            Text.HorizontalAnchor horizontalAnchor2 = horizontalAnchor;
            if (horizontalAnchor2 == null) {
                switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
                    case 1: {
                        horizontalAnchor2 = Text.HorizontalAnchor.RIGHT;
                        break;
                    }
                    case 2: {
                        horizontalAnchor2 = Text.HorizontalAnchor.LEFT;
                        break;
                    }
                    case 3: 
                    case 4: {
                        horizontalAnchor2 = Text.HorizontalAnchor.MIDDLE;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            this.horizontalAnchor = horizontalAnchor2;
            Text.VerticalAnchor verticalAnchor2 = verticalAnchor;
            if (verticalAnchor2 == null) {
                switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
                    case 1: 
                    case 2: {
                        verticalAnchor2 = Text.VerticalAnchor.CENTER;
                        break;
                    }
                    case 3: {
                        verticalAnchor2 = Text.VerticalAnchor.BOTTOM;
                        break;
                    }
                    case 4: {
                        verticalAnchor2 = Text.VerticalAnchor.TOP;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            this.verticalAnchor = verticalAnchor2;
        }

        public /* synthetic */ TickLabelAdjustments(Orientation orientation, Text.HorizontalAnchor horizontalAnchor, Text.VerticalAnchor verticalAnchor, double d, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                horizontalAnchor = null;
            }
            if ((n & 4) != 0) {
                verticalAnchor = null;
            }
            if ((n & 8) != 0) {
                d = 0.0;
            }
            if ((n & 0x10) != 0) {
                list2 = null;
            }
            if ((n & 0x20) != 0) {
                list3 = null;
            }
            this(orientation, horizontalAnchor, verticalAnchor, d, list2, list3);
        }

        public final double getRotationDegree() {
            return this.rotationDegree;
        }

        @Nullable
        public final List<DoubleRectangle> getBounds() {
            return this.bounds;
        }

        @NotNull
        public final Text.HorizontalAnchor getHorizontalAnchor() {
            return this.horizontalAnchor;
        }

        @NotNull
        public final Text.VerticalAnchor getVerticalAnchor() {
            return this.verticalAnchor;
        }

        @NotNull
        public final DoubleVector additionalOffset(int tickIndex) {
            List<DoubleVector> list2 = this.additionalOffsets;
            if (list2 == null || (list2 = list2.get(tickIndex)) == null) {
                list2 = DoubleVector.Companion.getZERO();
            }
            return list2;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Orientation.values().length];
                try {
                    nArray[Orientation.LEFT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Orientation.RIGHT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Orientation.TOP.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Orientation.BOTTOM.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

