/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.pos;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.DimensionUnit;
import org.jetbrains.letsPlot.core.plot.base.pos.PositionAdjustments;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/pos/NudgePos;", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "width", "", "height", "unit", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "(Ljava/lang/Double;Ljava/lang/Double;Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;)V", "adjustedDimension", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getAdjustedDimension", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getUnit", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "handlesGroups", "", "translate", "v", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "Companion", "plot-base"})
public final class NudgePos
implements PositionAdjustment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DimensionUnit unit;
    private final double width;
    private final double height;
    public static final double DEF_NUDGE_WIDTH = 0.0;
    public static final double DEF_NUDGE_HEIGHT = 0.0;

    public NudgePos(@Nullable Double width2, @Nullable Double height, @NotNull DimensionUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.unit = unit;
        Double d = width2;
        this.width = d != null ? d : 0.0;
        Double d2 = height;
        this.height = d2 != null ? d2 : 0.0;
    }

    @NotNull
    public final DimensionUnit getUnit() {
        return this.unit;
    }

    @Override
    @NotNull
    public DoubleVector translate(@NotNull DoubleVector v, @NotNull DataPointAesthetics p, @NotNull GeomContext ctx2) {
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        CoordinateSystem coordinateSystem = ctx2.getCoordinateSystem();
        if (coordinateSystem == null) {
            return v;
        }
        CoordinateSystem coord = coordinateSystem;
        switch (WhenMappings.$EnumSwitchMapping$0[this.unit.ordinal()]) {
            case 1: {
                throw new IllegalStateException(("Unsupported unit: " + (Object)((Object)this.unit)).toString());
            }
            case 2: {
                doubleVector = v.add(this.getAdjustedDimension());
                break;
            }
            case 3: {
                DoubleVector doubleVector2 = coord.toClient(v);
                if (doubleVector2 == null) {
                    throw new IllegalStateException("Failed to convert origin to client coordinates".toString());
                }
                DoubleVector originClient = doubleVector2;
                DoubleVector transformedOrigin = originClient.add(this.getAdjustedDimension());
                doubleVector = coord.fromClient(transformedOrigin);
                if (doubleVector != null) break;
                throw new IllegalStateException("Failed to convert transformed origin from client coordinates".toString());
            }
            case 4: {
                DoubleVector doubleVector3 = coord.toClient(v);
                if (doubleVector3 == null) {
                    throw new IllegalStateException("Failed to convert origin to client coordinates".toString());
                }
                DoubleVector originClient = doubleVector3;
                DoubleVector transformedOrigin = originClient.add(this.getAdjustedDimension());
                doubleVector = coord.fromClient(transformedOrigin);
                if (doubleVector != null) break;
                throw new IllegalStateException("Failed to convert transformed origin from client coordinates".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return doubleVector;
    }

    @Override
    public boolean handlesGroups() {
        return PositionAdjustments.Meta.NUDGE.handlesGroups();
    }

    @NotNull
    public final DoubleVector getAdjustedDimension() {
        DoubleVector doubleVector;
        switch (WhenMappings.$EnumSwitchMapping$0[this.unit.ordinal()]) {
            case 1: {
                throw new IllegalStateException(("Unsupported unit: " + (Object)((Object)this.unit)).toString());
            }
            case 2: {
                doubleVector = new DoubleVector(this.width, this.height);
                break;
            }
            case 3: {
                doubleVector = new DoubleVector(this.width * 2.2, -this.height * 2.2);
                break;
            }
            case 4: {
                doubleVector = new DoubleVector(this.width, -this.height);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return doubleVector;
    }

    @Override
    public boolean isIdentity() {
        return PositionAdjustment.DefaultImpls.isIdentity(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/pos/NudgePos$Companion;", "", "()V", "DEF_NUDGE_HEIGHT", "", "DEF_NUDGE_WIDTH", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DimensionUnit.values().length];
            try {
                nArray[DimensionUnit.RESOLUTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionUnit.IDENTITY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionUnit.SIZE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionUnit.PIXEL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

