/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.OutputDirectoryParamProcessor;
import com.thaiopensource.relaxng.output.OutputFailedException;
import com.thaiopensource.relaxng.output.OutputFormat;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.xsd.BasicBuilder;
import com.thaiopensource.relaxng.output.xsd.BasicOutput;
import com.thaiopensource.relaxng.output.xsd.Guide;
import com.thaiopensource.relaxng.output.xsd.PrefixManager;
import com.thaiopensource.relaxng.output.xsd.RefChecker;
import com.thaiopensource.relaxng.output.xsd.RestrictionsChecker;
import com.thaiopensource.relaxng.output.xsd.SchemaInfo;
import com.thaiopensource.relaxng.output.xsd.Transformer;
import com.thaiopensource.relaxng.output.xsd.basic.Schema;
import com.thaiopensource.relaxng.translate.util.AbstractParam;
import com.thaiopensource.relaxng.translate.util.EnumParam;
import com.thaiopensource.relaxng.translate.util.InvalidParamsException;
import java.io.IOException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XsdOutputFormat
implements OutputFormat {
    private static final boolean DEFAULT_ENABLE_ABSTRACT_ELEMENT = true;
    private static final String[] processContents = new String[]{"skip", "lax", "strict"};

    public void output(SchemaCollection schemaCollection, OutputDirectory outputDirectory, String[] stringArray, String string, ErrorHandler errorHandler) throws SAXException, IOException, OutputFailedException, InvalidParamsException {
        final Guide guide = new Guide(true);
        final BasicOutput.Options options = new BasicOutput.Options();
        if ("dtd".equals(string)) {
            options.anyProcessContents = "strict";
        }
        OutputDirectoryParamProcessor outputDirectoryParamProcessor = new OutputDirectoryParamProcessor(outputDirectory);
        outputDirectoryParamProcessor.declare("disable-abstract-elements", new AbstractParam(){

            public void set(boolean bl) {
                guide.setDefaultGroupEnableAbstractElements(!bl);
            }
        });
        outputDirectoryParamProcessor.declare("any-process-contents", new EnumParam(processContents){

            protected void setEnum(int n) {
                options.anyProcessContents = this.getValues()[n];
            }
        });
        outputDirectoryParamProcessor.declare("any-attribute-process-contents", new EnumParam(processContents){

            protected void setEnum(int n) {
                options.anyAttributeProcessContents = this.getValues()[n];
            }
        });
        outputDirectoryParamProcessor.process(stringArray, errorHandler);
        try {
            ErrorReporter errorReporter = new ErrorReporter(errorHandler, XsdOutputFormat.class);
            SchemaInfo schemaInfo = new SchemaInfo(schemaCollection, errorReporter);
            if (!errorReporter.getHadError()) {
                RefChecker.check(schemaInfo, errorReporter);
                if (!errorReporter.getHadError()) {
                    RestrictionsChecker.check(schemaInfo, errorReporter);
                    if (!errorReporter.getHadError()) {
                        Schema schema = BasicBuilder.buildBasicSchema(schemaInfo, guide, errorReporter);
                        if (!errorReporter.getHadError()) {
                            new Transformer(schema, errorReporter).transform();
                            if (!errorReporter.getHadError()) {
                                BasicOutput.output(schema, guide, new PrefixManager(schemaInfo), outputDirectory, options, errorReporter);
                            }
                        }
                    }
                }
            }
            if (errorReporter.getHadError()) {
                throw new OutputFailedException();
            }
        }
        catch (ErrorReporter.WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.getException();
        }
    }
}

