/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.items.fileconverter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.fileconverter.ItemFileGenerator;

@NonNullByDefault
public abstract class AbstractItemFileGenerator
implements ItemFileGenerator {
    protected List<Metadata> getChannelLinks(Collection<Metadata> metadata, String itemName) {
        return metadata.stream().filter(md -> "channel".equals(md.getUID().getNamespace()) && md.getUID().getItemName().equals(itemName)).sorted((md1, md2) -> md1.getValue().compareTo(md2.getValue())).collect(Collectors.toList());
    }

    protected List<Metadata> getMetadata(Collection<Metadata> metadata, String itemName) {
        return metadata.stream().filter(md -> !"semantics".equals(md.getUID().getNamespace()) && !"channel".equals(md.getUID().getNamespace()) && md.getUID().getItemName().equals(itemName)).sorted((md1, md2) -> md1.getUID().getNamespace().compareTo(md2.getUID().getNamespace())).collect(Collectors.toList());
    }

    protected List<ConfigParameter> getConfigurationParameters(Metadata metadata) {
        String namespace = metadata.getUID().getNamespace();
        Map<String, Object> configParams = metadata.getConfiguration();
        List paramNames = configParams.keySet().stream().sorted((key1, key2) -> {
            if ("stateDescription".equals(namespace)) {
                if ("min".equals(key1)) {
                    return -1;
                }
                if ("min".equals(key2)) {
                    return 1;
                }
                if ("max".equals(key1)) {
                    return -1;
                }
                if ("max".equals(key2)) {
                    return 1;
                }
                if ("step".equals(key1)) {
                    return -1;
                }
                if ("step".equals(key2)) {
                    return 1;
                }
            }
            return key1.compareTo((String)key2);
        }).collect(Collectors.toList());
        ArrayList<ConfigParameter> parameters = new ArrayList<ConfigParameter>();
        for (String paramName : paramNames) {
            Object value = configParams.get(paramName);
            if (value == null) continue;
            parameters.add(new ConfigParameter(paramName, value));
        }
        return parameters;
    }

    protected @Nullable String getDefaultStatePattern(Item item) {
        String pattern;
        block15: {
            block16: {
                block14: {
                    pattern = null;
                    if (!(item instanceof GroupItem)) break block14;
                    GroupItem group = (GroupItem)item;
                    Item baseItem = group.getBaseItem();
                    if (baseItem != null) {
                        pattern = this.getDefaultStatePattern(baseItem);
                    }
                    break block15;
                }
                if (!item.getType().startsWith("Number:")) break block16;
                pattern = "%.0f %unit%";
                break block15;
            }
            switch (item.getType()) {
                case "String": {
                    pattern = "%s";
                    break;
                }
                case "DateTime": {
                    pattern = "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS";
                    break;
                }
                case "Number": {
                    pattern = "%.0f";
                    break;
                }
            }
        }
        return pattern;
    }

    public record ConfigParameter(String name, Object value) {
    }
}

