/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.store.abstr;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.jivesoftware.smackx.ox.exception.MissingUserIdOnKeyException;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpKeyStore;
import org.jxmpp.jid.BareJid;
import org.pgpainless.PGPainless;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.info.KeyRingInfo;

public abstract class AbstractOpenPgpKeyStore
implements OpenPgpKeyStore {
    protected static final Logger LOGGER = Logger.getLogger(AbstractOpenPgpKeyStore.class.getName());
    protected Map<BareJid, PGPPublicKeyRingCollection> publicKeyRingCollections = new HashMap<BareJid, PGPPublicKeyRingCollection>();
    protected Map<BareJid, PGPSecretKeyRingCollection> secretKeyRingCollections = new HashMap<BareJid, PGPSecretKeyRingCollection>();
    protected Map<BareJid, Map<OpenPgpV4Fingerprint, Date>> keyFetchDates = new HashMap<BareJid, Map<OpenPgpV4Fingerprint, Date>>();

    protected abstract PGPPublicKeyRingCollection readPublicKeysOf(BareJid var1) throws IOException, PGPException;

    protected abstract void writePublicKeysOf(BareJid var1, PGPPublicKeyRingCollection var2) throws IOException;

    protected abstract PGPSecretKeyRingCollection readSecretKeysOf(BareJid var1) throws IOException, PGPException;

    protected abstract void writeSecretKeysOf(BareJid var1, PGPSecretKeyRingCollection var2) throws IOException;

    protected abstract Map<OpenPgpV4Fingerprint, Date> readKeyFetchDates(BareJid var1) throws IOException;

    protected abstract void writeKeyFetchDates(BareJid var1, Map<OpenPgpV4Fingerprint, Date> var2) throws IOException;

    @Override
    public Map<OpenPgpV4Fingerprint, Date> getPublicKeyFetchDates(BareJid contact) throws IOException {
        Map<OpenPgpV4Fingerprint, Date> dates = this.keyFetchDates.get(contact);
        if (dates == null) {
            dates = this.readKeyFetchDates(contact);
            this.keyFetchDates.put(contact, dates);
        }
        return dates;
    }

    @Override
    public void setPublicKeyFetchDates(BareJid contact, Map<OpenPgpV4Fingerprint, Date> dates) throws IOException {
        this.keyFetchDates.put(contact, dates);
        this.writeKeyFetchDates(contact, dates);
    }

    @Override
    public PGPPublicKeyRingCollection getPublicKeysOf(BareJid owner2) throws IOException, PGPException {
        PGPPublicKeyRingCollection keys = this.publicKeyRingCollections.get(owner2);
        if (keys == null && (keys = this.readPublicKeysOf(owner2)) != null) {
            this.publicKeyRingCollections.put(owner2, keys);
        }
        return keys;
    }

    @Override
    public PGPSecretKeyRingCollection getSecretKeysOf(BareJid owner2) throws IOException, PGPException {
        PGPSecretKeyRingCollection keys = this.secretKeyRingCollections.get(owner2);
        if (keys == null && (keys = this.readSecretKeysOf(owner2)) != null) {
            this.secretKeyRingCollections.put(owner2, keys);
        }
        return keys;
    }

    @Override
    public void importSecretKey(BareJid owner2, PGPSecretKeyRing secretKeys) throws IOException, PGPException, MissingUserIdOnKeyException {
        if (!new KeyRingInfo(secretKeys).isUserIdValid("xmpp:" + owner2.toString())) {
            throw new MissingUserIdOnKeyException(owner2, new OpenPgpV4Fingerprint(secretKeys));
        }
        PGPSecretKeyRingCollection secretKeyRings = this.getSecretKeysOf(owner2);
        try {
            secretKeyRings = secretKeyRings != null ? PGPSecretKeyRingCollection.addSecretKeyRing(secretKeyRings, secretKeys) : new PGPSecretKeyRingCollection(Collections.singleton(secretKeys));
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.INFO, "Skipping secret key ring " + Long.toHexString(secretKeys.getPublicKey().getKeyID()) + " as it is already in the key ring of " + owner2.toString());
        }
        this.secretKeyRingCollections.put(owner2, secretKeyRings);
        this.writeSecretKeysOf(owner2, secretKeyRings);
    }

    @Override
    public void importPublicKey(BareJid owner2, PGPPublicKeyRing publicKeys) throws IOException, PGPException, MissingUserIdOnKeyException {
        if (!new KeyRingInfo(publicKeys).isUserIdValid("xmpp:" + owner2.toString())) {
            throw new MissingUserIdOnKeyException(owner2, new OpenPgpV4Fingerprint(publicKeys));
        }
        PGPPublicKeyRingCollection publicKeyRings = this.getPublicKeysOf(owner2);
        try {
            publicKeyRings = publicKeyRings != null ? PGPPublicKeyRingCollection.addPublicKeyRing(publicKeyRings, publicKeys) : new PGPPublicKeyRingCollection(Collections.singleton(publicKeys));
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.FINE, "Skipping public key ring " + Long.toHexString(publicKeys.getPublicKey().getKeyID()) + " as it is already in the key ring of " + owner2.toString(), e);
        }
        this.publicKeyRingCollections.put(owner2, publicKeyRings);
        this.writePublicKeysOf(owner2, publicKeyRings);
    }

    @Override
    public PGPPublicKeyRing getPublicKeyRing(BareJid owner2, OpenPgpV4Fingerprint fingerprint) throws IOException, PGPException {
        PGPPublicKeyRingCollection publicKeyRings = this.getPublicKeysOf(owner2);
        if (publicKeyRings != null) {
            return publicKeyRings.getPublicKeyRing(fingerprint.getKeyId());
        }
        return null;
    }

    @Override
    public PGPSecretKeyRing getSecretKeyRing(BareJid owner2, OpenPgpV4Fingerprint fingerprint) throws IOException, PGPException {
        PGPSecretKeyRingCollection secretKeyRings = this.getSecretKeysOf(owner2);
        if (secretKeyRings != null) {
            return secretKeyRings.getSecretKeyRing(fingerprint.getKeyId());
        }
        return null;
    }

    @Override
    public void deletePublicKeyRing(BareJid owner2, OpenPgpV4Fingerprint fingerprint) throws IOException, PGPException {
        PGPPublicKeyRingCollection publicKeyRings = this.getPublicKeysOf(owner2);
        if (publicKeyRings.contains(fingerprint.getKeyId())) {
            if (!(publicKeyRings = PGPPublicKeyRingCollection.removePublicKeyRing(publicKeyRings, publicKeyRings.getPublicKeyRing(fingerprint.getKeyId()))).iterator().hasNext()) {
                publicKeyRings = null;
            }
            this.publicKeyRingCollections.put(owner2, publicKeyRings);
            this.writePublicKeysOf(owner2, publicKeyRings);
        }
    }

    @Override
    public void deleteSecretKeyRing(BareJid owner2, OpenPgpV4Fingerprint fingerprint) throws IOException, PGPException {
        PGPSecretKeyRingCollection secretKeyRings = this.getSecretKeysOf(owner2);
        if (secretKeyRings.contains(fingerprint.getKeyId())) {
            if (!(secretKeyRings = PGPSecretKeyRingCollection.removeSecretKeyRing(secretKeyRings, secretKeyRings.getSecretKeyRing(fingerprint.getKeyId()))).iterator().hasNext()) {
                secretKeyRings = null;
            }
            this.secretKeyRingCollections.put(owner2, secretKeyRings);
            this.writeSecretKeysOf(owner2, secretKeyRings);
        }
    }

    @Override
    public PGPSecretKeyRing generateKeyRing(BareJid owner2) throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        return PGPainless.generateKeyRing().modernKeyRing("xmpp:" + owner2.toString());
    }
}

