# This script is currently unused,
# but we leave it here as backup in case when we ever need a reliable detection of VmId
#Requires -Version 5.1

param(
  [switch]$Elevated,
  [string]$OutputPath
)

$currentUser = New-Object Security.Principal.WindowsPrincipal $([Security.Principal.WindowsIdentity]::GetCurrent())
$isAdmin = $currentUser.IsInRole([Security.Principal.WindowsBuiltinRole]::Administrator)

if ($isAdmin -eq $false)  {
    if ($elevated) {
        # Could not elevate permissions
        [Console]::Error.WriteLine("Could not obtain elevated privileges")
    } else {
        $tempOutputPath = [System.IO.Path]::GetTempFileName()
        Start-Process `
            -FilePath "powershell.exe" `
            -ArgumentList ('-NoProfile -ExecutionPolicy Bypass -file "{0}" -Elevated -OutputPath "{1}"' `
                           -f ($myinvocation.MyCommand.Definition), $tempOutputPath) `
            -Verb RunAs `
            -Wait `
            -WindowStyle Hidden
        Write-Output (Get-Content -Path $tempOutputPath -Raw)
        Remove-Item -Path $tempOutputPath
    }
    exit
}

Add-Type -TypeDefinition @'
using System;
using System.Runtime.InteropServices;

public static class VmCompute{
    [DllImport("vmcompute.dll", ExactSpelling = true)]
    public static extern int HcsEnumerateComputeSystems(string query, [MarshalAs(UnmanagedType.LPWStr)] out string computeSystems, [MarshalAs(UnmanagedType.LPWStr)] out string result);
}
'@

$computeSystemsJson = ""
$result = ""
$query = ""
$hresult = [VmCompute]::HcsEnumerateComputeSystems($query, [ref] $computeSystemsJson, [ref]$result)

if ($hresult -eq 0) {
    if ($elevated) {
        Set-Content -Path $OutputPath -Value $computeSystemsJson
    } else {
        Write-Output $computeSystemsJson
    }
}
else {
    $errorMessage = [System.Runtime.InteropServices.Marshal]::GetExceptionForHR($hresult).Message
    [Console]::Error.WriteLine($errorMessage)
}
exit