/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitParameterStructure;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JSImplicitParameterImpl
implements JSParameterItem {
    @NotNull
    private final JSImplicitParameterStructure myStructure;
    @Nullable
    private final PsiElement myProvider;

    JSImplicitParameterImpl(@NotNull JSImplicitParameterStructure structure, @Nullable PsiElement provider) {
        if (structure == null) {
            JSImplicitParameterImpl.$$$reportNull$$$0(0);
        }
        this.myStructure = structure;
        this.myProvider = provider;
    }

    @Override
    @Nullable
    public JSType getSimpleType() {
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(this.myProvider, this.myStructure.isTypeExplicitlyDeclared());
        return JSTypeParser.createType(this.myStructure.getTypeString(), typeSource);
    }

    @Override
    @Nullable
    public JSType getInferredType() {
        return this.getSimpleType();
    }

    @Override
    public boolean isOptional() {
        return this.myStructure.isOptional();
    }

    @Override
    public boolean isRest() {
        return this.myStructure.isRest();
    }

    @Override
    @NotNull
    public JSParameterTypeDecorator getTypeDecorator() {
        boolean isExplicitlyDeclared = this.myStructure.isTypeExplicitlyDeclared();
        return new JSParameterTypeDecoratorImpl(this.getName(), this.getSimpleType(), this.isOptional(), this.isRest(), isExplicitlyDeclared);
    }

    @Override
    @Nullable
    public String getName() {
        return this.myStructure.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitParameterImpl", "<init>"));
    }
}

