/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.ecmascript6.ES6QualifiedNamedElementRenderer;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.ImportJSModuleBaseFix;
import com.intellij.lang.javascript.modules.JSImportHintKt;
import com.intellij.lang.javascript.modules.imports.JSImportAction;
import com.intellij.lang.javascript.modules.imports.JSImportCandidateWithExecutor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImportModuleFix
extends LocalQuickFixOnPsiElement
implements ImportJSModuleBaseFix,
LocalQuickFix,
HintAction,
PriorityAction,
Comparable<IntentionAction> {
    @NotNull
    private final NotNullLazyValue<String> myInsertedText;
    @NotNull
    protected final JSImportCandidateWithExecutor myCandidate;
    private volatile HintMode myHintMode;

    public JSImportModuleFix(@NotNull PsiElement node, @NotNull JSImportCandidateWithExecutor descriptor, @NotNull HintMode hintMode) {
        if (node == null) {
            JSImportModuleFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            JSImportModuleFix.$$$reportNull$$$0(1);
        }
        if (hintMode == null) {
            JSImportModuleFix.$$$reportNull$$$0(2);
        }
        super(node);
        this.myCandidate = descriptor;
        this.myHintMode = hintMode;
        this.myInsertedText = NotNullLazyValue.createValue(this.myCandidate::getImportText);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            JSImportModuleFix.$$$reportNull$$$0(3);
        }
        return this.isAvailable() && this.myCandidate.getDescriptor() != null && JSImportAction.isValidImportPlace(this.getStartElement());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            JSImportModuleFix.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiElement element2 = this.getStartElement();
        if (element2 != null) {
            this.invokeAction(element2);
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            JSImportModuleFix.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            JSImportModuleFix.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            JSImportModuleFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            JSImportModuleFix.$$$reportNull$$$0(8);
        }
        this.invokeAction(startElement);
    }

    private void invokeAction(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSImportModuleFix.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.myHintMode = HintMode.NO_HINT;
        PsiFile file = element2.getContainingFile();
        this.myCandidate.execute();
        DaemonCodeAnalyzer.getInstance((Project)file.getProject()).restart(file);
    }

    public static PsiFile createDummyFile(Project project, String text) {
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        return psiFileFactory.createFileFromText("dummy.js", (FileType)JavaScriptFileType.INSTANCE, (CharSequence)text);
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            JSImportModuleFix.$$$reportNull$$$0(10);
        }
        if (this.myHintMode == HintMode.NO_HINT) {
            return false;
        }
        PsiElement element2 = this.myCandidate.getElement();
        String text = this.getHintText(element2);
        return JSImportHintKt.showImportHint(this.myCandidate.getName(), this.getStartElement(), editor, text, this.myHintMode == HintMode.MULTI);
    }

    private String getHintText(@Nullable PsiElement element2) {
        if (this.myHintMode == HintMode.SINGLE) {
            return this.getInsertedText();
        }
        return element2 instanceof JSElement ? new ES6QualifiedNamedElementRenderer<PsiElement>().getElementText(element2) : this.myCandidate.getName();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    protected String getQuote() {
        PsiElement element2 = this.getStartElement();
        return element2 != null ? JSCodeStyleSettings.getQuote(element2) : "\"";
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = PriorityAction.Priority.TOP;
        if (priority == null) {
            JSImportModuleFix.$$$reportNull$$$0(11);
        }
        return priority;
    }

    private String getInsertedText() {
        return (String)this.myInsertedText.getValue();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.inspection.es6.modules.dependencies.family.name", new Object[0]);
        if (string == null) {
            JSImportModuleFix.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        String wholeImportWrapQuote = ES6ImportPsiUtil.invertQuote(this.getQuote());
        String string = IdeBundle.message((String)"quickfix.text.insert.0", (Object[])new Object[]{wholeImportWrapQuote + this.getInsertedText() + wholeImportWrapQuote});
        if (string == null) {
            JSImportModuleFix.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull IntentionAction o) {
        if (o == null) {
            JSImportModuleFix.$$$reportNull$$$0(14);
        }
        if (o instanceof JSImportModuleFix) {
            return this.myCandidate.compareTo(((JSImportModuleFix)o).myCandidate);
        }
        return Comparing.compare((Comparable)((Object)this.getText()), (Comparable)((Object)o.getText()));
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            JSImportModuleFix.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            JSImportModuleFix.$$$reportNull$$$0(16);
        }
        if (psiFile == null) {
            JSImportModuleFix.$$$reportNull$$$0(17);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            JSImportModuleFix.$$$reportNull$$$0(18);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintMode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSImportModuleFix";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSImportModuleFix";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeAction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 18: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 18 -> new IllegalStateException(string);
        };
    }

    public static enum HintMode {
        NO_HINT,
        SINGLE,
        MULTI;

    }
}

