/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.jsx.JSXCommentProvider;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterRelatedIntention;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterSuppressionUtil {
    protected JSLinterSuppressionUtil() {
    }

    @Nullable
    public IntentionAction getSuppressForLineAction(@NotNull JSLinterError error, long documentModificationStamp) {
        String code;
        if (error == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)(code = error.getCode()))) {
            return null;
        }
        return new SuppressForLineIntentionAction(code, error.getLine(), documentModificationStamp);
    }

    public SuppressIntentionAction @NotNull [] getSuppressionsForError(@NotNull JSLinterError error, long documentModificationStamp) {
        String code;
        if (error == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)(code = error.getCode()))) {
            if (SuppressIntentionAction.EMPTY_ARRAY == null) {
                JSLinterSuppressionUtil.$$$reportNull$$$0(2);
            }
            return SuppressIntentionAction.EMPTY_ARRAY;
        }
        SuppressIntentionAction[] suppressIntentionActionArray = new SuppressIntentionAction[]{new SuppressForLineIntentionAction(code, error.getLine(), documentModificationStamp), new SuppressForFileIntentionAction(code, documentModificationStamp), new SuppressForLineIntentionAction(null, error.getLine(), documentModificationStamp), new SuppressForFileIntentionAction(null, documentModificationStamp)};
        if (suppressIntentionActionArray == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(3);
        }
        return suppressIntentionActionArray;
    }

    @Nullable
    protected abstract String getRulesFromFileLevelComment(@NotNull PsiComment var1);

    @Nullable
    protected abstract String getRulesFromLineSuppressionComment(@NotNull PsiComment var1);

    @NotNull
    @Nls
    protected abstract String getToolName();

    @NotNull
    protected abstract String buildLineCommentText(@Nullable String var1, @Nullable String var2);

    @NotNull
    protected abstract String buildFileCommentText(@Nullable String var1, @Nullable String var2);

    private void insertFileSuppressionComment(@NotNull PsiElement element2, @Nullable String ruleCode) {
        JSElement rootElement;
        if (element2 == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(4);
        }
        if ((rootElement = JSLinterSuppressionUtil.getRootJSElement(element2)) == null) {
            return;
        }
        Pair<PsiComment, String> existing = this.findFileLevelComment((PsiElement)rootElement);
        if (existing != null) {
            String commentText = "/* " + this.buildFileCommentText((String)existing.second, ruleCode) + " */";
            PsiComment newComment = JSPsiElementFactory.createPsiComment(commentText, (PsiElement)rootElement);
            ((PsiComment)existing.first).replace((PsiElement)newComment);
        } else {
            String commentText = "/* " + this.buildFileCommentText(null, ruleCode) + " */";
            PsiComment newComment = JSPsiElementFactory.createPsiComment(commentText, (PsiElement)rootElement);
            newComment = (PsiComment)rootElement.addBefore((PsiElement)newComment, rootElement.getFirstChild());
            if (rootElement instanceof JSEmbeddedContent) {
                JSChangeUtil.addWs(rootElement.getNode(), newComment.getNode(), "\n");
            }
        }
    }

    @Nullable
    private Pair<PsiComment, String> findFileLevelComment(@NotNull PsiElement rootElement) {
        if (rootElement == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(5);
        }
        return JSLinterSuppressionUtil.findFileLevelComment(rootElement, this::getRulesFromFileLevelComment);
    }

    private void insertLineSuppressionComment(@NotNull Document document, @NotNull PsiElement element2, int lineNumber, @Nullable String ruleCode) {
        int previousLineEnd;
        int previousLineStart;
        Pair<PsiComment, String> existing;
        JSElement rootElement;
        if (document == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(7);
        }
        if ((rootElement = JSLinterSuppressionUtil.getRootJSElement(element2)) == null) {
            return;
        }
        String existingSuppressions = null;
        PsiComment existingComment = null;
        if (lineNumber > 0 && (existing = JSLinterSuppressionUtil.findLineComment(element2, previousLineStart = document.getLineStartOffset(lineNumber - 1), previousLineEnd = document.getLineEndOffset(lineNumber - 1), this::getRulesFromLineSuppressionComment)) != null) {
            existingComment = (PsiComment)existing.first;
            existingSuppressions = (String)existing.second;
        }
        boolean isJsxBlockCommentContext = JSLinterSuppressionUtil.isJSXCommentContext(document, element2, lineNumber);
        Pair<String, String> pair = JSLinterSuppressionUtil.getCommentPrefixSuffix(existingComment, element2, isJsxBlockCommentContext);
        Object commentContent = this.buildLineCommentText(ruleCode, existingSuppressions);
        commentContent = (String)pair.first + (String)commentContent + (String)pair.second;
        if (existingComment != null) {
            existingComment.replace((PsiElement)JSPsiElementFactory.createPsiComment((String)commentContent, element2));
        } else {
            int rootElementStartOffset;
            Object comment = commentContent;
            if (isJsxBlockCommentContext) {
                comment = "{" + (String)commentContent + "}";
            }
            comment = (String)comment + "\n";
            int insertionOffset = document.getLineStartOffset(lineNumber);
            if (!JSCodeStyleSettings.getCommonSettings((PsiElement)element2).LINE_COMMENT_AT_FIRST_COLUMN) {
                String indent = JSLinterSuppressionUtil.getIndent(document, lineNumber);
                comment = indent + (String)comment;
            }
            if ((rootElementStartOffset = rootElement.getNode().getStartOffset()) > insertionOffset) {
                insertionOffset = rootElementStartOffset;
                comment = "\n" + ((String)comment).trim();
            }
            document.insertString(insertionOffset, (CharSequence)comment);
            Project project = element2.getProject();
            PsiFile file = rootElement.getContainingFile();
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, insertionOffset);
        }
    }

    private static boolean isJSXCommentContext(@NotNull Document document, @NotNull PsiElement element2, int lineNumber) {
        if (document == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(9);
        }
        if (!DialectDetector.isJSX(element2) || lineNumber <= 0) {
            return false;
        }
        PsiElement context2 = element2.getContainingFile().findElementAt(document.getLineStartOffset(lineNumber));
        return JSXCommentProvider.isTagBodyContext(context2);
    }

    @NotNull
    private static Pair<String, String> getCommentPrefixSuffix(@Nullable PsiComment existing, @NotNull PsiElement context2, boolean isJSTagContent) {
        boolean isLineComment;
        if (context2 == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(10);
        }
        boolean bl = existing != null ? JSTokenTypes.END_OF_LINE_COMMENT == existing.getNode().getElementType() : (isLineComment = !isJSTagContent);
        if (!isLineComment) {
            Pair pair = Pair.create((Object)"/* ", (Object)" */");
            if (pair == null) {
                JSLinterSuppressionUtil.$$$reportNull$$$0(11);
            }
            return pair;
        }
        CommonCodeStyleSettings settings = JSCodeStyleSettings.getCommonSettings(context2);
        String prefix = settings.LINE_COMMENT_ADD_SPACE || settings.LINE_COMMENT_AT_FIRST_COLUMN ? " " : "";
        Pair pair = Pair.create((Object)("//" + prefix), (Object)"");
        if (pair == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(12);
        }
        return pair;
    }

    private static String getIndent(@NotNull Document document, int lineNumber) {
        if (document == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(13);
        }
        CharSequence charsSequence = document.getCharsSequence();
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int indentEndIndex = CharArrayUtil.shiftForward((CharSequence)charsSequence, (int)lineStartOffset, (String)" \t");
        return charsSequence.subSequence(lineStartOffset, indentEndIndex).toString();
    }

    @Nullable
    private static Pair<PsiComment, String> findLineComment(@NotNull PsiElement rootElement, int start, int end, @NotNull Function<? super PsiComment, String> getRules) {
        if (rootElement == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(14);
        }
        if (getRules == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(15);
        }
        PsiElement element2 = rootElement.getContainingFile().getViewProvider().findElementAt(start);
        while (element2 != null) {
            String rulesString;
            if (element2.getTextRange().intersects(start, end) && element2 instanceof PsiComment && StringUtil.isNotEmpty((String)(rulesString = getRules.apply((PsiComment)((PsiComment)element2))))) {
                return Pair.create((Object)((PsiComment)element2), (Object)rulesString);
            }
            element2 = PsiTreeUtil.nextLeaf((PsiElement)element2);
        }
        return null;
    }

    @Nullable
    private static Pair<PsiComment, String> findFileLevelComment(@NotNull PsiElement rootElement, Function<? super PsiComment, String> getRules) {
        if (rootElement == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(16);
        }
        Ref result2 = new Ref();
        PsiTreeUtil.processElements((PsiElement)rootElement, element2 -> {
            String rulesString;
            if (element2 != rootElement && !(element2 instanceof PsiComment) && !(element2 instanceof PsiWhiteSpace)) {
                return false;
            }
            if (element2 instanceof PsiComment && StringUtil.isNotEmpty((String)(rulesString = (String)getRules.apply((PsiComment)element2)))) {
                result2.set((Object)Pair.create((Object)((PsiComment)element2), (Object)rulesString));
                return false;
            }
            return true;
        });
        return (Pair)result2.get();
    }

    @Contract(value="null -> null")
    @Nullable
    private static JSElement getRootJSElement(@Nullable PsiElement element2) {
        return (JSElement)PsiTreeUtil.findFirstParent((PsiElement)element2, e -> e instanceof JSFile || e instanceof JSEmbeddedContent && !JSPsiImplUtils.isEmbeddedExpressionContent(e));
    }

    @IntentionName
    private String getSuppressForLineDescription(@Nullable String code) {
        return StringUtil.isEmpty((String)code) ? JavaScriptBundle.message("javascript.linter.suppress.all.rules.for.line.description", this.getToolName()) : JavaScriptBundle.message("javascript.linter.suppress.rule.for.line.description", code);
    }

    @IntentionName
    private String getSuppressForFileDescription(@Nullable String ruleCode) {
        return StringUtil.isEmpty((String)ruleCode) ? JavaScriptBundle.message("javascript.linter.suppress.all.rules.for.file.description", this.getToolName()) : JavaScriptBundle.message("javascript.linter.suppress.rule.for.file.description", ruleCode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterSuppressionUtil";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 6: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterSuppressionUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressionsForError";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentPrefixSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressForLineAction";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionsForError";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "insertFileSuppressionComment";
                break;
            }
            case 5: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findFileLevelComment";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "insertLineSuppressionComment";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isJSXCommentContext";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCommentPrefixSuffix";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findLineComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 11, 12 -> new IllegalStateException(string);
        };
    }

    private class SuppressForLineIntentionAction
    extends SuppressIntentionAction
    implements PriorityAction,
    JSLinterRelatedIntention {
        @Nullable
        private final String myRuleCode;
        private final int myLineNumber;
        private final long myDocumentModificationStamp;

        SuppressForLineIntentionAction(String myRuleCode, int lineNumber, long documentModificationStamp) {
            this.myRuleCode = myRuleCode;
            this.myLineNumber = lineNumber;
            this.myDocumentModificationStamp = documentModificationStamp;
        }

        @NotNull
        public PriorityAction.Priority getPriority() {
            PriorityAction.Priority priority = PriorityAction.Priority.BOTTOM;
            if (priority == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(0);
            }
            return priority;
        }

        public Icon getIcon(int flags) {
            return AllIcons.Actions.RealIntentionBulb;
        }

        @NotNull
        public String getText() {
            String string = JSLinterSuppressionUtil.this.getSuppressForLineDescription(this.myRuleCode);
            if (string == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("javascript.linter.suppress.rules.for.line.family.name", new Object[0]);
            if (string == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
            if (project == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(3);
            }
            if (element2 == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(4);
            }
            return editor.getDocument().getModificationStamp() == this.myDocumentModificationStamp && JSLinterSuppressionUtil.getRootJSElement(element2) != null;
        }

        public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
            Document document;
            if (project == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(5);
            }
            if (element2 == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(6);
            }
            if ((document = PsiDocumentManager.getInstance((Project)project).getDocument(element2.getContainingFile())) == null) {
                return;
            }
            JSLinterSuppressionUtil.this.insertLineSuppressionComment(document, element2, this.myLineNumber, this.myRuleCode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterSuppressionUtil$SuppressForLineIntentionAction";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterSuppressionUtil$SuppressForLineIntentionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }

    private class SuppressForFileIntentionAction
    extends SuppressIntentionAction {
        @Nullable
        private final String myRuleCode;
        private final long myDocumentModificationStamp;

        SuppressForFileIntentionAction(String code, long documentModificationStamp) {
            this.myRuleCode = code;
            this.myDocumentModificationStamp = documentModificationStamp;
        }

        @NotNull
        public String getText() {
            String string = JSLinterSuppressionUtil.this.getSuppressForFileDescription(this.myRuleCode);
            if (string == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("javascript.linter.suppress.rules.for.file.family.name", new Object[0]);
            if (string == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
            if (project == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(2);
            }
            if (element2 == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(3);
            }
            return editor.getDocument().getModificationStamp() == this.myDocumentModificationStamp && JSLinterSuppressionUtil.getRootJSElement(element2) != null;
        }

        public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
            if (project == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(4);
            }
            if (element2 == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(5);
            }
            JSLinterSuppressionUtil.this.insertFileSuppressionComment(element2, this.myRuleCode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterSuppressionUtil$SuppressForFileIntentionAction";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterSuppressionUtil$SuppressForFileIntentionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

