/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.ComponentWithEmptyBrowseButton;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.beforeRun.NpmBeforeRunTaskDialog;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.ui.PathShortener;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;

public class NpmRunConfigurationEditor
extends SettingsEditor<NpmRunConfiguration> {
    private static final Logger LOG = Logger.getInstance(NpmRunConfigurationEditor.class);
    private final TextFieldWithHistoryWithBrowseButton myPackageJsonField;
    private final ComboBox<NpmCommand> myCommandField;
    private final TextFieldWithHistory myScriptsField;
    private final RawCommandLineEditor myArgumentsEditor;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final RawCommandLineEditor myNodeOptionsEditor;
    private final NodePackageField myPackageManagerPackageField;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final JPanel myPanel;

    public NpmRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myPackageJsonField = NpmRunConfigurationEditor.createPackageJsonField(project);
        PathShortener.enablePathShortening((JTextField)((TextFieldWithHistory)this.myPackageJsonField.getChildComponent()).getTextEditor(), null);
        this.myArgumentsEditor = NpmRunConfigurationEditor.createArgumentsEditor();
        this.myNodeInterpreterField = new NodeJsInterpreterField(project);
        this.myNodeOptionsEditor = new RawCommandLineEditor().withMonospaced(false);
        this.myPackageManagerPackageField = NpmUtil.createPackageManagerPackageField(this.myNodeInterpreterField, false);
        this.myCommandField = NpmRunConfigurationEditor.createCommandField(this.myPackageManagerPackageField);
        this.myScriptsField = NpmRunConfigurationEditor.createScriptsField(project, this.myPackageJsonField, this.myCommandField);
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        JLabel nodeInterpreterLabel = NpmRunConfigurationEditor.createNodeJsInterpreterLabel(this.myNodeInterpreterField);
        this.myPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(JavaScriptBundle.message("npm.rc.packageJson.label", new Object[0]), (JComponent)this.myPackageJsonField).addLabeledComponent(JavaScriptBundle.message("npm.rc.command.label", new Object[0]), ComponentWithEmptyBrowseButton.wrap(this.myCommandField)).addLabeledComponent(JavaScriptBundle.message("npm.rc.scripts.label", new Object[0]), ComponentWithEmptyBrowseButton.wrap(this.myScriptsField)).addLabeledComponent(JavaScriptBundle.message("npm.rc.scriptsArguments.label", new Object[0]), (JComponent)this.myArgumentsEditor).addComponent((JComponent)new JSeparator(), 8).addLabeledComponent((JComponent)nodeInterpreterLabel, (JComponent)((Object)this.myNodeInterpreterField), 8).addLabeledComponent(JavaScriptBundle.message("npm.rc.nodeOptions.label", new Object[0]), (JComponent)this.myNodeOptionsEditor).addLabeledComponent(NpmUtil.getPackageManagerPackageFieldLabelText(), (JComponent)((Object)this.myPackageManagerPackageField)).addLabeledComponent(JavaScriptBundle.message("npm.rc.environmentVariables.label", new Object[0]), (JComponent)this.myEnvVarsComponent).getPanel();
        this.hideInterpreterIfBunPackageManager(project, nodeInterpreterLabel);
    }

    private void hideInterpreterIfBunPackageManager(@NotNull Project project, @NotNull JLabel nodeInterpreterLabel) {
        if (project == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        if (nodeInterpreterLabel == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        this.myPackageManagerPackageField.addPackageRefSelectionListener((Consumer<NodePackageRef>)((Consumer)npmPkgRef -> {
            NodePackageRef derefNpmPkgRef = this.myPackageManagerPackageField.getDescriptor().dereferenceIfProjectRef(project, (NodePackageRef)npmPkgRef);
            boolean isBun = NpmUtil.isBunPackageRef(derefNpmPkgRef);
            nodeInterpreterLabel.setVisible(!isBun);
            this.myNodeInterpreterField.setVisible(!isBun);
        }));
    }

    @NotNull
    private static JLabel createNodeJsInterpreterLabel(@NotNull NodeJsInterpreterField component) {
        if (component == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        JLabel label = new JLabel(UIUtil.replaceMnemonicAmpersand((String)JavaScriptBundle.message("npm.rc.nodeInterpreter.label", new Object[0])));
        label.setLabelFor((Component)((Object)component));
        JLabel jLabel = label;
        if (jLabel == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        return jLabel;
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createPackageJsonField(@NotNull Project project) {
        if (project == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(JavaScriptBundle.message("npm.rc.packageJson.browseDialogTitle", new Object[0]));
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (FileChooserDescriptor)descriptor, () -> {
            List<VirtualFile> packageJsonFiles = NpmScriptsService.getInstance(project).detectAllBuildfiles();
            return packageJsonFiles.stream().map(packageJson -> FileUtil.toSystemDependentName((String)packageJson.getPath())).sorted().collect(Collectors.toList());
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(6);
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    private static ComboBox<NpmCommand> createCommandField(@NotNull NodePackageField packageManagerPackageField) {
        if (packageManagerPackageField == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(7);
        }
        ComboBox comboBox = new ComboBox();
        Ref lastYarn = Ref.create((Object)false);
        NpmRunConfigurationEditor.updateCommandField((ComboBox<NpmCommand>)comboBox, false);
        packageManagerPackageField.addSelectionListener((Consumer<NodePackage>)((Consumer)npmPkg -> {
            boolean yarn = NpmUtil.isYarnAlikePackage(npmPkg);
            if (yarn != (Boolean)lastYarn.get()) {
                lastYarn.set((Object)yarn);
                NpmRunConfigurationEditor.updateCommandField((ComboBox<NpmCommand>)comboBox, yarn);
            }
        }));
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(8);
        }
        return comboBox2;
    }

    private static void updateCommandField(@NotNull ComboBox<NpmCommand> commandComboBox, boolean yarn) {
        if (commandComboBox == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(9);
        }
        HashMap<String, NpmCommand> map2 = new HashMap<String, NpmCommand>();
        for (NpmCommand command2 : NpmCommand.getCommands(yarn)) {
            String cliOption = command2.getCliOption(yarn);
            if (map2.containsKey(cliOption) && !StringUtil.equalsIgnoreCase((CharSequence)command2.name(), (CharSequence)cliOption)) continue;
            map2.put(cliOption, command2);
        }
        ArrayList<NpmCommand> commands = new ArrayList<NpmCommand>(map2.values());
        commands.sort(Comparator.comparing(o -> o.getCliOption(yarn)));
        NpmRunConfigurationEditor.setNpmCommands(commandComboBox, commands);
        commandComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", command -> command.getCliOption(yarn)));
    }

    @NotNull
    private static TextFieldWithHistory createScriptsField(@NotNull Project project, @NotNull TextFieldWithHistoryWithBrowseButton packageJsonField, final @NotNull ComboBox<NpmCommand> commandField) {
        if (project == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(10);
        }
        if (packageJsonField == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(11);
        }
        if (commandField == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(12);
        }
        final TextFieldWithHistory field = NpmRunConfigurationEditor.createRunScriptsField(project, () -> PathShortener.getAbsolutePath((JTextField)((TextFieldWithHistory)packageJsonField.getChildComponent()).getTextEditor()));
        commandField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                field.setEnabled(commandField.getSelectedItem() == NpmCommand.RUN_SCRIPT);
            }
        });
        TextFieldWithHistory textFieldWithHistory = field;
        if (textFieldWithHistory == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(13);
        }
        return textFieldWithHistory;
    }

    @NotNull
    public static TextFieldWithHistory createRunScriptsField(final @NotNull Project project, final @NotNull Supplier<String> packageJsonPath) {
        if (project == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(14);
        }
        if (packageJsonPath == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(15);
        }
        final TextFieldWithHistory field = new TextFieldWithHistory();
        field.setMinimumAndPreferredWidth(0);
        field.setHistorySize(-1);
        JsbtUtil.enableExpandingWithLazyHistoryLoading(field);
        final Ref lastPackageJsonRef = Ref.create();
        field.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                VirtualFile packageJson = LocalFileSystem.getInstance().findFileByPath((String)packageJsonPath.get());
                if (packageJson == null || !packageJson.isValid() || packageJson.isDirectory()) {
                    SwingHelper.setHistory((TextFieldWithHistory)field, Collections.emptyList(), (boolean)false);
                    lastPackageJsonRef.set(null);
                    return;
                }
                if (packageJson.equals(lastPackageJsonRef.get())) {
                    return;
                }
                lastPackageJsonRef.set((Object)packageJson);
                try {
                    NpmScriptsStructure structure = NpmScriptsService.getInstance(project).fetchBuildfileStructure(packageJson);
                    SwingHelper.setHistory((TextFieldWithHistory)field, JsbtUtil.encodeNames(structure.getTaskNames()), (boolean)false);
                }
                catch (JsbtTaskFetchException ex) {
                    LOG.warn((Throwable)ex);
                    SwingHelper.setHistory((TextFieldWithHistory)field, Collections.emptyList(), (boolean)false);
                }
            }
        });
        TextFieldWithHistory textFieldWithHistory = field;
        if (textFieldWithHistory == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(16);
        }
        return textFieldWithHistory;
    }

    @NotNull
    public static RawCommandLineEditor createArgumentsEditor() {
        RawCommandLineEditor editor = new RawCommandLineEditor().withMonospaced(false);
        CommonProgramParametersPanel.addMacroSupport((ExtendableTextField)editor.getEditorField());
        RawCommandLineEditor rawCommandLineEditor = editor;
        if (rawCommandLineEditor == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(17);
        }
        return rawCommandLineEditor;
    }

    protected void resetEditorFrom(@NotNull NpmRunConfiguration configuration) {
        if (configuration == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(18);
        }
        this.resetEditorFrom(configuration.getRunSettings());
    }

    public void resetEditorFrom(@NotNull NpmRunSettings runSettings) {
        if (runSettings == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(19);
        }
        this.myNodeInterpreterField.setInterpreterRef(runSettings.getInterpreterRef());
        this.myPackageJsonField.setTextAndAddToHistory(FileUtil.toSystemDependentName((String)runSettings.getPackageJsonSystemIndependentPath()));
        this.myPackageManagerPackageField.setSelectedRef(runSettings.getPackageManagerPackageRef());
        this.setNpmCommand(runSettings.getCommand());
        this.myScriptsField.setTextAndAddToHistory(ParametersListUtil.join(runSettings.getScriptNames()));
        this.myArgumentsEditor.setText(runSettings.getArguments());
        this.myNodeOptionsEditor.setText(runSettings.getNodeOptions());
        this.myEnvVarsComponent.setData(runSettings.getEnvData());
        DialogWrapper wrapper = DialogWrapper.findInstance((Component)this.myPanel);
        if (wrapper instanceof SingleConfigurableEditor || wrapper instanceof NpmBeforeRunTaskDialog) {
            this.myNodeInterpreterField.setPreferredWidthToFitText();
            this.myPackageManagerPackageField.setPreferredWidthToFitText();
            SwingHelper.resizeDialogToFitTextFor((JComponent[])new JComponent[]{this.myPackageJsonField});
        }
    }

    private void setNpmCommand(@NotNull NpmCommand command) {
        if (command == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(20);
        }
        this.myCommandField.setSelectedItem((Object)command);
        if (!command.equals(this.myCommandField.getSelectedItem())) {
            ArrayList<NpmCommand> commands = new ArrayList<NpmCommand>(NpmRunConfigurationEditor.getElements(this.myCommandField.getModel()));
            if (commands.contains((Object)command)) {
                LOG.error("Command list should not contain " + String.valueOf((Object)command) + ", list: " + String.valueOf(commands));
                return;
            }
            commands.add(command);
            NpmRunConfigurationEditor.setNpmCommands(this.myCommandField, commands);
            this.myCommandField.setSelectedItem((Object)command);
            if (!command.equals(this.myCommandField.getSelectedItem())) {
                LOG.error("Cannot set command to " + String.valueOf((Object)command) + ", list: " + String.valueOf(commands));
            }
        }
    }

    private static void setNpmCommands(@NotNull ComboBox<NpmCommand> commandField, @NotNull List<NpmCommand> commands) {
        if (commandField == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(21);
        }
        if (commands == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(22);
        }
        NpmCommand selectedCommand = (NpmCommand)((Object)ObjectUtils.tryCast((Object)commandField.getSelectedItem(), NpmCommand.class));
        ContainerUtil.addIfNotNull(commands, (Object)((Object)selectedCommand));
        DefaultComboBoxModel<NpmCommand> model = new DefaultComboBoxModel<NpmCommand>(commands.toArray(new NpmCommand[0]));
        model.setSelectedItem((Object)selectedCommand);
        commandField.setModel(model);
    }

    @NotNull
    private static <E> List<E> getElements(@NotNull ListModel<E> model) {
        if (model == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(23);
        }
        ArrayList result2 = new ArrayList(model.getSize());
        for (int i = 0; i < model.getSize(); ++i) {
            ContainerUtil.addIfNotNull(result2, model.getElementAt(i));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    protected void applyEditorTo(@NotNull NpmRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(25);
        }
        configuration.setRunSettings(this.getCurrentSettings());
    }

    @NotNull
    public NpmRunSettings getCurrentSettings() {
        NpmRunSettings.Builder builder2 = NpmRunSettings.builder();
        builder2.setPackageJsonPath(PathShortener.getAbsolutePath((JTextField)((TextFieldWithHistory)this.myPackageJsonField.getChildComponent()).getTextEditor()));
        NpmCommand command = (NpmCommand)((Object)this.myCommandField.getSelectedItem());
        if (command == null) {
            LOG.error("null command, commands: " + String.valueOf(NpmRunConfigurationEditor.getElements(this.myCommandField.getModel())));
            command = NpmCommand.INSTALL;
        }
        builder2.setCommand(command);
        builder2.setScriptNames(ParametersListUtil.parse((String)StringUtil.notNullize((String)this.myScriptsField.getText()), (boolean)false));
        builder2.setArguments(this.myArgumentsEditor.getText());
        builder2.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder2.setNodeOptions(this.myNodeOptionsEditor.getText());
        builder2.setPackageManagerPackageRef(this.myPackageManagerPackageField.getSelectedRef());
        builder2.setEnvData(this.myEnvVarsComponent.getData());
        NpmRunSettings npmRunSettings = builder2.build();
        if (npmRunSettings == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(26);
        }
        return npmRunSettings;
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            NpmRunConfigurationEditor.$$$reportNull$$$0(27);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 8, 13, 16, 17, 24, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeInterpreterLabel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagerPackageField";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandComboBox";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonField";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandField";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonPath";
                break;
            }
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeJsInterpreterLabel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageJsonField";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandField";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createScriptsField";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunScriptsField";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentsEditor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSettings";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hideInterpreterIfBunPackageManager";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNodeJsInterpreterLabel";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 24: 
            case 26: 
            case 27: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPackageJsonField";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCommandField";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateCommandField";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createScriptsField";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createRunScriptsField";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setNpmCommand";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setNpmCommands";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 8, 13, 16, 17, 24, 26, 27 -> new IllegalStateException(string);
        };
    }
}

