/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.actionscript.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSConditionalCompileVariableReference;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSUseNamespaceDirective;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptAttributeListImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageStatementImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionScriptPsiImplUtil {
    private static final TokenSet ourTypeFilter = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.REFERENCE_EXPRESSION}), JSDocumentationUtils.ourPrimitiveTypeFilter});
    private static final ResolveProcessor.ProcessingOptions ourNsProcessingOptions = new JSResolveUtil.StructureProcessingOptions(){

        @Override
        public boolean toProcessPackageImports(PsiElement lastParent, JSPackageStatementImpl packageStatement) {
            return lastParent != null;
        }
    };

    @Nullable
    public static PsiElement getTypeElementFromDeclaration(JSElement element2) {
        ASTNode myNode = element2.getNode();
        ASTNode node = myNode.findChildByType(JSTokenTypes.COLON);
        if (node != null) {
            ASTNode typeNode = myNode.findChildByType(ourTypeFilter, node);
            return typeNode != null ? typeNode.getPsi() : null;
        }
        return null;
    }

    public static boolean isDeprecatedFromAttribute(@NotNull JSAttributeListOwner owner) {
        JSAttribute deprecatedAttr;
        JSAttributeList attributeList;
        if (owner == null) {
            ActionScriptPsiImplUtil.$$$reportNull$$$0(0);
        }
        return (attributeList = owner.getAttributeList()) != null && (deprecatedAttr = attributeList.findAttributeByName("Deprecated")) != null;
    }

    public static void updateFileName(JSQualifiedNamedElement jsClassBase, String newName, String oldName) throws IncorrectOperationException {
        VirtualFile virtualFile;
        PsiFile containingFile = jsClassBase.getContainingFile();
        if (containingFile.getContext() == null && (virtualFile = containingFile.getVirtualFile()) != null && virtualFile.getNameWithoutExtension().equals(oldName)) {
            String s = containingFile.getName();
            containingFile.setName(newName + "." + s.substring(s.lastIndexOf(46) + 1));
        }
    }

    @Nullable
    public static String getNamespace(@Nullable JSAttributeList attributeList) {
        return attributeList instanceof ActionScriptAttributeListImpl ? ((ActionScriptAttributeListImpl)attributeList).getNamespace() : null;
    }

    @Nullable
    public static JSConditionalCompileVariableReference getConditionalCompileVariableReference(@Nullable JSAttributeList attributeList) {
        return attributeList instanceof ActionScriptAttributeListImpl ? ((ActionScriptAttributeListImpl)attributeList).getConditionalCompileVariableReference() : null;
    }

    @Nullable
    public static JSReferenceExpression getNamespaceElement(@Nullable JSAttributeList attributeList) {
        return attributeList instanceof ActionScriptAttributeListImpl ? ((ActionScriptAttributeListImpl)attributeList).getNamespaceElement() : null;
    }

    @Nullable
    public static String resolveNamespaceValue(@Nullable JSAttributeList attributeList) {
        return attributeList instanceof ActionScriptAttributeListImpl ? ((ActionScriptAttributeListImpl)attributeList).resolveNamespaceValue() : null;
    }

    @Nullable
    public static String calcNamespaceReference(PsiElement element2) {
        String nsName = null;
        PsiElement startFrom = null;
        if (element2 instanceof ActionScriptAttributeListImpl) {
            String s = ((ActionScriptAttributeListImpl)element2).tryResolveNamespaceValueFromStub();
            if (s != null) {
                return s;
            }
            nsName = ActionScriptPsiImplUtil.getNamespace((JSAttributeList)element2);
            startFrom = JSResolveUtil.findParent(element2.getParent());
        } else if (element2 instanceof JSReferenceExpression) {
            namespaceElement = ((JSReferenceExpression)element2).getNamespaceElement();
            if (namespaceElement == null) {
                return null;
            }
            nsName = namespaceElement.getReferenceName();
        } else if (element2 instanceof JSUseNamespaceDirective) {
            namespaceElement = ((JSUseNamespaceDirective)element2).getNamespaceReference();
            if (namespaceElement == null) {
                return null;
            }
            nsName = namespaceElement.getReferenceName();
        }
        if (nsName == null) {
            return null;
        }
        final Ref nsValueCalculated = new Ref();
        ActionScriptResolveUtil.StructureResolveProcessor processor = new ActionScriptResolveUtil.StructureResolveProcessor(nsName){
            {
                super(name);
                this.setLocalResolve(false);
                this.setForceImportsForPlace(true);
                this.setProcessingOptions(ourNsProcessingOptions);
            }

            public boolean execute(@NotNull PsiElement element2, @NotNull ResolveState state) {
                if (element2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                String nsValue = null;
                if (element2 instanceof JSNamespaceDeclaration) {
                    nsValue = ((JSNamespaceDeclaration)element2).getInitialValueString();
                    if (nsValue == null) {
                        nsValue = ((JSNamespaceDeclaration)element2).getName();
                    }
                } else if (element2 instanceof JSVariable) {
                    JSVariable var = (JSVariable)element2;
                    nsValue = var.isConst() ? var.getLiteralOrReferenceInitializerText() : "-\"-";
                }
                if (nsValue != null) {
                    nsValueCalculated.set((Object)StringUtil.unquoteString((String)nsValue));
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/actionscript/psi/ActionScriptPsiImplUtil$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        PsiElement context2 = startFrom != null ? startFrom : element2;
        ActionScriptResolveUtil.walkOverStructure(context2, processor);
        String result2 = (String)nsValueCalculated.get();
        if ("-\"-".equals(result2)) {
            return null;
        }
        if (result2 == null) {
            result2 = nsName;
        }
        return result2;
    }

    @Nullable
    public static String getNamespaceValue(JSAttributeList attributeList) {
        if (attributeList == null) {
            return null;
        }
        String namespace_id = ActionScriptPsiImplUtil.getNamespace(attributeList);
        if (namespace_id == null) {
            return null;
        }
        return ActionScriptPsiImplUtil.resolveNamespaceValue(attributeList);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/lang/actionscript/psi/ActionScriptPsiImplUtil", "isDeprecatedFromAttribute"));
    }
}

