/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.sampling.method;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.builder.sampling.PointSampling;
import org.jetbrains.letsPlot.core.plot.builder.sampling.method.SamplingBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u00012\u00020\u0002:\u0001\u0011B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/SystematicSampling;", "Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/SamplingBase;", "Lorg/jetbrains/letsPlot/core/plot/builder/sampling/PointSampling;", "sampleSize", "", "(I)V", "expressionText", "", "getExpressionText", "()Ljava/lang/String;", "apply", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "population", "computeStep", "popSize", "isApplicable", "", "Companion", "plot-builder"})
public final class SystematicSampling
extends SamplingBase
implements PointSampling {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ALIAS = "systematic";

    public SystematicSampling(int sampleSize) {
        super(sampleSize);
    }

    @Override
    @NotNull
    public String getExpressionText() {
        return "sampling_systematic(n=" + this.getSampleSize() + ')';
    }

    @Override
    public boolean isApplicable(@NotNull DataFrame population) {
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        return super.isApplicable(population) && this.computeStep(population.rowCount()) >= 2;
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame population) {
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        if (!this.isApplicable(population)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int popSize = population.rowCount();
        int step2 = this.computeStep(popSize);
        ArrayList<Integer> pickedIndices = new ArrayList<Integer>();
        for (int i = 0; i < popSize; i += step2) {
            pickedIndices.add(i);
        }
        return population.selectIndices((List<Integer>)pickedIndices);
    }

    private final int computeStep(int popSize) {
        return (int)Math.rint((double)popSize / (double)(this.getSampleSize() - 1));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/SystematicSampling$Companion;", "", "()V", "ALIAS", "", "computeStep", "", "popSize", "sampleSize", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        public final int computeStep(int popSize, int sampleSize) {
            return (int)Math.rint((double)(popSize - 1) / (double)(sampleSize - 1));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

