/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.http.client;

import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.HttpClientBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class HttpClientBuilderLoader {
    public static HttpClientBuilder loadHttpClientBuilder() {
        Collection factories = ServiceHelper.loadFactories(HttpClientBuilderFactory.class);
        if (factories.size() > 1) {
            List<String> factoryNames = factories.stream().map(factory -> factory.getClass().getName()).toList();
            throw new IllegalStateException(String.format("Conflict: multiple HTTP clients have been found in the classpath: %s. Please explicitly specify the one you wish to use.", factoryNames));
        }
        Iterator iterator = factories.iterator();
        if (iterator.hasNext()) {
            HttpClientBuilderFactory factory2 = (HttpClientBuilderFactory)iterator.next();
            return factory2.create();
        }
        throw new IllegalStateException("No HTTP client has been found in the classpath");
    }
}

