/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DefinitionProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseDefinitionHelper {
    @NotNull
    public static StringBuilder generateDefinition(@NotNull DbElement element, @NotNull StringBuilder sb) {
        if (element == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(0);
        }
        if (sb == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(1);
        }
        Project project = element.getProject();
        BasicElement e = DbImplUtilCore.getMaybeBasicElement((DasObject)element);
        if (e != null) {
            CodeStyleSettings settings = SqlCodeStyles.getSettings((Project)project, (String)ScriptingTaskBuilderKt.getCodeStyleName((DasDataSource)element.getDataSource()));
            CharSequence def = DatabaseDefinitionHelper.generateDefinitionUsingScriptingService(project, e, settings);
            sb.append(def);
        } else {
            sb.append("-- Unexpected: ").append(element.getDelegate().getClass().getSimpleName()).append("\n");
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(2);
        }
        return stringBuilder;
    }

    @NotNull
    public static CharSequence generateDefinitionUsingScriptingService(@NotNull Project project, @NotNull BasicElement element, @Nullable CodeStyleSettings settings) {
        String src;
        if (project == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(3);
        }
        if (element == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(4);
        }
        ProgressManager.checkCanceled();
        BasicModel model = element.getModel();
        if (model == null) {
            return "-- no model\n";
        }
        ScriptingSingleModelTaskBuilder taskBuilder = new ScriptingSingleModelTaskBuilder(model, ScriptCategory.CREATE_DEFINITION);
        taskBuilder.getElements().add(element);
        BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.getSearchPathObject((DatabaseDialectEx)DbImplUtilCore.getDatabaseDialect((Dbms)model.getDbms()), (DasObject)element), BasicNamespace.class);
        taskBuilder.setCurrentNamespace(namespace);
        if (settings != null) {
            taskBuilder.setCodeStyle(settings);
        }
        ScriptingSingleModelTask scriptingTask = taskBuilder.build();
        ScriptGenerator scriptGenerator = ScriptGenerators.INSTANCE.byModel(model);
        ScriptingResult result = scriptGenerator.makeScript(project, (ScriptingTask)scriptingTask);
        boolean empty = JBIterable.from((Iterable)result.getScriptStatements()).flatten(CompositeText::getFragments).filter(f -> f.getKind() != CompositeText.Kind.COMMENT || f.getError() == null).isEmpty();
        String string = src = empty ? "" : result.getScriptText();
        if (src.isEmpty()) {
            src = "-- No source text available\n";
        }
        String string2 = src;
        if (string2 == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    public static StringBuilder loadDefinition(@NotNull DbElement element, @NotNull StringBuilder sb) throws Exception {
        if (element == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(6);
        }
        if (sb == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(7);
        }
        return DatabaseDefinitionHelper.loadDefinition(ConnectionProvider.forElement(element, (DatabaseDepartment)DGDepartment.INTROSPECTION), element, sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static StringBuilder loadDefinition(@NotNull ConnectionProvider provider, @NotNull DbElement element, @NotNull StringBuilder sb) throws Exception {
        if (provider == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(8);
        }
        if (element == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(9);
        }
        if (sb == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(10);
        }
        if (!provider.acquire()) {
            Exception exception = provider.getLastException();
            if (exception != null) {
                throw exception;
            }
            StringBuilder stringBuilder = sb;
            StringBuilder stringBuilder2 = stringBuilder;
            if (stringBuilder2 == null) {
                DatabaseDefinitionHelper.$$$reportNull$$$0(11);
            }
            return stringBuilder2;
        }
        StringBuilder stringBuilder = DatabaseDefinitionHelper.loadDefinitionImpl(provider, element, sb);
        StringBuilder stringBuilder3 = stringBuilder;
        if (stringBuilder3 == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(12);
        }
        return stringBuilder3;
        finally {
            provider.release();
        }
    }

    @NotNull
    private static StringBuilder loadDefinitionImpl(@NotNull ConnectionProvider provider, DbElement element, @NotNull StringBuilder sb) throws Exception {
        if (provider == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(13);
        }
        if (sb == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(14);
        }
        DatabaseDefinitionHelper.tryLoadObjectDefinition(provider, element, sb);
        if (!sb.isEmpty() && sb.charAt(sb.length() - 1) != '\n') {
            sb.append('\n');
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(15);
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryLoadObjectDefinition(ConnectionProvider provider, @Nullable DbElement element, StringBuilder sb) throws Exception {
        if (element == null) {
            return;
        }
        Dbms dbms = element.getDataSource().getDbms();
        DefinitionProvider definitionProvider = (DefinitionProvider)DefinitionProvider.EP.forDbms(dbms);
        if (!definitionProvider.isSupported((DasObject)element)) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            DatabaseConnection connection2 = provider.getConnection();
            if (connection2 == null) {
                return;
            }
            definitionProvider.load(Collections.singleton(element), (DatabaseConnectionCore)connection2, sb);
        }
        finally {
            provider.release();
        }
    }

    public static boolean isRawDefinitionAvailable(@Nullable DbElement element) {
        if (element == null || !DbImplUtilCore.canConnectTo((DbElement)element)) {
            return false;
        }
        Dbms dbms = DbImplUtilCore.getDbms((DbElement)element);
        DefinitionProvider provider = (DefinitionProvider)DefinitionProvider.EP.forDbms(dbms);
        return provider.isSupported((DasObject)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 11, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DatabaseDefinitionHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DatabaseDefinitionHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDefinitionUsingScriptingService";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefinition";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefinitionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateDefinition";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateDefinitionUsingScriptingService";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadDefinition";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadDefinitionImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 11, 12, 15 -> new IllegalStateException(string);
        };
    }
}

