/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.NameColumnRef;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.dialects.mongo.MongoScriptUtilKt;
import com.intellij.database.dialects.mongo.generator.dml.UtilKt;
import com.intellij.database.model.DasObject;
import com.intellij.database.script.generator.dml.ColumnRefs;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.ExpressionColumn;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.QueryColumns;
import com.intellij.database.script.generator.dml.SelectGenerationResult;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/mongo/generator/dml/MongoSelectGenerator;", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "Lcom/intellij/database/script/generator/dml/SelectGenerationResult;", "Lcom/intellij/database/script/generator/dml/SelectTask;", "task", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/script/generator/dml/SelectTask;Lcom/intellij/database/Dbms;)V", "generate", "generateFind", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "generateAggregate", "selectColumns", "columns", "", "Lcom/intellij/database/data/types/ColumnRef;", "intellij.database.dialects.mongo"})
@SourceDebugExtension(value={"SMAP\nMongoSelectGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoSelectGenerator.kt\ncom/intellij/database/dialects/mongo/generator/dml/MongoSelectGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1563#2:113\n1634#2,3:114\n1563#2:117\n1634#2,3:118\n1761#2,3:121\n*S KotlinDebug\n*F\n+ 1 MongoSelectGenerator.kt\ncom/intellij/database/dialects/mongo/generator/dml/MongoSelectGenerator\n*L\n80#1:113\n80#1:114,3\n88#1:117\n88#1:118,3\n105#1:121,3\n*E\n"})
public final class MongoSelectGenerator
extends DmlGenerator<SelectGenerationResult, SelectTask> {
    @NotNull
    private final Dbms dbms;

    public MongoSelectGenerator(@NotNull SelectTask task, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super((DmlTask)task);
        this.dbms = dbms;
    }

    @NotNull
    public SelectGenerationResult generate() {
        DdlBuilder builder = ((SelectTask)this.getTask()).getOutput();
        DasObject table = ((SelectTask)this.getTask()).getTable();
        DmlUtilKt.newLine((DdlBuilder)UtilKt.dbCollection(this.dbms, builder, table), (boolean)((SelectTask)this.getTask()).getInsertNewLines()).symbol(".");
        if (((SelectTask)this.getTask()).getExpressionColumns().isEmpty()) {
            this.generateFind(builder);
        } else {
            this.generateAggregate(builder);
        }
        return new SelectGenerationResult(builder, null, null, 6, null);
    }

    private final void generateFind(DdlBuilder builder) {
        DdlBuilder ddlBuilder = builder.plain("find");
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"plain(...)");
        MongoScriptUtilKt.inParenth$default(ddlBuilder, false, () -> MongoSelectGenerator.generateFind$lambda$0(this, builder), 1, null);
        OrderBy orderBy = ((SelectTask)this.getTask()).getOrderBy();
        if (orderBy != null) {
            OrderBy it = orderBy;
            boolean bl = false;
            UtilKt.generateOrderBy(this.dbms, it, builder, true, ((SelectTask)this.getTask()).getInsertNewLines());
        }
        if (((SelectTask)this.getTask()).getOffset() > 0) {
            DdlBuilder ddlBuilder2 = DmlUtilKt.newLine((DdlBuilder)builder, (boolean)((SelectTask)this.getTask()).getInsertNewLines()).symbol(".").plain("skip");
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder2, (String)"plain(...)");
            MongoScriptUtilKt.inParenth$default(ddlBuilder2, false, () -> MongoSelectGenerator.generateFind$lambda$2(builder, this), 1, null);
        }
        if (((SelectTask)this.getTask()).getLimit() > 0) {
            DdlBuilder ddlBuilder3 = DmlUtilKt.newLine((DdlBuilder)builder, (boolean)((SelectTask)this.getTask()).getInsertNewLines()).symbol(".").plain("limit");
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder3, (String)"plain(...)");
            MongoScriptUtilKt.inParenth$default(ddlBuilder3, false, () -> MongoSelectGenerator.generateFind$lambda$3(builder, this), 1, null);
        }
    }

    private final void generateAggregate(DdlBuilder builder) {
        DdlBuilder $this$generateAggregate_u24lambda_u2416 = builder;
        boolean bl = false;
        DdlBuilder ddlBuilder = $this$generateAggregate_u24lambda_u2416.plain("aggregate");
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"plain(...)");
        MongoScriptUtilKt.inParenth$default(ddlBuilder, false, () -> MongoSelectGenerator.generateAggregate$lambda$16$lambda$15($this$generateAggregate_u24lambda_u2416, this, builder), 1, null);
    }

    private final void selectColumns(DdlBuilder builder, List<? extends ColumnRef> columns) {
        builder.symbol(",").space();
        MongoScriptUtilKt.inCurly$default(builder, false, false, () -> MongoSelectGenerator.selectColumns$lambda$18(columns, builder, this), 3, null);
    }

    private static final Unit generateFind$lambda$0(MongoSelectGenerator this$0, DdlBuilder $builder) {
        UtilKt.generateWhere(this$0.dbms, ((SelectTask)this$0.getTask()).getWhereClause(), $builder, this$0.getTask());
        QueryColumns columns = ((SelectTask)this$0.getTask()).getColumns();
        if (columns instanceof ColumnRefs && !((Collection)((ColumnRefs)columns).getColumns()).isEmpty()) {
            this$0.selectColumns($builder, ((ColumnRefs)columns).getColumns());
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateFind$lambda$2(DdlBuilder $builder, MongoSelectGenerator this$0) {
        $builder.number(((SelectTask)this$0.getTask()).getOffset());
        return Unit.INSTANCE;
    }

    private static final Unit generateFind$lambda$3(DdlBuilder $builder, MongoSelectGenerator this$0) {
        $builder.number(((SelectTask)this$0.getTask()).getLimit());
        return Unit.INSTANCE;
    }

    private static final Unit generateAggregate$lambda$16$lambda$15$lambda$14$lambda$4(DdlBuilder $this_with, MongoSelectGenerator this$0, DdlBuilder $builder) {
        $this_with.identifier("$match").symbol(":").space();
        UtilKt.generateWhere(this$0.dbms, ((SelectTask)this$0.getTask()).getWhereClause(), $builder, this$0.getTask());
        return Unit.INSTANCE;
    }

    private static final Unit generateAggregate$lambda$16$lambda$15$lambda$14$lambda$6$lambda$5(DdlBuilder $this_with, MongoSelectGenerator this$0, OrderBy $it, DdlBuilder $builder) {
        $this_with.identifier("$sort").symbol(":").space();
        UtilKt.generateOrderBy(this$0.dbms, $it, $builder, false, ((SelectTask)this$0.getTask()).getInsertNewLines());
        return Unit.INSTANCE;
    }

    private static final Unit generateAggregate$lambda$16$lambda$15$lambda$14$lambda$7(DdlBuilder $this_with, MongoSelectGenerator this$0) {
        $this_with.identifier("$skip").symbol(":").space().number(((SelectTask)this$0.getTask()).getOffset());
        return Unit.INSTANCE;
    }

    private static final Unit generateAggregate$lambda$16$lambda$15$lambda$14$lambda$8(DdlBuilder $this_with, MongoSelectGenerator this$0) {
        $this_with.identifier("$limit").symbol(":").space().number(((SelectTask)this$0.getTask()).getLimit());
        return Unit.INSTANCE;
    }

    private static final Unit generateAggregate$lambda$16$lambda$15$lambda$14$lambda$11$lambda$10$lambda$9(DdlBuilder $this_with, ExpressionColumn $ec) {
        String string = $ec.getAlias();
        if (string == null) {
            string = $ec.getExpr();
        }
        $this_with.identifier(string).symbol(":").space().plain($ec.getExpr());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateAggregate$lambda$16$lambda$15$lambda$14$lambda$11(DdlBuilder $this_with, MongoSelectGenerator this$0) {
        Collection<Function0> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        $this_with.identifier("$addFields").symbol(":").space();
        Iterable iterable = ((SelectTask)this$0.getTask()).getExpressionColumns();
        boolean bl = false;
        DdlBuilder ddlBuilder = $this_with;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void ec;
            ExpressionColumn expressionColumn = (ExpressionColumn)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(() -> MongoSelectGenerator.generateAggregate$lambda$16$lambda$15$lambda$14$lambda$11$lambda$10$lambda$9($this_with, (ExpressionColumn)ec));
        }
        collection = (List)destination$iv$iv;
        MongoScriptUtilKt.inCurly(ddlBuilder, bl, (List<? extends Function0<Unit>>)collection);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateAggregate$lambda$16$lambda$15$lambda$14$lambda$13(DdlBuilder $this_with, MongoSelectGenerator this$0, DdlBuilder $builder, QueryColumns $columns) {
        Collection<NameColumnRef> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        $this_with.symbol(", ").identifier("$project").symbol(":").space();
        Iterable iterable = ((SelectTask)this$0.getTask()).getExpressionColumns();
        Collection collection2 = ((ColumnRefs)$columns).getColumns();
        DdlBuilder ddlBuilder = $builder;
        MongoSelectGenerator mongoSelectGenerator = this$0;
        boolean $i$f$map = false;
        void var6_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExpressionColumn expressionColumn = (ExpressionColumn)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getAlias();
            if (string == null) {
                string = it.getExpr();
            }
            collection.add(new NameColumnRef(string));
        }
        collection = (List)destination$iv$iv;
        mongoSelectGenerator.selectColumns(ddlBuilder, CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        return Unit.INSTANCE;
    }

    private static final Unit generateAggregate$lambda$16$lambda$15$lambda$14(MongoSelectGenerator this$0, DdlBuilder $this_with, DdlBuilder $builder) {
        if (((SelectTask)this$0.getTask()).getWhereClause() != null) {
            MongoScriptUtilKt.inCurly$default($this_with, false, false, () -> MongoSelectGenerator.generateAggregate$lambda$16$lambda$15$lambda$14$lambda$4($this_with, this$0, $builder), 3, null).symbol(", ");
        }
        OrderBy orderBy = ((SelectTask)this$0.getTask()).getOrderBy();
        if (orderBy != null) {
            OrderBy it = orderBy;
            boolean bl = false;
            MongoScriptUtilKt.inCurly$default($this_with, false, false, () -> MongoSelectGenerator.generateAggregate$lambda$16$lambda$15$lambda$14$lambda$6$lambda$5($this_with, this$0, it, $builder), 3, null).symbol(", ");
        }
        if (((SelectTask)this$0.getTask()).getOffset() > 0) {
            MongoScriptUtilKt.inCurly$default($this_with, false, false, () -> MongoSelectGenerator.generateAggregate$lambda$16$lambda$15$lambda$14$lambda$7($this_with, this$0), 3, null).symbol(", ");
        }
        if (((SelectTask)this$0.getTask()).getLimit() > 0) {
            MongoScriptUtilKt.inCurly$default($this_with, false, false, () -> MongoSelectGenerator.generateAggregate$lambda$16$lambda$15$lambda$14$lambda$8($this_with, this$0), 3, null).symbol(", ");
        }
        MongoScriptUtilKt.inCurly$default($this_with, false, false, () -> MongoSelectGenerator.generateAggregate$lambda$16$lambda$15$lambda$14$lambda$11($this_with, this$0), 3, null);
        QueryColumns columns = ((SelectTask)this$0.getTask()).getColumns();
        if (columns instanceof ColumnRefs && !((Collection)((ColumnRefs)columns).getColumns()).isEmpty()) {
            MongoScriptUtilKt.inCurly$default($this_with, false, false, () -> MongoSelectGenerator.generateAggregate$lambda$16$lambda$15$lambda$14$lambda$13($this_with, this$0, $builder, columns), 3, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateAggregate$lambda$16$lambda$15(DdlBuilder $this_with, MongoSelectGenerator this$0, DdlBuilder $builder) {
        MongoScriptUtilKt.inBrackets$default($this_with, false, false, () -> MongoSelectGenerator.generateAggregate$lambda$16$lambda$15$lambda$14(this$0, $this_with, $builder), 3, null);
        return Unit.INSTANCE;
    }

    private static final Unit selectColumns$lambda$18(List $columns, DdlBuilder $builder, MongoSelectGenerator this$0) {
        boolean bl;
        boolean first2;
        block8: {
            first2 = true;
            for (ColumnRef column2 : $columns) {
                if (first2) {
                    first2 = false;
                    v0 = Unit.INSTANCE;
                } else {
                    DdlBuilder ddlBuilder = $builder.symbol(",").space();
                    v0 = ddlBuilder;
                    Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
                }
                $builder.literal(DbImplUtilCore.StringLiteralDecorator.PLAIN.decorate(column2.getName(), this$0.dbms)).symbol(":").space().number(1);
            }
            Iterable $this$any$iv = $columns;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ColumnRef it = (ColumnRef)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)"_id", (Object)it.getName())) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (!bl) {
            if (!first2) {
                $builder.symbol(",").space();
            }
            $builder.literal("'_id'").symbol(":").space().number(0);
        }
        return Unit.INSTANCE;
    }
}

