/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0014J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/bigquery/BigQueryObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "<init>", "()V", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/model/properties/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "getRoutineBodyRange", "source", "buildRoutineSources", "", "obj", "Lcom/intellij/database/model/basic/BasicModSourceAware;", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "intellij.database.dialects.bigquery"})
public final class BigQueryObjectBuilder
extends SqlObjectBuilderImpl {
    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return Intrinsics.areEqual((Object)path.kind, (Object)ObjectKind.ROUTINE) ? this.getRoutineBodyRange(def) : super.getCompactDefinition(path, text, def);
    }

    @Nullable
    protected TextRange getRoutineBodyRange(@Nullable PsiObject source) {
        if (source == null) {
            return null;
        }
        SqlParenthesizedExpression expr = (SqlParenthesizedExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)source), SqlParenthesizedExpression.class);
        if (expr != null) {
            PsiElement body2;
            Class[] classArray = new Class[]{SqlExpression.class, PsiComment.class};
            PsiElement psiElement = body2 = PsiTreeUtil.getChildOfAnyType((PsiElement)((PsiElement)expr), (Class[])classArray);
            return psiElement != null ? psiElement.getTextRange() : null;
        }
        return super.getRoutineBodyRange(source);
    }

    protected void buildRoutineSources(@NotNull BasicModSourceAware obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources(obj, context, () -> BigQueryObjectBuilder.buildRoutineSources$lambda$0(this, source));
    }

    private static final CompositeText buildRoutineSources$lambda$0(BigQueryObjectBuilder this$0, DasObject $source) {
        return (CompositeText)this$0.getRoutineBody($source, CompositeText.Kind.ORIGINAL_TEXT);
    }
}

