/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableForm;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentServersEditor;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsGroupedDeployable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GroupConfigurableForm
extends NamedConfigurable<SettingsGroupedDeployable> {
    private final SettingsGroupedDeployable myGroupedDeployable;
    private final UserDataHolder myDataHolder;
    private JPanel myMainPanel;
    private JBTextField myNameTextField;
    private JBCheckBox myVisibilityCheckBox;
    private JLabel myContextHelpLabel;
    private ActionLink myAddServerLabel;

    GroupConfigurableForm(SettingsGroupedDeployable groupedDeployable, DeploymentServersEditor editor, final @NotNull Runnable updater, UserDataHolder dataHolder, @Nullable Project project) {
        if (updater == null) {
            GroupConfigurableForm.$$$reportNull$$$0(0);
        }
        super(false, null);
        this.myGroupedDeployable = groupedDeployable;
        this.myDataHolder = dataHolder;
        this.$$$setupUI$$$();
        this.myMainPanel.setBorder(DeploymentConfigurableForm.createConfigurableBorder());
        this.myAddServerLabel.setDropDownLinkIcon();
        this.myAddServerLabel.addActionListener(event -> {
            DefaultActionGroup group = new DefaultActionGroup();
            group.add(editor.createAddServerAction(AccessType.FTP, this.myGroupedDeployable));
            group.add(editor.createAddServerAction(AccessType.FTPS, this.myGroupedDeployable));
            group.add(editor.createAddServerAction(AccessType.SFTP, this.myGroupedDeployable));
            group.add(editor.createAddServerAction(AccessType.WEBDAV, this.myGroupedDeployable));
            group.add(editor.createAddServerAction(AccessType.MOUNT, this.myGroupedDeployable));
            group.add(editor.createAddServerAction(AccessType.LOCAL, this.myGroupedDeployable));
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("DeploymentSettings.Group.AddLink", (ActionGroup)group);
            JBPopupMenu.showBelow((Component)this.myAddServerLabel, (JPopupMenu)popupMenu.getComponent());
        });
        this.myNameTextField.setText(groupedDeployable.getName());
        this.myNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                updater.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/ui/config/GroupConfigurableForm$1", "textChanged"));
            }
        });
        this.myVisibilityCheckBox.setVisible(project != null && !project.isDefault());
        this.myVisibilityCheckBox.setEnabled(groupedDeployable.mayChangeLevel());
    }

    public JComponent createOptionsPanel() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        if (!StringUtil.equals((CharSequence)this.myNameTextField.getText(), (CharSequence)this.myGroupedDeployable.getName())) {
            return true;
        }
        return this.myVisibilityCheckBox.isSelected() != this.myGroupedDeployable.isProjectLevel();
    }

    public void apply() throws ConfigurationException {
        String oldName = this.myGroupedDeployable.getName();
        String newName = this.myNameTextField.getText();
        if (oldName != null && oldName.equals(DeploymentServersEditor.getDefaultServerOrGroupName(this.myDataHolder))) {
            DeploymentServersEditor.setDefaultServerOrGroupName(this.myDataHolder, newName);
        }
        this.myGroupedDeployable.setName(newName);
        if (this.myGroupedDeployable.mayChangeLevel()) {
            this.myGroupedDeployable.setIsProjectLevel(this.myVisibilityCheckBox.isSelected());
        }
    }

    public void reset() {
        this.myNameTextField.setText(this.myGroupedDeployable.getName());
        this.myVisibilityCheckBox.setSelected(this.myGroupedDeployable.isProjectLevel());
    }

    private void createUIComponents() {
        this.myContextHelpLabel = ComponentPanelBuilder.createCommentComponent((String)WDBundle.message("group.configurable.empty.description", new Object[0]), (boolean)false);
    }

    public void reloadName() {
        this.myNameTextField.setText(this.myGroupedDeployable.getName());
    }

    public SettingsGroupedDeployable getEditableObject() {
        return this.myGroupedDeployable;
    }

    public String getBannerSlogan() {
        return this.myNameTextField.getText();
    }

    public String getDisplayName() {
        return this.myNameTextField.getText();
    }

    public Icon getIcon(boolean expanded) {
        return AllIcons.Webreferences.Server;
    }

    public String getHelpTopic() {
        return null;
    }

    public void setDisplayName(String name) {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ActionLink actionLink;
        JBCheckBox jBCheckBox;
        JBTextField jBTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = this.myContextHelpLabel;
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 4, 0, 1, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.myNameTextField = jBTextField = new JBTextField();
        jPanel.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, new Dimension(200, -1), null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/WDBundle", GroupConfigurableForm.class).getString("group.configurable.name"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myVisibilityCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/WDBundle", GroupConfigurableForm.class).getString("group.configurable.for.current.project"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAddServerLabel = actionLink = new ActionLink();
        this.$$$loadButtonText$$$((AbstractButton)actionLink, DynamicBundle.getBundle((String)"messages/WDBundle", GroupConfigurableForm.class).getString("group.configurable.add.new.server"));
        jPanel.add((Component)actionLink, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 3, null, null, null));
        jBLabel.setLabelFor((Component)jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/jetbrains/plugins/webDeployment/ui/config/GroupConfigurableForm", "<init>"));
    }
}

