/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.util.FluentBitSet;
import org.apache.commons.vfs2.util.URIBitSets;

public class URIUtils {
    private static final Log LOG = LogFactory.getLog(URIUtils.class);
    private static final String DEFAULT_PROTOCOL_CHARSET = "UTF-8";

    private URIUtils() {
    }

    private static String encode(String unescaped, FluentBitSet allowed, String charset) {
        byte[] rawdata = URLCodecUtils.encodeUrl(allowed, EncodingUtils.getBytes(unescaped, charset));
        return EncodingUtils.getAsciiString(rawdata, 0, rawdata.length);
    }

    public static String encodePath(String unescaped) {
        return URIUtils.encodePath(unescaped, DEFAULT_PROTOCOL_CHARSET);
    }

    public static String encodePath(String unescaped, String charset) {
        if (unescaped == null) {
            throw new IllegalArgumentException("The string to encode may not be null.");
        }
        return URIUtils.encode(unescaped, URIBitSets.ALLOWED_ABS_PATH, charset);
    }

    private static final class URLCodecUtils {
        private static final byte ESCAPE_CHAR = 37;
        private static final FluentBitSet WWW_FORM_URL_SAFE = URIBitSets.bitSet().setInclusive(97, 122).setInclusive(65, 90).setInclusive(48, 57).set(45, 95, 46, 42).set(32);
        private static final int RADIX = 16;

        private URLCodecUtils() {
        }

        static byte[] encodeUrl(FluentBitSet urlsafe, byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            if (urlsafe == null) {
                urlsafe = WWW_FORM_URL_SAFE;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            for (int n : bytes) {
                int b = n;
                if (b < 0) {
                    b = 256 + b;
                }
                if (urlsafe.get(b)) {
                    if (b == 32) {
                        b = 43;
                    }
                    buffer.write(b);
                    continue;
                }
                buffer.write(37);
                char hex1 = URLCodecUtils.hexDigit(b >> 4);
                char hex2 = URLCodecUtils.hexDigit(b);
                buffer.write(hex1);
                buffer.write(hex2);
            }
            return buffer.toByteArray();
        }

        private static char hexDigit(int b) {
            return Character.toUpperCase(Character.forDigit(b & 0xF, 16));
        }
    }

    private static final class EncodingUtils {
        private EncodingUtils() {
        }

        static String getAsciiString(byte[] data, int offset, int length) {
            return new String(data, offset, length, StandardCharsets.US_ASCII);
        }

        static byte[] getBytes(String data, String charsetName) {
            if (data == null) {
                throw new IllegalArgumentException("data may not be null");
            }
            if (StringUtils.isEmpty((CharSequence)charsetName)) {
                throw new IllegalArgumentException("charset may not be null or empty");
            }
            try {
                return data.getBytes(charsetName);
            }
            catch (UnsupportedEncodingException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Unsupported encoding: " + charsetName + ". System encoding used."));
                }
                return data.getBytes(Charset.defaultCharset());
            }
        }
    }
}

