/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDescriptorOwner;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.descriptor.CssCompositeElementDescriptor;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssNavigableDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PseudoSelectorsCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final PseudoSelectorInsertHandler INSERT_HANDLER = new PseudoSelectorInsertHandler();

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PseudoSelectorsCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PseudoSelectorsCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PseudoSelectorsCompletionProvider.$$$reportNull$$$0(2);
        }
        PsiElement position = parameters.getPosition();
        CssPseudoSelector pseudoSelector = (CssPseudoSelector)PsiTreeUtil.getNonStrictParentOfType((PsiElement)position, (Class[])new Class[]{CssPseudoSelector.class});
        int colonsCount = pseudoSelector != null ? pseudoSelector.getColonPrefixLength() : PseudoSelectorsCompletionProvider.calculateColonsCount(parameters.getEditor().getDocument(), position.getTextRange().getStartOffset());
        MultiMap map = MultiMap.create();
        for (CssPseudoSelectorDescriptor cssPseudoSelectorDescriptor : CssDescriptorsUtil.getAllPseudoSelectorDescriptors(position)) {
            map.putValue((Object)(cssPseudoSelectorDescriptor.getId() + cssPseudoSelectorDescriptor.getColonPrefixLength()), (Object)cssPseudoSelectorDescriptor);
        }
        for (Map.Entry entry : map.entrySet()) {
            Set<VirtualFile> importedFiles;
            PsiElement navElement;
            CssElementDescriptor descriptor = CssCompositeElementDescriptor.create((Collection)entry.getValue());
            CssPseudoSelectorDescriptor mainDescriptor = PseudoSelectorsCompletionProvider.getMainDescriptor(descriptor);
            if (mainDescriptor == null) continue;
            int colonsDiff = Math.abs(mainDescriptor.getColonPrefixLength() - colonsCount);
            int priority = 10 - colonsDiff;
            if (descriptor instanceof CssNavigableDescriptor && (navElement = ((CssNavigableDescriptor)descriptor).getElement()) != null && (importedFiles = CssUtil.getImportedFiles(position.getContainingFile().getOriginalFile(), position, false)).contains(navElement.getContainingFile().getVirtualFile())) {
                ++priority;
            }
            result.addElement(CssCompletionUtil.lookupItemForDescriptor(descriptor, INSERT_HANDLER, priority));
        }
    }

    @Nullable
    private static CssPseudoSelectorDescriptor getMainDescriptor(@Nullable CssElementDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        CssElementDescriptor mainDescriptor = descriptor instanceof CssCompositeElementDescriptor ? ((CssCompositeElementDescriptor)descriptor).getDescriptorFromLatestSpec() : descriptor;
        return (CssPseudoSelectorDescriptor)ObjectUtils.tryCast((Object)mainDescriptor, CssPseudoSelectorDescriptor.class);
    }

    private static int calculateColonsCount(@NotNull Document document, int offset) {
        if (document == null) {
            PseudoSelectorsCompletionProvider.$$$reportNull$$$0(3);
        }
        int colonsCount = 0;
        CharSequence content = document.getCharsSequence();
        while (offset > 0 && content.charAt(offset - 1) == ':') {
            ++colonsCount;
            --offset;
        }
        return colonsCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/impl/util/completion/provider/PseudoSelectorsCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateColonsCount";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PseudoSelectorInsertHandler
    implements InsertHandler<LookupElement> {
        private PseudoSelectorInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            CssPseudoSelectorDescriptor pseudoSelectorDescriptor;
            Object elementObject;
            if (context == null) {
                PseudoSelectorInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                PseudoSelectorInsertHandler.$$$reportNull$$$0(1);
            }
            if ((elementObject = item.getObject()) instanceof CssDescriptorOwner) {
                elementObject = ContainerUtil.getFirstItem(((CssDescriptorOwner)elementObject).getDescriptors());
            }
            if (elementObject instanceof CssElementDescriptor && (pseudoSelectorDescriptor = PseudoSelectorsCompletionProvider.getMainDescriptor((CssElementDescriptor)elementObject)) != null) {
                PseudoSelectorInsertHandler.handleColons(context, pseudoSelectorDescriptor);
                if (pseudoSelectorDescriptor.hasArguments()) {
                    PseudoSelectorInsertHandler.handleParentheses(context);
                }
            }
        }

        private static void handleParentheses(InsertionContext context) {
            Editor editor = context.getEditor();
            if (context.getCompletionChar() == '(') {
                context.setAddCompletionChar(false);
            }
            Project project = editor.getProject();
            if (!PseudoSelectorInsertHandler.isStringAtLeftParenthesis(editor) && project != null) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"()");
                int offset = editor.getCaretModel().getOffset() - 1;
                if (offset > 0) {
                    editor.getCaretModel().moveToOffset(offset);
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            }
        }

        private static void handleColons(InsertionContext context, CssPseudoSelectorDescriptor descriptor) {
            int offset = context.getStartOffset();
            int colonsCount = PseudoSelectorsCompletionProvider.calculateColonsCount(context.getDocument(), offset);
            int expectedColonsCount = descriptor.getColonPrefixLength();
            if (expectedColonsCount > colonsCount) {
                context.getDocument().insertString(context.getStartOffset(), (CharSequence)":");
            } else {
                offset = context.getStartOffset() - colonsCount;
                for (int i = 0; i < colonsCount - expectedColonsCount; ++i) {
                    context.getDocument().deleteString(offset, offset + 1);
                }
            }
        }

        private static boolean isStringAtLeftParenthesis(Editor editor) {
            int startOffset = editor.getCaretModel().getOffset();
            Document document = editor.getDocument();
            return document.getTextLength() > startOffset && document.getCharsSequence().charAt(startOffset) == '(';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/impl/util/completion/provider/PseudoSelectorsCompletionProvider$PseudoSelectorInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

