/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

public class LanguageExtension<T>
extends KeyedExtensionCollector<T, Language> {
    private final T defaultImplementation;
    private final Key<T> cacheKey;
    private final Key<PersistentList<T>> allCacheKey;
    private final Key<PersistentList<T>> allCacheWithDefaultKey;

    public LanguageExtension(@NotNull ExtensionPointName<? extends KeyedLazyInstance<T>> epName) {
        if (epName == null) {
            LanguageExtension.$$$reportNull$$$0(0);
        }
        this(epName.getName(), null);
    }

    public LanguageExtension(@NotNull @NonNls String epName) {
        if (epName == null) {
            LanguageExtension.$$$reportNull$$$0(1);
        }
        this(epName, null);
    }

    public LanguageExtension(@NotNull ExtensionPointName<? extends KeyedLazyInstance<T>> epName, @Nullable T defaultImplementation) {
        if (epName == null) {
            LanguageExtension.$$$reportNull$$$0(2);
        }
        this(epName.getName(), defaultImplementation);
    }

    public LanguageExtension(@NonNls String epName, @Nullable T defaultImplementation) {
        super(epName);
        this.defaultImplementation = defaultImplementation;
        this.cacheKey = Key.create("EXTENSIONS_IN_LANGUAGE_" + epName);
        this.allCacheKey = Key.create("ALL_EXTENSIONS_IN_LANGUAGE_" + epName);
        this.allCacheWithDefaultKey = Key.create("ALL_EXTENSIONS_IN_LANGUAGE_" + epName + "_WITH_DEFAULT");
    }

    @Override
    @NotNull
    protected String keyToString(@NotNull Language key) {
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(3);
        }
        String string = key.getID();
        if (string == null) {
            LanguageExtension.$$$reportNull$$$0(4);
        }
        return string;
    }

    @TestOnly
    public void clearCache(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(5);
        }
        this.clearCacheForDerivedLanguages(language);
        this.clearCache();
    }

    private void clearCacheForDerivedLanguages(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(6);
        }
        for (Language dialect : ContainerUtil.concat(language.getTransitiveDialects(), Collections.singletonList(language))) {
            this.clearCacheForLanguage(dialect);
            for (MetaLanguage metaLanguage : LanguageUtil.matchingMetaLanguages(dialect)) {
                this.clearCacheForLanguage(metaLanguage);
            }
        }
        if (language instanceof MetaLanguage) {
            Collection<Language> matchingLanguages = ((MetaLanguage)language).getMatchingLanguages();
            for (Language matchingLanguage : matchingLanguages) {
                Collection<Language> dialects = matchingLanguage.getTransitiveDialects();
                this.clearCacheForLanguage(matchingLanguage);
                for (Language dialect : dialects) {
                    this.clearCacheForLanguage(dialect);
                }
            }
        }
    }

    private void clearCacheForLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(7);
        }
        language.putUserData(this.cacheKey, null);
        language.putUserData(this.allCacheKey, null);
        language.putUserData(this.allCacheWithDefaultKey, null);
        super.invalidateCacheForExtension(language.getID());
    }

    @Override
    public void invalidateCacheForExtension(@NotNull String key) {
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(8);
        }
        super.invalidateCacheForExtension(key);
        Language language = Language.findLanguageByID(key);
        if (language != null) {
            this.clearCacheForDerivedLanguages(language);
        }
    }

    public @UnknownNullability T forLanguage(@NotNull Language l) {
        T cached;
        if (l == null) {
            LanguageExtension.$$$reportNull$$$0(9);
        }
        if ((cached = l.getUserData(this.cacheKey)) != null) {
            return cached;
        }
        T result = this.findForLanguage(l);
        if (result == null) {
            return null;
        }
        result = l.putUserDataIfAbsent(this.cacheKey, result);
        return result;
    }

    protected T findForLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(10);
        }
        for (Language l = language; l != null; l = l.getBaseLanguage()) {
            List extensions = this.forKey(l);
            if (extensions.isEmpty()) continue;
            return extensions.get(0);
        }
        return this.defaultImplementation;
    }

    @NotNull
    public @Unmodifiable List<T> allForLanguage(@NotNull Language language) {
        List cached;
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(11);
        }
        if ((cached = (List)language.getUserData(this.allCacheKey)) != null) {
            List list = cached;
            if (list == null) {
                LanguageExtension.$$$reportNull$$$0(12);
            }
            return list;
        }
        PersistentList<T> result = this.collectAllForLanguage(language);
        List list = (List)language.putUserDataIfAbsent(this.allCacheKey, result);
        if (list == null) {
            LanguageExtension.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private PersistentList<T> collectAllForLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(14);
        }
        PersistentList result = ExtensionsKt.persistentListOf();
        for (Language l = language; l != null; l = l.getBaseLanguage()) {
            result = result.addAll(this.forKey(l));
        }
        PersistentList persistentList = result;
        if (persistentList == null) {
            LanguageExtension.$$$reportNull$$$0(15);
        }
        return persistentList;
    }

    @NotNull
    public final @Unmodifiable List<T> allForLanguageWithDefault(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(16);
        }
        if (this.defaultImplementation == null) {
            List<T> list = this.allForLanguage(language);
            if (list == null) {
                LanguageExtension.$$$reportNull$$$0(17);
            }
            return list;
        }
        List cached = (List)language.getUserData(this.allCacheWithDefaultKey);
        if (cached != null) {
            List list = cached;
            if (list == null) {
                LanguageExtension.$$$reportNull$$$0(18);
            }
            return list;
        }
        PersistentList result = this.collectAllForLanguage(language);
        if (!result.contains(this.defaultImplementation)) {
            result = result.add(this.defaultImplementation);
        }
        List list = (List)language.putUserDataIfAbsent(this.allCacheWithDefaultKey, result);
        if (list == null) {
            LanguageExtension.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Override
    @NotNull
    protected @Unmodifiable List<T> buildExtensions(@NotNull String stringKey, @NotNull Language key) {
        List<MetaLanguage> metaLanguages;
        if (stringKey == null) {
            LanguageExtension.$$$reportNull$$$0(20);
        }
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(21);
        }
        if ((metaLanguages = LanguageUtil.matchingMetaLanguages(key)).isEmpty()) {
            List list = super.buildExtensions(stringKey, key);
            if (list == null) {
                LanguageExtension.$$$reportNull$$$0(22);
            }
            return list;
        }
        HashSet<String> allKeys = new HashSet<String>(metaLanguages.size() + 1);
        allKeys.add(stringKey);
        for (MetaLanguage language : metaLanguages) {
            allKeys.add(this.keyToString(language));
        }
        List list = this.buildExtensions(allKeys);
        if (list == null) {
            LanguageExtension.$$$reportNull$$$0(23);
        }
        return list;
    }

    public @Unmodifiable @NotNull List<T> allForLanguageOrAny(@NotNull Language l) {
        if (l == null) {
            LanguageExtension.$$$reportNull$$$0(24);
        }
        List<T> forLanguage = this.allForLanguage(l);
        if (l == Language.ANY) {
            List<T> list = forLanguage;
            if (list == null) {
                LanguageExtension.$$$reportNull$$$0(25);
            }
            return list;
        }
        List<T> list = ContainerUtil.concat(forLanguage, this.allForLanguage(Language.ANY));
        if (list == null) {
            LanguageExtension.$$$reportNull$$$0(26);
        }
        return list;
    }

    @Override
    public void addExplicitExtension(@NotNull Language key, @NotNull T t) {
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(27);
        }
        if (t == null) {
            LanguageExtension.$$$reportNull$$$0(28);
        }
        this.clearCacheForLanguage(key);
        super.addExplicitExtension(key, t);
    }

    @Override
    public void removeExplicitExtension(@NotNull Language key, @NotNull T t) {
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(29);
        }
        if (t == null) {
            LanguageExtension.$$$reportNull$$$0(30);
        }
        this.clearCacheForLanguage(key);
        super.removeExplicitExtension(key, t);
    }

    protected T getDefaultImplementation() {
        return this.defaultImplementation;
    }

    @Override
    protected void ensureValuesLoaded() {
        super.ensureValuesLoaded();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 3: 
            case 8: 
            case 21: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/LanguageExtension";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 9: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringKey";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/LanguageExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "keyToString";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "allForLanguage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllForLanguage";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "allForLanguageWithDefault";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensions";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "allForLanguageOrAny";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "keyToString";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "clearCache";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "clearCacheForDerivedLanguages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "clearCacheForLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invalidateCacheForExtension";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findForLanguage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "allForLanguage";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectAllForLanguage";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "allForLanguageWithDefault";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensions";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "allForLanguageOrAny";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeExplicitExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

