/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snapround;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.index.kdtree.KdNode;
import org.locationtech.jts.index.kdtree.KdNodeVisitor;
import org.locationtech.jts.index.kdtree.KdTree;
import org.locationtech.jts.noding.snapround.HotPixel;

class HotPixelIndex {
    private PrecisionModel precModel;
    private double scaleFactor;
    private KdTree index = new KdTree();

    public HotPixelIndex(PrecisionModel pm) {
        this.precModel = pm;
        this.scaleFactor = pm.getScale();
    }

    public void add(Coordinate[] pts) {
        CoordinateShuffler it = new CoordinateShuffler(pts);
        while (it.hasNext()) {
            this.add((Coordinate)it.next());
        }
    }

    public void addNodes(List<Coordinate> pts) {
        for (Coordinate pt : pts) {
            HotPixel hp = this.add(pt);
            hp.setToNode();
        }
    }

    public HotPixel add(Coordinate p2) {
        Coordinate pRound = this.round(p2);
        HotPixel hp = this.find(pRound);
        if (hp != null) {
            hp.setToNode();
            return hp;
        }
        hp = new HotPixel(pRound, this.scaleFactor);
        this.index.insert(hp.getCoordinate(), hp);
        return hp;
    }

    private HotPixel find(Coordinate pixelPt) {
        KdNode kdNode = this.index.query(pixelPt);
        if (kdNode == null) {
            return null;
        }
        return (HotPixel)kdNode.getData();
    }

    private Coordinate round(Coordinate pt) {
        Coordinate p2 = pt.copy();
        this.precModel.makePrecise(p2);
        return p2;
    }

    public void query(Coordinate p0, Coordinate p1, KdNodeVisitor visitor2) {
        Envelope queryEnv = new Envelope(p0, p1);
        queryEnv.expandBy(1.0 / this.scaleFactor);
        this.index.query(queryEnv, visitor2);
    }

    private static final class CoordinateShuffler
    implements Iterator<Coordinate> {
        private final Random rnd = new Random(13L);
        private final Coordinate[] coordinates;
        private final int[] indices;
        private int index;

        public CoordinateShuffler(Coordinate[] pts) {
            this.coordinates = pts;
            this.indices = new int[pts.length];
            for (int i2 = 0; i2 < pts.length; ++i2) {
                this.indices[i2] = i2;
            }
            this.index = pts.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public Coordinate next() {
            int j = this.rnd.nextInt(this.index + 1);
            Coordinate res = this.coordinates[this.indices[j]];
            this.indices[j] = this.indices[this.index--];
            return res;
        }
    }
}

