/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.PgRoutineBodyHostBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockKt;
import com.intellij.sql.formatter.model.SqlCommentsFlowBlock;
import com.intellij.sql.formatter.model.SqlCommonHandlersKt;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlInjectionHostBlock;
import com.intellij.sql.formatter.model.SqlLanguageClauseBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlParametersBlock;
import com.intellij.sql.formatter.model.SqlPostfixClauseBlock;
import com.intellij.sql.formatter.model.SqlPrefixClauseBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlReturnBlock;
import com.intellij.sql.formatter.model.SqlRoutineDeclarationsSectionBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0014J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0016J\u0015\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0011H\u0010\u00a2\u0006\u0002\b\u0014J\b\u0010\u0015\u001a\u00020\u000bH\u0014J\b\u0010\u0016\u001a\u00020\u0005H\u0014J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/sql/formatter/model/SqlPgRoutineBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "<init>", "()V", "largeReturn", "", "bodyPassed", "whetherToFlatten", "node", "Lcom/intellij/lang/ASTNode;", "produceNestedBlocks", "", "nodes", "", "makeBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole", "role", "countRole$intellij_database_sql_core_impl", "configureFormattingAttributes", "userRequiresExpand", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlRoutineBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlRoutineBlock.kt\ncom/intellij/sql/formatter/model/SqlPgRoutineBlock\n+ 2 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlockKt\n*L\n1#1,415:1\n940#2,2:416\n940#2,2:418\n945#2,2:420\n945#2,2:422\n945#2,2:424\n945#2,2:426\n831#2,2:428\n1112#2,2:430\n*S KotlinDebug\n*F\n+ 1 SqlRoutineBlock.kt\ncom/intellij/sql/formatter/model/SqlPgRoutineBlock\n*L\n147#1:416,2\n154#1:418,2\n164#1:420,2\n165#1:422,2\n166#1:424,2\n168#1:426,2\n169#1:428,2\n171#1:430,2\n*E\n"})
public final class SqlPgRoutineBlock
extends SqlNodeBlock {
    private boolean largeReturn;
    private boolean bodyPassed;

    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return SqlImplUtil.isBodyLazyBlock(node.getPsi());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void produceNestedBlocks(@NotNull List<? extends ASTNode> nodes) {
        int d;
        SqlRangeBlock parent$iv;
        Object nodes$iv;
        SqlBlock sqlBlock;
        Object object;
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        int n = nodes.size();
        int significantIndex = 0;
        ASTNode aSTNode = (ASTNode)CollectionsKt.firstOrNull(nodes);
        if (CollectionsKt.contains((Iterable)SqlFormattingFunKt.getCOMMENT_TYPES(), (Object)(aSTNode != null ? aSTNode.getElementType() : null))) {
            void $this$withSetup$iv;
            int j;
            for (j = 1; j < n && SqlFormattingFunKt.getCOMMENT_AND_SPACES_TYPES().contains(nodes.get(j).getElementType()); ++j) {
            }
            significantIndex = j;
            Collection collection = this.getNestedBlocks();
            object = new SqlCommentsFlowBlock();
            sqlBlock = this;
            nodes$iv = nodes.subList(0, significantIndex);
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup(parent$iv, (List<? extends ASTNode>)nodes$iv);
            object = $this$withSetup$iv;
            collection.add(object);
        }
        if ((d = SqlUtilFun.indexOf$default(nodes, significantIndex, 0, 0, SqlPgRoutineBlock::produceNestedBlocks$lambda$0, 6, null)) > 0) {
            int b = SqlUtilFun.indexOf$default(nodes, d, 0, n, SqlPgRoutineBlock::produceNestedBlocks$lambda$1, 2, null);
            super.produceNestedBlocks(nodes.subList(significantIndex, d));
            if (d < b) {
                void parent$iv2;
                void $this$withSetup$iv;
                object = this.getNestedBlocks();
                parent$iv = new SqlRoutineDeclarationsSectionBlock();
                nodes$iv = this;
                List<? extends ASTNode> nodes$iv2 = nodes.subList(d, b);
                boolean $i$f$withSetup = false;
                $this$withSetup$iv.setup((SqlBlock)parent$iv2, nodes$iv2);
                sqlBlock = $this$withSetup$iv;
                object.add(sqlBlock);
            }
            if (b < n) {
                super.produceNestedBlocks(nodes.subList(b, n));
            }
        } else {
            super.produceNestedBlocks(nodes.subList(significantIndex, n));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        SqlBlock sqlBlock;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_PARAMETER_LIST))) {
            void parent$iv;
            void $this$withSetup$iv;
            SqlRangeBlock sqlRangeBlock = new SqlParametersBlock();
            SqlBlock sqlBlock2 = this;
            ASTNode outerNode$iv = node;
            boolean $i$f$withSetup = false;
            TextRange textRange = outerNode$iv.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            $this$withSetup$iv.setup$intellij_database_sql_core_impl((SqlBlock)parent$iv, textRange, SqlFormattingModelFun.listChildren(outerNode$iv));
            sqlBlock = SqlBlockKt.withRole((SqlBlock)$this$withSetup$iv, BlockRole.AMENDMENT);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_RETURNS_CLAUSE))) {
            SqlRangeBlock $this$withSetup$iv = new SqlReturnBlock();
            SqlBlock parent$iv = this;
            ASTNode outerNode$iv = node;
            boolean $i$f$withSetup = false;
            TextRange textRange = outerNode$iv.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent$iv, textRange, SqlFormattingModelFun.listChildren(outerNode$iv));
            sqlBlock = $this$withSetup$iv;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_LANGUAGE_CLAUSE))) {
            SqlRangeBlock $this$withSetup$iv = new SqlLanguageClauseBlock(this.bodyPassed);
            SqlBlock parent$iv = this;
            ASTNode outerNode$iv = node;
            boolean $i$f$withSetup = false;
            TextRange textRange = outerNode$iv.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent$iv, textRange, SqlFormattingModelFun.listChildren(outerNode$iv));
            sqlBlock = $this$withSetup$iv;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_COMMENT_CLAUSE)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_CLAUSE))) {
            SqlFlowBlock sqlFlowBlock;
            if (SqlFormattingModelFun.find((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.BODY) != null) {
                SqlRangeBlock $this$withSetup$iv = new SqlPostfixClauseBlock();
                SqlBlock parent$iv = this;
                ASTNode outerNode$iv = node;
                boolean $i$f$withSetup = false;
                TextRange textRange = outerNode$iv.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent$iv, textRange, SqlFormattingModelFun.listChildren(outerNode$iv));
                sqlFlowBlock = $this$withSetup$iv;
            } else {
                SqlNodeBlock $this$withSetup$iv = new SqlPrefixClauseBlock();
                SqlBlock parent$iv = this;
                ASTNode mainNode$iv = node;
                boolean $i$f$withSetup = false;
                $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent$iv, mainNode$iv);
                sqlFlowBlock = $this$withSetup$iv;
            }
            sqlBlock = sqlFlowBlock;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_STRING_LITERAL))) {
            if (SqlFormattingModelFun.hasInjection(node)) {
                void var3_8;
                SqlInjectionHostBlock $this$withSetup$iv = new PgRoutineBodyHostBlock();
                SqlBlock parent$iv = this;
                ASTNode node$iv = node;
                boolean $i$f$withSetup = false;
                $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent$iv, node$iv);
                sqlBlock = (SqlBlock)var3_8;
            } else {
                sqlBlock = super.makeBlock(node);
            }
        } else {
            sqlBlock = super.makeBlock(node);
        }
        return sqlBlock;
    }

    @Override
    @NotNull
    public BlockRole determineRole(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = iElementType;
        return Intrinsics.areEqual((Object)type, (Object)((Object)SqlCompositeElementTypes.SQL_FUNCTION_REFERENCE)) ? BlockRole.ALIAS1 : (Intrinsics.areEqual((Object)type, (Object)((Object)SqlCompositeElementTypes.SQL_BLOCK_STATEMENT)) ? BlockRole.BODY : (Intrinsics.areEqual((Object)type, (Object)((Object)SqlCompositeElementTypes.SQL_STRING_LITERAL)) ? BlockRole.BODY : (node instanceof SqlStatement ? BlockRole.BODY : super.determineRole(node))));
    }

    @Override
    public void countRole$intellij_database_sql_core_impl(@NotNull BlockRole role) {
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        super.countRole$intellij_database_sql_core_impl(role);
        if (role == BlockRole.BODY) {
            this.bodyPassed = true;
        }
    }

    @Override
    protected void configureFormattingAttributes() {
        SqlCodeStyleSettings s = this.getContext().getSql();
        Wrap mainWrap = SqlFlowBlock.makeWrap$default(this, WrapType.ALWAYS, false, 2, null);
        Wrap prefixOptionsWrap = null;
        Wrap postfixOptionsWrap = null;
        boolean wasLQuote = false;
        for (SqlBlock b : this.getNestedBlocks()) {
            IElementType t = SqlFormattingModelFun.primaryElementType(b);
            if (b.getRole() == BlockRole.BODY) {
                boolean toWrapEssence = wasLQuote ? s.ROUTINE_PG_L_QUOTE_WRAP_AFTER : true;
                b.setMyWrap((Wrap)(toWrapEssence ? mainWrap : null));
                b.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (b instanceof SqlRoutineDeclarationsSectionBlock) {
                b.setMyWrap(mainWrap);
                b.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                continue;
            }
            if (b instanceof SqlReturnBlock) {
                this.largeReturn = b.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS;
                b.setMyWrap((Wrap)(this.largeReturn ? mainWrap : null));
                b.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                continue;
            }
            if (b instanceof SqlPrefixClauseBlock) {
                if (prefixOptionsWrap == null) {
                    b.setMyWrap(mainWrap);
                    prefixOptionsWrap = SqlFlowBlock.makeWrap$intellij_database_sql_core_impl$default((SqlFlowBlock)this, mainWrap, WrapType.CHOP_DOWN_IF_LONG, false, 4, null);
                } else {
                    b.setMyWrap(postfixOptionsWrap);
                }
                b.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                continue;
            }
            if (b instanceof SqlPostfixClauseBlock) {
                if (postfixOptionsWrap == null) {
                    b.setMyWrap(mainWrap);
                    postfixOptionsWrap = SqlFlowBlock.makeWrap$intellij_database_sql_core_impl$default((SqlFlowBlock)this, mainWrap, WrapType.CHOP_DOWN_IF_LONG, false, 4, null);
                } else {
                    b.setMyWrap(postfixOptionsWrap);
                }
                b.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                continue;
            }
            if (b instanceof SqlLanguageClauseBlock) {
                if (((SqlLanguageClauseBlock)b).isPostfix$intellij_database_sql_core_impl()) continue;
                b.setMyWrap(mainWrap);
                continue;
            }
            if (t == SqlTokens.SQL_CREATE) {
                b.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (t == SqlTokens.SQL_AS || t == SqlTokens.SQL_IS) {
                b.setMyWrap((Wrap)(s.ROUTINE_AS_WRAP || this.largeReturn ? mainWrap : null));
                b.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (t == SqlTokens.SQL_CUSTOM_LQUOTE) {
                b.setMyWrap((Wrap)(s.ROUTINE_PG_L_QUOTE_WRAP_BEFORE ? mainWrap : null));
                b.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                wasLQuote = true;
                continue;
            }
            if (t == SqlTokens.SQL_CUSTOM_RQUOTE) {
                b.setMyWrap((Wrap)(s.ROUTINE_PG_R_QUOTE_WRAP_BEFORE ? mainWrap : null));
                b.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (t != SqlTokens.SQL_LANGUAGE) continue;
            b.setMyWrap(postfixOptionsWrap);
        }
        SqlCommonHandlersKt.configureAttributesForPostfixOptions(this, this.getNestedBlocks());
    }

    @Override
    protected boolean userRequiresExpand() {
        return true;
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        IElementType t1 = SqlFormattingModelFun.primaryElementType(block1);
        IElementType t2 = SqlFormattingModelFun.primaryElementType(block2);
        if (block2 instanceof SqlParametersBlock) {
            switch (this.getContext().getSql().ROUTINE_ARG_OPENING) {
                case 1: {
                    spacing = this.getContext().makeSpace(this.getContext().getCom().SPACE_BEFORE_METHOD_PARENTHESES || ((SqlParametersBlock)block2).getOpeningBlock() == null, false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null);
                    break;
                }
                default: {
                    spacing = SqlFormattingContext.makeSafeSpacing$default(this.getContext(), false, 1, null);
                    break;
                }
            }
        } else {
            spacing = t2 == SqlCompositeElementTypes.SQL_CLAUSE || t2 == SqlTokens.SQL_LANGUAGE ? this.getContext().makeAutoSpacing(true) : (t1 == SqlTokens.SQL_CUSTOM_RQUOTE ? (Intrinsics.areEqual((Object)t2, (Object)((Object)SqlCommonTokens.SQL_SEMICOLON)) ? SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null) : (this.getContext().getSql().ROUTINE_PG_R_QUOTE_WRAP_AFTER ? SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null) : SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null))) : super.decideSpacing(block1, block2));
        }
        return spacing;
    }

    private static final boolean produceNestedBlocks$lambda$0(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IElementType iElementType = it.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType t = iElementType;
        return t instanceof IStubElementType && t != SqlCompositeElementTypes.SQL_RETURNS_CLAUSE;
    }

    private static final boolean produceNestedBlocks$lambda$1(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getElementType(), (Object)((Object)SqlCompositeElementTypes.SQL_BLOCK_STATEMENT)) || it.getElementType() == SqlTokens.SQL_BEGIN;
    }
}

