/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sql92;

import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.base.SqlEvaluationHelperBase;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.script.SqlScriptTraverserCreatorImpl;
import com.intellij.util.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0016J:\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\t0\u000e\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0014R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/dialects/sql92/Sql92EvaluationHelper;", "Lcom/intellij/sql/dialects/base/SqlEvaluationHelperBase;", "<init>", "()V", "fakeStatementElementType", "Lcom/intellij/sql/psi/SqlCompositeElementType;", "kotlin.jvm.PlatformType", "isStatement", "Lcom/intellij/openapi/util/Condition;", "V", "", "api", "Lcom/intellij/psi/SyntaxTraverser$Api;", "parse", "Lcom/intellij/psi/SyntaxTraverser;", "project", "Lcom/intellij/openapi/project/Project;", "language", "Lcom/intellij/lang/Language;", "documentText", "", "hostLanguage", "intellij.database.dialects.sql92"})
public final class Sql92EvaluationHelper
extends SqlEvaluationHelperBase {
    private final SqlCompositeElementType fakeStatementElementType = SqlCompositeElementTypes.SQL_STATEMENT;

    @Override
    @NotNull
    public <V> Condition<V> isStatement(@NotNull SyntaxTraverser.Api<V> api) {
        Intrinsics.checkNotNullParameter(api, (String)"api");
        Condition condition = Conditions.or(super.isStatement(api), (Condition)Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.equalTo((Object)((Object)this.fakeStatementElementType))));
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"or(...)");
        return condition;
    }

    @Override
    @NotNull
    protected <V> SyntaxTraverser<V> parse(@NotNull Project project, @NotNull Language language, @NotNull CharSequence documentText, @Nullable Language hostLanguage) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)documentText, (String)"documentText");
        DatabaseSettings.SplitScriptMode splitScriptMode = DatabaseSettings.getSettings().splitScriptMode;
        if (splitScriptMode == DatabaseSettings.SplitScriptMode.ON_STATEMENTS) {
            object = super.parse(project, language, documentText, hostLanguage);
        } else {
            PsiFile psiFile = SqlPsiElementFactory.createROFileFromText(documentText, language, project, hostLanguage);
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createROFileFromText(...)");
            PsiFile file = psiFile;
            object = SqlScriptTraverserCreatorImpl.getScriptTraverser(file, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApi(), language, documentText, splitScriptMode, this.fakeStatementElementType);
        }
        SyntaxTraverser traverser = object;
        traverser.putUserData(ScriptModelUtilCore.SPLIT_SCRIPT_MODE, (Object)splitScriptMode);
        Intrinsics.checkNotNull(traverser, (String)"null cannot be cast to non-null type com.intellij.psi.SyntaxTraverser<V of com.intellij.sql.dialects.sql92.Sql92EvaluationHelper.parse>");
        return traverser;
    }
}

