/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.BaseAffectAnalyzer;
import com.intellij.database.introspection.BelongingAreaKind;
import com.intellij.database.introspection.ObjectEffectType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.SearchPath;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.postgres.psi.PgCreatePolicyStatement;
import com.intellij.sql.dialects.postgres.psi.PgCreateRuleStatement;
import com.intellij.sql.dialects.postgres.psi.PgCreateTriggerStatementImpl;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlCreateIndexStatementImpl;
import com.intellij.sql.psi.impl.SqlDropStatementImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlRenameToClauseImpl;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001e\u0010\b\u001a\u00060\tR\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/postgres/PgBaseAffectAnalyzer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;", "<init>", "()V", "determineBelongingKind", "Lcom/intellij/database/introspection/BelongingAreaKind;", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "prepareDeterminer", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "dbms", "Lcom/intellij/database/Dbms;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "Companion", "PgBaseDeterminer", "intellij.database.dialects.postgres"})
public final class PgBaseAffectAnalyzer
extends BaseAffectAnalyzer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    @JvmField
    @NotNull
    public static final ObjectOpenHashSet<ObjectKind> schemaKinds;

    @Override
    @Nullable
    protected BelongingAreaKind determineBelongingKind(@NotNull ObjectKind objectKind) {
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        ObjectKind objectKind2 = objectKind;
        return schemaKinds.contains((Object)objectKind2) ? BelongingAreaKind.A_SCHEMA : null;
    }

    @Override
    @NotNull
    protected BaseAffectAnalyzer.Determiner prepareDeterminer(@NotNull Dbms dbms, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return new PgBaseDeterminer(searchPath);
    }

    static {
        Object[] objectArray = new ObjectKind[]{ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.MAT_VIEW, ObjectKind.OBJECT_TYPE, ObjectKind.SEQUENCE, ObjectKind.ROUTINE, ObjectKind.AGGREGATE, ObjectKind.COLLATION, ObjectKind.OPERATOR, ObjectKind.OPERATOR_CLASS, ObjectKind.OPERATOR_FAMILY, ObjectKind.FOREIGN_TABLE};
        ObjectOpenHashSet objectOpenHashSet = ObjectOpenHashSet.of((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)objectOpenHashSet, (String)"of(...)");
        schemaKinds = objectOpenHashSet;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/postgres/PgBaseAffectAnalyzer$Companion;", "", "<init>", "()V", "schemaKinds", "Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.dialects.postgres"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/postgres/PgBaseAffectAnalyzer$PgBaseDeterminer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$MultiDatabaseDeterminer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "<init>", "(Lcom/intellij/database/dialects/postgres/PgBaseAffectAnalyzer;Lcom/intellij/database/util/SearchPath;)V", "analyzeCreateStatement", "", "statement", "Lcom/intellij/sql/psi/SqlCreateStatement;", "analyzeAlterStatement", "Lcom/intellij/sql/psi/SqlAlterStatement;", "analyzeDropStatement", "Lcom/intellij/sql/psi/impl/SqlDropStatementImpl;", "getTarget", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "e", "Lcom/intellij/psi/PsiElement;", "intellij.database.dialects.postgres"})
    @SourceDebugExtension(value={"SMAP\nPgBaseAffectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgBaseAffectAnalyzer.kt\ncom/intellij/database/dialects/postgres/PgBaseAffectAnalyzer$PgBaseDeterminer\n+ 2 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$Companion\n*L\n1#1,93:1\n234#2:94\n234#2:95\n*S KotlinDebug\n*F\n+ 1 PgBaseAffectAnalyzer.kt\ncom/intellij/database/dialects/postgres/PgBaseAffectAnalyzer$PgBaseDeterminer\n*L\n65#1:94\n89#1:95\n*E\n"})
    private final class PgBaseDeterminer
    extends BaseAffectAnalyzer.MultiDatabaseDeterminer {
        public PgBaseDeterminer(SearchPath searchPath) {
            super(searchPath);
        }

        @Override
        protected void analyzeCreateStatement(@NotNull SqlCreateStatement statement) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            SqlCreateStatement sqlCreateStatement = statement;
            if (sqlCreateStatement instanceof SqlCreateIndexStatementImpl || sqlCreateStatement instanceof PgCreateTriggerStatementImpl || sqlCreateStatement instanceof PgCreateRuleStatement) {
                BaseAffectAnalyzer.Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_ALTERED, BelongingAreaKind.A_SCHEMA, ObjectKind.SCHEMA_OBJECT, this.getTarget(statement), 0, 16, null);
            } else if (sqlCreateStatement instanceof PgCreatePolicyStatement) {
                BaseAffectAnalyzer.Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_ALTERED, BelongingAreaKind.A_SCHEMA, ObjectKind.TABLE, this.getTarget(statement), 0, 16, null);
            } else {
                super.analyzeCreateStatement(statement);
            }
        }

        @Override
        protected void analyzeAlterStatement(@NotNull SqlAlterStatement statement) {
            ObjectKind kind;
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            SqlReferenceExpression sqlReferenceExpression = statement.getAlterTargetReference();
            if (sqlReferenceExpression == null) {
                return;
            }
            SqlReferenceExpression objectRef = sqlReferenceExpression;
            ObjectKind objectKind = objectRef.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
            ObjectKind objectKind2 = kind = objectKind;
            if (Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.SECURITY_POLICY)) {
                BaseAffectAnalyzer.Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_ALTERED, BelongingAreaKind.A_SCHEMA, ObjectKind.TABLE, this.getTarget((PsiElement)statement), 0, 16, null);
            } else if (Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.TRIGGER) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.RULE)) {
                BaseAffectAnalyzer.Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_ALTERED, BelongingAreaKind.A_SCHEMA, ObjectKind.SCHEMA_OBJECT, this.getTarget((PsiElement)statement), 0, 16, null);
            } else {
                BaseAffectAnalyzer.Companion companion = BaseAffectAnalyzer.Companion;
                PsiElement $this$child$iv = (PsiElement)statement;
                boolean $i$f$child = false;
                SqlRenameToClauseImpl renameClause = (SqlRenameToClauseImpl)PsiTreeUtil.findChildOfType((PsiElement)$this$child$iv, SqlRenameToClauseImpl.class, (boolean)false);
                if (renameClause != null) {
                    this.handleRename(BelongingAreaKind.A_SCHEMA, objectRef, renameClause.getNameElement());
                } else {
                    super.analyzeAlterStatement(statement);
                }
                return;
            }
        }

        @Override
        protected void analyzeDropStatement(@NotNull SqlDropStatementImpl statement) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            ObjectKind objectKind = statement.getTargetType();
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TRIGGER) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.RULE)) {
                BaseAffectAnalyzer.Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_ALTERED, BelongingAreaKind.A_SCHEMA, ObjectKind.SCHEMA_OBJECT, this.getTarget((PsiElement)statement), 0, 16, null);
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SECURITY_POLICY)) {
                BaseAffectAnalyzer.Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_ALTERED, BelongingAreaKind.A_SCHEMA, ObjectKind.TABLE, this.getTarget((PsiElement)statement), 0, 16, null);
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.INDEX)) {
                BaseAffectAnalyzer.Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_DROPPED, BelongingAreaKind.A_SCHEMA, ObjectKind.INDEX, statement.getTargetExpression(), 0, 16, null);
            } else {
                super.analyzeDropStatement(statement);
            }
        }

        private final SqlReferenceExpression getTarget(PsiElement e) {
            SqlOnTargetClauseImpl targetClause;
            Object object = BaseAffectAnalyzer.Companion;
            PsiElement $this$child$iv = e;
            boolean $i$f$child = false;
            SqlOnTargetClauseImpl sqlOnTargetClauseImpl = targetClause = (SqlOnTargetClauseImpl)PsiTreeUtil.findChildOfType((PsiElement)$this$child$iv, SqlOnTargetClauseImpl.class, (boolean)false);
            object = sqlOnTargetClauseImpl != null ? sqlOnTargetClauseImpl.getTargetExpression() : null;
            return object instanceof SqlReferenceExpression ? (SqlReferenceExpression)object : null;
        }
    }
}

